/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.aspects.sql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlTableAspect;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.TreeMappingRoot;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlElement;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.xml.PluginConstants;
import org.teiid.designer.xml.aspects.sql.AbstractXmlDocumentEntitySqlAspect;

public class XmlElementSqlAspect
extends AbstractXmlDocumentEntitySqlAspect
implements SqlColumnAspect {
    static final boolean SELECTABLE = true;
    static final boolean UPDATABLE = false;
    static final boolean AUTO_INCREMENT = false;
    static final boolean CASE_SENSITIVE = false;
    static final boolean SIGNED = false;
    static final boolean CURRENCY = false;
    static final boolean FIXED_LENGTH = false;
    static final boolean TRANSFORMATION_INPUT_PARAMETER = false;
    static final int SEARCH_TYPE = 0;
    static final Object DEFAULT_VALUE = null;
    static final Object MIN_VALUE = null;
    static final Object MAX_VALUE = null;
    static final int LENGTH = 0;
    static final int SCALE = 0;
    static final int NULL_TYPE = 1;
    static final String FORMAT = null;
    static final int PRECISION = 0;
    static final int CHAR_OCTET_LENGTH = 0;
    static final int POSITION = 0;
    static final int RADIX = 0;
    static final int NULL_VALUES = 0;
    static final int DISTINCT_VALUES = 0;
    private Map elementMap = null;
    private Set elementFullNames;
    private String currentDocumentName;

    public XmlElementSqlAspect(MetamodelEntity entity) {
        super(entity);
    }

    public boolean isRecordType(char recordType) {
        return recordType == 'G';
    }

    public String getName(EObject eObject) {
        CoreArgCheck.isInstanceOf(XmlElement.class, (Object)eObject);
        Path path = new Path(this.getShortName(eObject));
        EObject parent = eObject.eContainer();
        SqlAspect parentAspect = AspectManager.getSqlAspect((EObject)parent);
        while (parentAspect != null) {
            if (parent instanceof XmlDocument) break;
            if (parentAspect instanceof SqlColumnAspect) {
                String name = null;
                name = parentAspect instanceof AbstractXmlDocumentEntitySqlAspect ? ((AbstractXmlDocumentEntitySqlAspect)parentAspect).getShortName(parent) : parentAspect.getName(parent);
                path = new Path("").append(name).append((IPath)path);
            } else if (parentAspect instanceof SqlTableAspect) break;
            parent = parent.eContainer();
            parentAspect = AspectManager.getSqlAspect((EObject)parent);
        }
        return path.toString().replace('/', '.');
    }

    @Override
    protected String getShortName(EObject eObject) {
        CoreArgCheck.isInstanceOf(XmlElement.class, (Object)eObject);
        return ((XmlElement)eObject).getName();
    }

    @Override
    protected String getParentFullName(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent != null) {
            SqlAspect parentAspect = AspectManager.getSqlAspect((EObject)parent);
            while (parentAspect != null) {
                if (parentAspect instanceof SqlTableAspect) {
                    return parentAspect.getFullName(parent);
                }
                if ((parent = parent.eContainer()) != null) {
                    parentAspect = AspectManager.getSqlAspect((EObject)parent);
                    continue;
                }
                return null;
            }
        }
        return null;
    }

    public int getCharOctetLength(EObject eObject) {
        return 0;
    }

    public EObject getDatatype(EObject eObject) {
        Object lookupObj;
        CoreArgCheck.isInstanceOf(XmlElement.class, (Object)eObject);
        XmlElement xmlElement = (XmlElement)eObject;
        if (this.elementMap == null) {
            this.populateMappingInfo((EObject)xmlElement);
        }
        if ((lookupObj = this.elementMap.get(xmlElement)) == null && (this.elementFullNames.contains(this.getFullName((EObject)xmlElement)) || !this.currentDocumentName.equals(this.getXmlDocument((EObject)xmlElement).getName()))) {
            this.populateMappingInfo((EObject)xmlElement);
            lookupObj = this.elementMap.get(xmlElement);
        }
        Container cntr = ModelerCore.getContainer((EObject)eObject);
        if (lookupObj != null) {
            CoreArgCheck.isInstanceOf(MappingClassColumn.class, lookupObj, null);
            MappingClassColumn mappingColumn = (MappingClassColumn)lookupObj;
            EObject type = mappingColumn.getType();
            return this.resolveWhenProxy(type, (ResourceSet)cntr);
        }
        try {
            XSDTypeDefinition type;
            XSDComponent xsdComp = xmlElement.getXsdComponent();
            if (xsdComp instanceof XSDElementDeclaration && (type = ((XSDElementDeclaration)xsdComp).getTypeDefinition()) != null) {
                return this.resolveWhenProxy((EObject)type, (ResourceSet)cntr);
            }
            return ModelerCore.getDatatypeManager((EObject)eObject).getBuiltInDatatype("string");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private EObject resolveWhenProxy(EObject e, ResourceSet resolveContext) {
        EObject resolvedEObject = e;
        if (e != null && e.eIsProxy() && (resolvedEObject = EcoreUtil.resolve((EObject)e, (ResourceSet)resolveContext)).eIsProxy()) {
            String msg = PluginConstants.Util.getString("XmlElementSqlAspect.Unable_to_resolve_proxy_with_uri", (Object)((InternalEObject)e).eProxyURI());
            PluginConstants.Util.log(4, msg);
        }
        return resolvedEObject;
    }

    public String getNativeType(EObject eObject) {
        return null;
    }

    public String getDatatypeName(EObject eObject) {
        EObject datatype = this.getDatatype(eObject);
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true);
        String dtName = dtMgr.getName(datatype);
        return dtName == null ? "string" : dtName;
    }

    public String getDatatypeObjectID(EObject eObject) {
        DatatypeManager dtMgr;
        String uuid;
        EObject datatype = this.getDatatype(eObject);
        try {
            if (datatype == null) {
                datatype = ModelerCore.getWorkspaceDatatypeManager().getBuiltInDatatype("string");
            }
        }
        catch (Throwable throwable) {}
        return (uuid = (dtMgr = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true)).getUuidString(datatype)) == null ? "" : uuid;
    }

    public Object getDefaultValue(EObject eObject) {
        return DEFAULT_VALUE;
    }

    public String getFormat(EObject eObject) {
        return FORMAT;
    }

    public int getLength(EObject eObject) {
        return 0;
    }

    public Object getMaxValue(EObject eObject) {
        return MAX_VALUE;
    }

    public Object getMinValue(EObject eObject) {
        return MIN_VALUE;
    }

    public int getNullType(EObject eObject) {
        return 1;
    }

    public int getPosition(EObject eObject) {
        return 0;
    }

    public int getPrecision(EObject eObject) {
        return 0;
    }

    public int getRadix(EObject eObject) {
        return 0;
    }

    public int getDistinctValues(EObject eObject) {
        return 0;
    }

    public int getNullValues(EObject eObject) {
        return 0;
    }

    public String getRuntimeType(EObject eObject) {
        String runtimeType = null;
        EObject datatype = this.getDatatype(eObject);
        if (datatype != null) {
            runtimeType = ModelerCore.getDatatypeManager((EObject)eObject, (boolean)true).getRuntimeTypeName(datatype);
        }
        if (runtimeType == null) {
            runtimeType = "string";
        }
        return runtimeType;
    }

    public int getScale(EObject eObject) {
        return 0;
    }

    public int getSearchType(EObject eObject) {
        return 0;
    }

    public boolean isAutoIncrementable(EObject eObject) {
        return false;
    }

    public boolean isCaseSensitive(EObject eObject) {
        return false;
    }

    public boolean isCurrency(EObject eObject) {
        return false;
    }

    public boolean isFixedLength(EObject eObject) {
        return false;
    }

    public boolean isSelectable(EObject eObject) {
        return true;
    }

    public boolean isSigned(EObject eObject) {
        return false;
    }

    public boolean isTranformationInputParameter(EObject eObject) {
        EmfResource emfResource;
        ModelContents contents;
        CoreArgCheck.isInstanceOf(XmlElement.class, (Object)eObject);
        XmlElement element = (XmlElement)eObject;
        if (element instanceof XmlRoot) {
            return false;
        }
        XmlDocument doc = this.getDocParent(element);
        XmlElement parent = this.getElementParent(element);
        if (doc == null || parent == null) {
            return false;
        }
        Resource eResource = element.eResource();
        if (eResource instanceof EmfResource && (contents = (emfResource = (EmfResource)eResource).getModelContents()) != null) {
            for (TreeMappingRoot tmr : contents.getTransformations((EObject)doc)) {
                if (!tmr.getOutputs().contains((Object)parent)) continue;
                for (Mapping mapping : tmr.getNested()) {
                    if (!mapping.getOutputs().contains((Object)element)) continue;
                    if (mapping.getInputs().size() == 0) {
                        return false;
                    }
                    for (MappingClassColumn column : mapping.getInputs()) {
                        SqlAspect aspect = AspectManager.getSqlAspect((EObject)column);
                        if (!(aspect instanceof SqlColumnAspect)) {
                            return false;
                        }
                        if (((SqlColumnAspect)aspect).isTranformationInputParameter((EObject)column)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private XmlDocument getDocParent(XmlElement child) {
        if (child == null) {
            return null;
        }
        EObject parent = child.eContainer();
        while (parent != null) {
            if (parent instanceof XmlDocument) {
                return (XmlDocument)parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    private XmlElement getElementParent(XmlElement child) {
        if (child == null) {
            return null;
        }
        EObject parent = child.eContainer();
        while (parent != null) {
            if (parent instanceof XmlElement) {
                return (XmlElement)parent;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    public boolean isUpdatable(EObject eObject) {
        return false;
    }

    public boolean canSetDatatype() {
        return false;
    }

    public void setDatatype(EObject eObject, EObject datatype) {
        throw new UnsupportedOperationException(PluginConstants.Util.getString("XmlElementSqlAspect.Datatype_cannot_be_set_on_an_XMLElement_1", new Object[0]));
    }

    public boolean canSetLength() {
        return false;
    }

    public void setLength(EObject eObject, int length) {
        throw new UnsupportedOperationException(PluginConstants.Util.getString("XmlElementSqlAspect.Length_cannot_be_set_on_an_XMLElement_2", new Object[0]));
    }

    public boolean canSetNullType() {
        return false;
    }

    public void setNullType(EObject eObject, int nullType) {
        throw new UnsupportedOperationException(PluginConstants.Util.getString("XmlElementSqlAspect.NullType_cannot_be_set_on_an_XMLElement_3", new Object[0]));
    }

    Map getMappingInfo(EObject xmlEntity) {
        if (this.elementMap != null) {
            return this.elementMap;
        }
        this.populateMappingInfo(xmlEntity);
        return this.elementMap;
    }

    private void populateMappingInfo(EObject xmlEntity) {
        Resource resource = xmlEntity.eResource();
        ModelContents mdlContents = new ModelContents(resource);
        XmlDocument document = this.getXmlDocument(xmlEntity);
        this.currentDocumentName = document.getName();
        this.elementMap = new HashMap();
        this.elementFullNames = new HashSet();
        for (MappingRoot mappingRoot : mdlContents.getTransformations((EObject)document)) {
            if (mappingRoot == null || !(mappingRoot instanceof TreeMappingRoot)) continue;
            for (Mapping nestedMapping : mappingRoot.getNested()) {
                EList inputs = nestedMapping.getInputs();
                EList outputs = nestedMapping.getOutputs();
                if (outputs.isEmpty() || inputs.isEmpty()) continue;
                Object output = outputs.iterator().next();
                Object input = inputs.iterator().next();
                this.elementMap.put(output, input);
                if (!(output instanceof XmlElement)) continue;
                this.elementFullNames.add(this.getFullName((EObject)output));
            }
        }
    }

    private XmlDocument getXmlDocument(EObject xmlElement) {
        EObject container = xmlElement.eContainer();
        EObject document = null;
        while (container != null) {
            document = container;
            container = container.eContainer();
        }
        CoreArgCheck.isInstanceOf(XmlDocument.class, (Object)document, null);
        return (XmlDocument)document;
    }

    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    public boolean isDatatypeFeature(EObject eObject, EStructuralFeature eFeature) {
        return false;
    }
}

