/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.pf.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class NewPageFlowWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileNameText;
    private Button browseButton;
    private IWorkspaceRoot workspaceRoot;
    private String containerName;

    public NewPageFlowWizardPage() {
        super("Page Flow");
        this.setTitle("Create Page Flow");
        this.setDescription("Create a new page flow");
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    }

    public void init(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            this.initContainerName(this.getSelectedElement(selection));
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = this.createClientArea(parent);
        this.createContainerField(composite);
        this.createFileNameField(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(false);
    }

    private Composite createClientArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void createContainerField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("Source folder : ");
        this.containerText = new Text(parent, 2048);
        this.containerText.setText(this.containerName == null ? "" : this.containerName);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPageFlowWizardPage.this.verifyContentsValid();
            }
        });
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.browseButton = new Button(parent, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPageFlowWizardPage.this.chooseContainer();
            }
        });
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(15);
        this.browseButton.setLayoutData((Object)gd);
    }

    private void createFileNameField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("File name : ");
        this.fileNameText = new Text(parent, 2048);
        this.fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPageFlowWizardPage.this.verifyContentsValid();
            }
        });
        GridData gd = new GridData(768);
        this.fileNameText.setLayoutData((Object)gd);
    }

    private void chooseContainer() {
        WorkbenchContentProvider provider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setTitle("Folder Selection");
        dialog.setMessage("Choose a folder");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.open();
        this.initContainerName((IResource)dialog.getFirstResult());
        if (this.containerName != null) {
            this.containerText.setText(this.containerName);
        }
    }

    private IResource getSelectedElement(IStructuredSelection selection) {
        Object selectedElement;
        IResource resource = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable) {
            resource = (IResource)((IAdaptable)selectedElement).getAdapter(IResource.class);
        }
        return resource;
    }

    private void initContainerName(IResource resource) {
        while (resource != null && !(resource instanceof IContainer)) {
            resource = resource.getParent();
        }
        this.containerName = resource == null ? null : ((IContainer)resource).getFullPath().toString();
    }

    private void verifyContentsValid() {
        if (!this.checkContainerPathValid()) {
            this.setErrorMessage("The folder does not exist.");
            this.setPageComplete(false);
        } else if (this.isFileNameEmpty()) {
            this.setErrorMessage("Enter a file name.");
            this.setPageComplete(false);
        } else if (this.fileExists()) {
            this.setErrorMessage("A file with this name already exists.");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private boolean fileExists() {
        return this.getPageFlowFile().exists();
    }

    private boolean isFileNameEmpty() {
        String str = this.fileNameText.getText();
        return str == null || "".equals(str);
    }

    private boolean checkContainerPathValid() {
        Path path = new Path(this.containerText.getText());
        if (path.segmentCount() == 0) {
            return false;
        }
        if (path.segmentCount() == 1) {
            return this.workspaceRoot.getProject(path.segment(0)).exists();
        }
        return this.workspaceRoot.getFolder((IPath)path).exists();
    }

    public String getFileName() {
        String fileName = this.fileNameText.getText();
        if (fileName.length() <= 4 || fileName.length() > 4 && !".xml".equals(fileName.substring(fileName.length() - 4))) {
            fileName = String.valueOf(fileName) + ".xml";
        }
        return fileName;
    }

    public IContainer getProcessFolder() {
        Path path = new Path(this.containerText.getText());
        if (path.segmentCount() == 0) {
            return null;
        }
        if (path.segmentCount() == 1) {
            return this.workspaceRoot.getProject(path.segment(0));
        }
        return this.workspaceRoot.getFolder((IPath)path);
    }

    public IFile getPageFlowFile() {
        return this.getProcessFolder().getFile((IPath)new Path(this.getFileName()));
    }
}

