/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.DescribableElement;
import org.jbpm.gd.jpdl.model.Description;

public class DescribableElementConfigurationComposite
implements FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Text descriptionText;
    private Label descriptionLabel;
    private DescribableElement describableElement;
    private Description description;

    public static DescribableElementConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        DescribableElementConfigurationComposite result = new DescribableElementConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private DescribableElementConfigurationComposite() {
    }

    public void setDescribableElement(DescribableElement describableElement) {
        if (this.describableElement == describableElement) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.describableElement = describableElement;
        if (describableElement != null) {
            this.updateControls();
            this.hookSelectionListener();
        }
    }

    private void hookSelectionListener() {
        this.descriptionText.addFocusListener((FocusListener)this);
    }

    private void unhookSelectionListener() {
        this.descriptionText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.descriptionText.setText("");
    }

    private void updateControls() {
        this.description = this.describableElement.getDescription();
        String str = "";
        if (this.description != null && this.description.getDescription() != null) {
            str = this.description.getDescription();
        }
        this.descriptionText.setText(str);
    }

    private void create() {
        this.descriptionLabel = this.widgetFactory.createLabel(this.parent, "Description");
        this.descriptionText = this.widgetFactory.createText(this.parent, "", 514);
        this.descriptionLabel.setLayoutData((Object)this.createDescriptionLabelLayoutData());
        this.descriptionText.setLayoutData((Object)this.createDescriptionTextLayoutData());
    }

    private FormData createDescriptionLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 2);
        return data;
    }

    private FormData createDescriptionTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.descriptionText) {
            String str = this.descriptionText.getText();
            Description description = this.describableElement.getDescription();
            if ("".equals(str)) {
                this.describableElement.setDescription(null);
            } else {
                if (description == null) {
                    description = (Description)this.describableElement.getFactory().createById("org.jbpm.gd.jpdl.description");
                    this.describableElement.setDescription(description);
                }
                description.setDescription(str);
            }
        }
    }
}

