/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.util.BooleanTypeHelper;

public class ActionAdvancedConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Button asyncButton;
    private Button acceptPropagatedEventsButton;
    private Action action;

    public static ActionAdvancedConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ActionAdvancedConfigurationComposite result = new ActionAdvancedConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private ActionAdvancedConfigurationComposite() {
    }

    public void setAction(Action action) {
        if (this.action == action) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.action = action;
        if (action != null) {
            this.updateControls();
            this.hookSelectionListener();
        }
    }

    private void hookSelectionListener() {
        this.asyncButton.addSelectionListener((SelectionListener)this);
        this.acceptPropagatedEventsButton.addSelectionListener((SelectionListener)this);
    }

    private void unhookSelectionListener() {
        this.asyncButton.removeSelectionListener((SelectionListener)this);
        this.acceptPropagatedEventsButton.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.acceptPropagatedEventsButton.setSelection(false);
        this.asyncButton.setSelection(false);
    }

    private void updateControls() {
        this.acceptPropagatedEventsButton.setSelection(BooleanTypeHelper.booleanValue(this.action.getAcceptPropagatedEvents()));
        this.asyncButton.setSelection(BooleanTypeHelper.booleanValue(this.action.getAsync()));
    }

    private void create() {
        this.asyncButton = this.widgetFactory.createButton(this.parent, "Asynchronous", 32);
        this.acceptPropagatedEventsButton = this.widgetFactory.createButton(this.parent, "Accept Propagated Events", 32);
        this.asyncButton.setLayoutData((Object)this.createAsyncButtonLayoutData());
        this.acceptPropagatedEventsButton.setLayoutData((Object)this.createAcceptPropagatedEventsButtonLayoutData());
    }

    private FormData createAcceptPropagatedEventsButtonLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createAsyncButtonLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.acceptPropagatedEventsButton, 0);
        return data;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.asyncButton) {
            this.action.setAsync(this.asyncButton.getSelection() ? "true" : "false");
        } else if (e.widget == this.acceptPropagatedEventsButton) {
            this.action.setAcceptPropagatedEvents(this.acceptPropagatedEventsButton.getSelection() ? "true" : "false");
        }
    }
}

