/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GenericElementXmlAdapter
extends XmlAdapter {
    private static HashMap NODE_TYPES = null;

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("genericElement", "genericElement");
        }
        return NODE_TYPES;
    }

    protected String getNodeType(String elementType) {
        return "genericElement";
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        if (jpdlElement == null || !(jpdlElement instanceof GenericElement)) {
            return;
        }
        GenericElement genericElement = (GenericElement)jpdlElement;
        genericElement.setName(this.getNode().getNodeName());
        genericElement.setValue(this.getTextContent());
        NamedNodeMap attributes = this.getNode().getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            genericElement.addGenericAttribute(node.getNodeName(), node.getNodeValue());
            ++i;
        }
        genericElement.addPropertyChangeListener(this);
    }

    protected void initialize() {
        super.initialize();
        GenericElement genericElement = (GenericElement)this.getSemanticElement();
        if (genericElement != null) {
            GenericElement[] genericElements = genericElement.getGenericElements();
            int i = 0;
            while (i < genericElements.length) {
                this.addElement(genericElements[i]);
                ++i;
            }
            Map attributes = genericElement.getGenericAttibutes();
            for (String name : attributes.keySet()) {
                String value = (String)attributes.get(name);
                this.setAttribute(name, value);
            }
            this.setTextContent(genericElement.getValue());
        }
    }

    protected void doPropertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName())) {
            this.setTextContent((String)evt.getNewValue());
        } else if ("genericElementAdd".equals(evt.getPropertyName())) {
            this.addElement((GenericElement)evt.getNewValue());
        } else if ("genericElementRemove".equals(evt.getPropertyName())) {
            this.removeElement((GenericElement)evt.getOldValue());
        } else {
            this.setAttribute(evt.getPropertyName(), (String)evt.getNewValue());
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        GenericElement genericElement = (GenericElement)this.getSemanticElement();
        if (genericElement != null && "#text".equals(name)) {
            genericElement.setValue(newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        if (this.getElementType().equals(type)) {
            SemanticElement jpdlElement = this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.genericElement");
            child.initialize(jpdlElement);
            SemanticElement parent = this.getSemanticElement();
            if (parent instanceof GenericElement) {
                GenericElement genericElement = (GenericElement)this.getSemanticElement();
                genericElement.addGenericElement((GenericElement)jpdlElement);
            }
        }
    }

    protected void doModelRemove(XmlAdapter child) {
    }

    public String getElementType() {
        return "genericElement";
    }
}

