/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.util.Strings;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.valueeditors.EntryValueEditor;
import org.apache.directory.studio.valueeditors.HexValueEditor;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.InPlaceTextValueEditor;
import org.apache.directory.studio.valueeditors.Messages;
import org.apache.directory.studio.valueeditors.MultivaluedValueEditor;
import org.apache.directory.studio.valueeditors.RenameValueEditor;
import org.apache.directory.studio.valueeditors.TextValueEditor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ValueEditorManager {
    private static final String ATTRIBUTE_TYPE = "attributeType";
    private static final String ATTRIBUTE = "attribute";
    private static final String SYNTAX_OID = "syntaxOID";
    private static final String SYNTAX = "syntax";
    private static final String ICON = "icon";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String EXTENSION_POINT = BrowserCommonConstants.EXTENSION_POINT_VALUE_EDITORS;
    private Composite parent;
    private IValueEditor userSelectedValueEditor;
    private MultivaluedValueEditor multiValuedValueEditor;
    private EntryValueEditor entryValueEditor;
    private RenameValueEditor renameValueEditor;
    private IValueEditor defaultStringSingleLineValueEditor;
    private IValueEditor defaultStringMultiLineValueEditor;
    private IValueEditor defaultBinaryValueEditor;
    private Map<String, IValueEditor> class2ValueEditors;

    public ValueEditorManager(Composite parent, boolean useEntryValueEditor, boolean useRenameValueEditor) {
        this.parent = parent;
        this.userSelectedValueEditor = null;
        this.class2ValueEditors = new HashMap<String, IValueEditor>();
        Collection<IValueEditor> valueEditors = this.createValueEditors(parent);
        for (IValueEditor valueEditor : valueEditors) {
            this.class2ValueEditors.put(valueEditor.getClass().getName(), valueEditor);
        }
        this.multiValuedValueEditor = new MultivaluedValueEditor(this.parent, this);
        this.multiValuedValueEditor.setValueEditorName(Messages.getString("ValueEditorManager.MulitivaluedEditor"));
        this.multiValuedValueEditor.setValueEditorImageDescriptor(BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/multivaluededitor.gif"));
        if (useEntryValueEditor) {
            this.entryValueEditor = new EntryValueEditor(this.parent, this);
            this.entryValueEditor.setValueEditorName(Messages.getString("ValueEditorManager.EntryEditor"));
            this.entryValueEditor.setValueEditorImageDescriptor(BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/entry_editor.gif"));
        }
        if (useRenameValueEditor) {
            this.renameValueEditor = new RenameValueEditor(this.parent, this);
            this.renameValueEditor.setValueEditorName(Messages.getString("ValueEditorManager.RenameEditor"));
            this.renameValueEditor.setValueEditorImageDescriptor(BrowserCommonActivator.getDefault().getImageDescriptor("resources/icons/rename.gif"));
        }
        this.defaultStringSingleLineValueEditor = this.class2ValueEditors.get(InPlaceTextValueEditor.class.getName());
        this.defaultStringMultiLineValueEditor = this.class2ValueEditors.get(TextValueEditor.class.getName());
        this.defaultBinaryValueEditor = this.class2ValueEditors.get(HexValueEditor.class.getName());
    }

    public void dispose() {
        if (this.parent != null) {
            this.userSelectedValueEditor = null;
            this.multiValuedValueEditor.dispose();
            if (this.entryValueEditor != null) {
                this.entryValueEditor.dispose();
            }
            if (this.renameValueEditor != null) {
                this.renameValueEditor.dispose();
            }
            this.defaultStringSingleLineValueEditor.dispose();
            this.defaultStringMultiLineValueEditor.dispose();
            this.defaultBinaryValueEditor.dispose();
            for (IValueEditor ve : this.class2ValueEditors.values()) {
                ve.dispose();
            }
            this.parent = null;
        }
    }

    public void setUserSelectedValueEditor(IValueEditor userSelectedValueEditor) {
        this.userSelectedValueEditor = userSelectedValueEditor;
    }

    public IValueEditor getUserSelectedValueEditor() {
        return this.userSelectedValueEditor;
    }

    public IValueEditor getCurrentValueEditor(Schema schema, String attributeType) {
        if (this.userSelectedValueEditor != null) {
            return this.userSelectedValueEditor;
        }
        AttributeType atd = schema.getAttributeTypeDescription(attributeType);
        Map<String, String> attributeValueEditorMap = BrowserCommonActivator.getDefault().getValueEditorsPreferences().getAttributeValueEditorMap();
        if (atd.getOid() != null && attributeValueEditorMap.containsKey(Strings.toLowerCase((String)atd.getOid()))) {
            return this.class2ValueEditors.get(attributeValueEditorMap.get(Strings.toLowerCase((String)atd.getOid())));
        }
        List names = atd.getNames();
        for (String name : names) {
            if (!attributeValueEditorMap.containsKey(Strings.toLowerCase((String)name))) continue;
            return this.class2ValueEditors.get(attributeValueEditorMap.get(Strings.toLowerCase((String)name)));
        }
        String syntaxNumericOid = SchemaUtils.getSyntaxNumericOidTransitive((AttributeType)atd, (Schema)schema);
        Map<String, String> syntaxValueEditorMap = BrowserCommonActivator.getDefault().getValueEditorsPreferences().getSyntaxValueEditorMap();
        if (syntaxNumericOid != null && syntaxValueEditorMap.containsKey(Strings.toLowerCase((String)syntaxNumericOid))) {
            return this.class2ValueEditors.get(syntaxValueEditorMap.get(Strings.toLowerCase((String)syntaxNumericOid)));
        }
        LdapSyntax lsd = schema.getLdapSyntaxDescription(syntaxNumericOid);
        if (SchemaUtils.isBinary((LdapSyntax)lsd)) {
            return this.defaultBinaryValueEditor;
        }
        return this.defaultStringSingleLineValueEditor;
    }

    public IValueEditor getCurrentValueEditor(IEntry entry, String attributeType) {
        return this.getCurrentValueEditor(entry.getBrowserConnection().getSchema(), attributeType);
    }

    public IValueEditor getCurrentValueEditor(IValue value) {
        IValueEditor ve = this.getCurrentValueEditor(value.getAttribute().getEntry(), value.getAttribute().getDescription());
        if (this.userSelectedValueEditor == null && value.getAttribute().isObjectClassAttribute() && this.entryValueEditor != null) {
            return this.entryValueEditor;
        }
        if (this.userSelectedValueEditor == null && value.isRdnPart() && this.renameValueEditor != null) {
            return this.renameValueEditor;
        }
        if (ve == this.defaultStringSingleLineValueEditor) {
            ve = value.getStringValue().indexOf(10) == -1 && value.getStringValue().indexOf(13) == -1 ? this.defaultStringSingleLineValueEditor : this.defaultStringMultiLineValueEditor;
        }
        return ve;
    }

    public IValueEditor getCurrentValueEditor(AttributeHierarchy attributeHierarchy) {
        if (attributeHierarchy == null) {
            return null;
        }
        if (this.userSelectedValueEditor == null && attributeHierarchy.getAttribute().isObjectClassAttribute() && this.entryValueEditor != null) {
            return this.entryValueEditor;
        }
        if (this.userSelectedValueEditor == this.entryValueEditor && this.entryValueEditor != null) {
            return this.entryValueEditor;
        }
        if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 0) {
            return this.getCurrentValueEditor(attributeHierarchy.getAttribute().getEntry(), attributeHierarchy.getAttribute().getDescription());
        }
        if (attributeHierarchy.size() == 1 && attributeHierarchy.getAttribute().getValueSize() == 1 && attributeHierarchy.getAttributeDescription().equalsIgnoreCase(attributeHierarchy.getAttribute().getValues()[0].getAttribute().getDescription())) {
            if (this.userSelectedValueEditor == null && attributeHierarchy.getAttribute().getValues()[0].isRdnPart()) {
                if (this.renameValueEditor != null) {
                    return this.renameValueEditor;
                }
                return this.multiValuedValueEditor;
            }
            return this.getCurrentValueEditor(attributeHierarchy.getAttribute().getValues()[0]);
        }
        return this.multiValuedValueEditor;
    }

    public IValueEditor[] getAlternativeValueEditors(IEntry entry, String attributeName) {
        Schema schema = entry.getBrowserConnection().getSchema();
        return this.getAlternativeValueEditors(schema, attributeName);
    }

    public IValueEditor[] getAlternativeValueEditors(Schema schema, String attributeName) {
        ArrayList<IValueEditor> alternativeList = new ArrayList<IValueEditor>();
        AttributeType atd = schema.getAttributeTypeDescription(attributeName);
        if (SchemaUtils.isBinary((AttributeType)atd, (Schema)schema)) {
            alternativeList.add(this.defaultBinaryValueEditor);
            alternativeList.add(this.defaultStringSingleLineValueEditor);
            alternativeList.add(this.defaultStringMultiLineValueEditor);
        } else if (SchemaUtils.isString((AttributeType)atd, (Schema)schema)) {
            alternativeList.add(this.defaultStringSingleLineValueEditor);
            alternativeList.add(this.defaultStringMultiLineValueEditor);
            alternativeList.add(this.defaultBinaryValueEditor);
        }
        alternativeList.add(this.multiValuedValueEditor);
        alternativeList.remove(this.getCurrentValueEditor(schema, attributeName));
        return alternativeList.toArray(new IValueEditor[alternativeList.size()]);
    }

    public IValueEditor[] getAlternativeValueEditors(IValue value) {
        ArrayList<IValueEditor> alternativeList = new ArrayList<IValueEditor>();
        if (value.isBinary()) {
            alternativeList.add(this.defaultBinaryValueEditor);
            alternativeList.add(this.defaultStringSingleLineValueEditor);
            alternativeList.add(this.defaultStringMultiLineValueEditor);
        } else if (value.isString()) {
            alternativeList.add(this.defaultStringSingleLineValueEditor);
            alternativeList.add(this.defaultStringMultiLineValueEditor);
            alternativeList.add(this.defaultBinaryValueEditor);
        }
        alternativeList.add(this.multiValuedValueEditor);
        alternativeList.remove(this.getCurrentValueEditor(value));
        return alternativeList.toArray(new IValueEditor[alternativeList.size()]);
    }

    public IValueEditor[] getAlternativeValueEditors(AttributeHierarchy ah) {
        if (ah == null) {
            return new IValueEditor[0];
        }
        if (this.multiValuedValueEditor != null) {
            for (IAttribute attribute : ah) {
                IValue[] iValueArray = attribute.getValues();
                int n = iValueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IValue value = iValueArray[n2];
                    if (value.isRdnPart()) {
                        return new IValueEditor[]{this.multiValuedValueEditor};
                    }
                    ++n2;
                }
            }
        }
        for (IAttribute attribute : ah) {
            if (!attribute.isObjectClassAttribute()) continue;
            return new IValueEditor[0];
        }
        if (ah.size() == 1 && ah.getAttribute().getValueSize() == 0) {
            return this.getAlternativeValueEditors(ah.getAttribute().getEntry(), ah.getAttribute().getDescription());
        }
        if (ah.size() == 1 && ah.getAttribute().getValueSize() == 1 && ah.getAttributeDescription().equalsIgnoreCase(ah.getAttribute().getValues()[0].getAttribute().getDescription())) {
            return this.getAlternativeValueEditors(ah.getAttribute().getValues()[0]);
        }
        return new IValueEditor[0];
    }

    public IValueEditor[] getAllValueEditors() {
        LinkedHashSet<IValueEditor> list = new LinkedHashSet<IValueEditor>();
        list.add(this.defaultStringSingleLineValueEditor);
        list.add(this.defaultStringMultiLineValueEditor);
        list.add(this.defaultBinaryValueEditor);
        list.addAll(this.class2ValueEditors.values());
        list.add(this.multiValuedValueEditor);
        if (this.entryValueEditor != null) {
            list.add(this.entryValueEditor);
        }
        if (this.renameValueEditor != null) {
            list.add(this.renameValueEditor);
        }
        return list.toArray(new IValueEditor[list.size()]);
    }

    public IValueEditor getDefaultBinaryValueEditor() {
        return this.defaultBinaryValueEditor;
    }

    public IValueEditor getDefaultStringValueEditor() {
        return this.defaultStringMultiLineValueEditor;
    }

    public MultivaluedValueEditor getMultiValuedValueEditor() {
        return this.multiValuedValueEditor;
    }

    public EntryValueEditor getEntryValueEditor() {
        return this.entryValueEditor;
    }

    public RenameValueEditor getRenameValueEditor() {
        return this.renameValueEditor;
    }

    private Collection<IValueEditor> createValueEditors(Composite parent) {
        ArrayList<IValueEditor> valueEditors = new ArrayList<IValueEditor>();
        Collection<ValueEditorExtension> valueEditorExtensions = ValueEditorManager.getValueEditorExtensions();
        for (ValueEditorExtension vee : valueEditorExtensions) {
            try {
                IValueEditor valueEditor = (IValueEditor)vee.member.createExecutableExtension(CLASS);
                valueEditor.create(parent);
                valueEditor.setValueEditorName(vee.name);
                valueEditor.setValueEditorImageDescriptor(vee.icon);
                valueEditors.add(valueEditor);
            }
            catch (Exception e) {
                BrowserCommonActivator.getDefault().getLog().log((IStatus)new Status(4, BrowserCommonConstants.PLUGIN_ID, 1, String.valueOf(Messages.getString("ValueEditorManager.UnableToCreateValueEditor")) + vee.className, (Throwable)e));
            }
        }
        return valueEditors;
    }

    public static Collection<ValueEditorExtension> getValueEditorExtensions() {
        ArrayList<ValueEditorExtension> valueEditorExtensions = new ArrayList<ValueEditorExtension>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            ValueEditorExtension proxy = new ValueEditorExtension();
            valueEditorExtensions.add(proxy);
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            String extendingPluginId = extension.getNamespaceIdentifier();
            proxy.member = member;
            proxy.name = member.getAttribute(NAME);
            String iconPath = member.getAttribute(ICON);
            proxy.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)extendingPluginId, (String)iconPath);
            if (proxy.icon == null) {
                proxy.icon = ImageDescriptor.getMissingImageDescriptor();
            }
            proxy.className = member.getAttribute(CLASS);
            IConfigurationElement[] children = member.getChildren();
            int c = 0;
            while (c < children.length) {
                IConfigurationElement element = children[c];
                String type = element.getName();
                if (SYNTAX.equals(type)) {
                    String syntaxOID = element.getAttribute(SYNTAX_OID);
                    proxy.syntaxOids.add(syntaxOID);
                } else if (ATTRIBUTE.equals(type)) {
                    String attributeType = element.getAttribute(ATTRIBUTE_TYPE);
                    proxy.attributeTypes.add(attributeType);
                }
                ++c;
            }
            ++m;
        }
        return valueEditorExtensions;
    }

    public static class ValueEditorExtension {
        public String name = null;
        public ImageDescriptor icon = null;
        public String className = null;
        public Collection<String> syntaxOids = new ArrayList<String>(3);
        public Collection<String> attributeTypes = new ArrayList<String>(3);
        private IConfigurationElement member = null;
    }
}

