/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.ldapbrowser.common.actions.PasteAction;
import org.apache.directory.studio.ldapbrowser.common.dnd.ValuesTransfer;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.eclipse.swt.dnd.Transfer;

public class EntryEditorPasteAction
extends PasteAction {
    @Override
    public String getText() {
        IValue[] values = this.getValuesToPaste();
        if (values != null) {
            return values.length > 1 ? Messages.getString("EntryEditorPasteAction.PasteValues") : Messages.getString("EntryEditorPasteAction.PasteValue");
        }
        return Messages.getString("EntryEditorPasteAction.Paste");
    }

    @Override
    public boolean isEnabled() {
        return this.getValuesToPaste() != null;
    }

    @Override
    public void run() {
        IValue[] values = this.getValuesToPaste();
        if (values != null) {
            IEntry entry = null;
            if (this.getInput() instanceof IEntry) {
                entry = (IEntry)this.getInput();
            } else if (this.getInput() instanceof AttributeHierarchy) {
                entry = ((AttributeHierarchy)this.getInput()).getEntry();
            }
            if (entry != null) {
                new CompoundModification().createValues(entry, values);
            }
        }
    }

    private IValue[] getValuesToPaste() {
        Object content;
        if ((this.getInput() instanceof IEntry || this.getInput() instanceof AttributeHierarchy) && (content = this.getFromClipboard((Transfer)ValuesTransfer.getInstance())) != null && content instanceof IValue[]) {
            IValue[] values = (IValue[])content;
            return values;
        }
        return null;
    }
}

