/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.factory;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import org.teiid.designer.mapping.factory.ChoiceFactoryManager;
import org.teiid.designer.mapping.factory.IChoiceFactory;
import org.teiid.designer.mapping.factory.IMappableTree;

public class DefaultMappableTree
implements IMappableTree {
    private EObject treeRoot;
    private AdapterFactoryItemDelegator emfContentProvider;

    public DefaultMappableTree(EObject treeRoot) {
        this.treeRoot = treeRoot;
    }

    public AdapterFactoryItemDelegator getModelContentProvider() {
        if (this.emfContentProvider == null) {
            AdapterFactory factory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
            this.emfContentProvider = new AdapterFactoryItemDelegator(factory);
        }
        return this.emfContentProvider;
    }

    @Override
    public EObject getTreeRoot() {
        return this.treeRoot;
    }

    @Override
    public EObject getParent(EObject node) {
        Object parent = this.getModelContentProvider().getParent((Object)node);
        if (parent instanceof EObject) {
            return (EObject)parent;
        }
        return null;
    }

    @Override
    public Collection getChildren(EObject node) {
        return this.getModelContentProvider().getChildren((Object)node);
    }

    @Override
    public boolean isAncestorOf(EObject ancestor, EObject descendent) {
        EObject parent = this.getParent(descendent);
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = this.getParent(parent);
        }
        return false;
    }

    @Override
    public boolean isParentOf(EObject parent, EObject child) {
        return this.getParent(child).equals(parent);
    }

    @Override
    public List getExternalRoots(boolean recurseFragments) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isExternal(EObject node) {
        return false;
    }

    @Override
    public EObject getDatatype(EObject node) {
        EObject result = null;
        SqlAspect aspect = AspectManager.getSqlAspect((EObject)node);
        if (aspect instanceof SqlColumnAspect) {
            result = ((SqlColumnAspect)aspect).getDatatype(node);
        } else if (aspect instanceof SqlProcedureParameterAspect) {
            result = ((SqlProcedureParameterAspect)aspect).getDatatype(node);
        }
        return result;
    }

    @Override
    public boolean isChoiceNode(EObject node) {
        IChoiceFactory factory = ChoiceFactoryManager.getChoiceFactory(node);
        return factory != null && factory.supports(node);
    }

    @Override
    public boolean isSiblingOf(EObject instance, EObject possibleSibling, boolean higherOrderOnly) {
        boolean result = false;
        result = instance.eContainer().equals(possibleSibling.eContainer());
        if (result && higherOrderOnly) {
            EList siblingList = instance.eContainer().eContents();
            int a = siblingList.indexOf(instance);
            int b = siblingList.indexOf(possibleSibling);
            result = b < a;
        }
        return result;
    }

    @Override
    public boolean areEquivalent(EObject objA, EObject objB) {
        return false;
    }

    @Override
    public String getUniqueName(EObject node) {
        ModelEditor editor = ModelerCore.getModelEditor();
        String name = editor.getName(node);
        return String.valueOf(name) + '_' + editor.getName(node.eContainer());
    }
}

