/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.sdt.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.types.EnterpriseDatatypeInfo;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.sdt.ModelerSdtPlugin;
import org.teiid.designer.sdt.types.AbstractDatatypeManager;
import org.teiid.designer.sdt.types.BuiltInTypesManager;

public class WorkspaceDatatypeManager
extends AbstractDatatypeManager {
    private BuiltInTypesManager builtInTypesMgr;

    @Override
    protected void doInitialize() throws ModelerCoreException {
        this.init();
    }

    private void init() throws ModelerCoreException {
        this.builtInTypesMgr = new BuiltInTypesManager();
        this.builtInTypesMgr.initialize(this.getContainer());
    }

    public DatatypeManager getBuiltInTypeManager() {
        return this.builtInTypesMgr;
    }

    public EObject getBuiltInDatatype(String name) {
        return this.builtInTypesMgr.getBuiltInDatatype(name);
    }

    public EObject[] getBuiltInPrimitiveTypes() {
        return this.builtInTypesMgr.getBuiltInPrimitiveTypes();
    }

    public EObject getBuiltInPrimitiveType(EObject type) {
        return this.builtInTypesMgr.getBuiltInPrimitiveType(type);
    }

    public boolean isBinary(EObject type) {
        return this.builtInTypesMgr.isBinary(type);
    }

    public boolean isCharacter(EObject type) {
        return this.builtInTypesMgr.isCharacter(type);
    }

    public boolean isNumeric(EObject type) {
        return this.builtInTypesMgr.isNumeric(type);
    }

    public boolean isBounded(EObject type) {
        return this.builtInTypesMgr.isBounded(type);
    }

    public boolean isEnumeration(EObject type) {
        return this.builtInTypesMgr.isEnumeration(type);
    }

    public ObjectID getUuid(EObject type) {
        Object uuid;
        if (this.isBuiltInDatatype(type)) {
            return this.builtInTypesMgr.getUuid(type);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null && (uuid = aspect.getObjectID(type)) instanceof ObjectID) {
            return (ObjectID)uuid;
        }
        return null;
    }

    public String getUuidString(EObject type) {
        if (this.isBuiltInDatatype(type)) {
            return this.builtInTypesMgr.getUuidString(type);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.getUuidString(type);
        }
        return null;
    }

    public String getRuntimeTypeName(EObject type) {
        if (this.isBuiltInDatatype(type)) {
            return this.builtInTypesMgr.getRuntimeTypeName(type);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            EObject dtype = type;
            String result = aspect.getRuntimeTypeName(type);
            while (result == null || result.length() == 0) {
                EObject basetype = (EObject)aspect.getBasetype(dtype);
                if (basetype == dtype) break;
                if (aspect.isURType(basetype)) {
                    result = "string";
                    break;
                }
                if (aspect.isBuiltInDatatype(basetype)) {
                    result = aspect.getRuntimeTypeName(basetype);
                    break;
                }
                result = aspect.getRuntimeTypeName(basetype);
                dtype = basetype;
            }
            return result;
        }
        return null;
    }

    public Boolean getRuntimeTypeFixed(EObject type) {
        Boolean result = null;
        if (this.isBuiltInDatatype(type)) {
            result = this.builtInTypesMgr.getRuntimeTypeFixed(type);
        } else {
            SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
            if (aspect != null) {
                result = aspect.getRuntimeTypeFixed(type);
            }
        }
        return result;
    }

    public Map getEnterpriseExtensionsMap(EObject type) {
        if (this.isBuiltInDatatype(type)) {
            return this.builtInTypesMgr.getEnterpriseExtensionsMap(type);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.getEnterpriseExtensionsMap(type);
        }
        return Collections.EMPTY_MAP;
    }

    public String getName(EObject type) {
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.getName(type);
        }
        return null;
    }

    public boolean isSimpleDatatype(EObject type) {
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.isSimpleDatatype(type);
        }
        return false;
    }

    public EObject getAnySimpleType() {
        return this.builtInTypesMgr.getAnySimpleType();
    }

    public EObject getAnyType() {
        return this.builtInTypesMgr.getAnyType();
    }

    public EObject getDefaultDatatypeForRuntimeTypeName(String runtimeTypeName) {
        return this.builtInTypesMgr.getDefaultDatatypeForRuntimeTypeName(runtimeTypeName);
    }

    public boolean isBuiltInDatatype(EObject datatype) {
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(datatype);
        if (aspect != null) {
            return aspect.isBuiltInDatatype(datatype);
        }
        return false;
    }

    public EObject getBaseType(EObject datatype) {
        if (this.isBuiltInDatatype(datatype)) {
            return this.builtInTypesMgr.getBaseType(datatype);
        }
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(datatype);
        if (aspect != null) {
            return (EObject)aspect.getBasetype(datatype);
        }
        return null;
    }

    public EObject getDatatypeForXsdType(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        if (eObject instanceof XSDSimpleTypeDefinition) {
            return this.getDatatypeForXsdType((XSDSimpleTypeDefinition)eObject);
        }
        if (eObject instanceof XSDComplexTypeDefinition) {
            return this.getDatatypeForXsdType((XSDComplexTypeDefinition)eObject);
        }
        return null;
    }

    public EObject[] getAllDatatypes() {
        EObject[] result = this.getDatatypes();
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(result));
        tmp.addAll(Arrays.asList(this.builtInTypesMgr.getAllDatatypes()));
        WorkspaceDatatypeManager.removeDuplicates(tmp);
        WorkspaceDatatypeManager.sortByName(tmp);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableBaseTypeValues(EObject datatype) {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(this.getAllDatatypes()));
        tmp.remove(this.getAnySimpleType());
        tmp.remove(datatype);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableItemTypeValues(EObject datatype) {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(this.getAllDatatypes()));
        tmp.remove(datatype);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableMemberTypeValues(EObject datatype) {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(this.getAllDatatypes()));
        tmp.remove(datatype);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableTypeValues(EObject eObject, EStructuralFeature feature) {
        if (feature == null || eObject == null) {
            return this.getAllDatatypes();
        }
        if (eObject instanceof XSDSimpleTypeDefinition && feature.getFeatureID() == 28) {
            return this.getAllowableBaseTypeValues(eObject);
        }
        if (eObject instanceof XSDSimpleTypeDefinition && feature.getFeatureID() == 30) {
            return this.getAllowableItemTypeValues(eObject);
        }
        if (eObject instanceof XSDSimpleTypeDefinition && feature.getFeatureID() == 26) {
            return this.getAllowableMemberTypeValues(eObject);
        }
        return this.getAllDatatypes();
    }

    public EObject findDatatype(String id) {
        EObject result = this.builtInTypesMgr.findDatatype(id);
        if (result != null) {
            return result;
        }
        EObject rv = this.findEObject(id);
        if (rv instanceof XSDSimpleTypeDefinition) {
            return rv;
        }
        return null;
    }

    public String getRuntimeTypeJavaClassName(String id) {
        SqlDatatypeAspect aspect;
        String result = this.builtInTypesMgr.getRuntimeTypeJavaClassName(id);
        if (result != null) {
            return result;
        }
        EObject eObject = this.findDatatype(id);
        if (eObject != null && (aspect = WorkspaceDatatypeManager.getSqlAspect(eObject)) != null) {
            return aspect.getJavaClassName(eObject);
        }
        return null;
    }

    public String getRuntimeTypeName(String id) {
        SqlDatatypeAspect aspect;
        String result = this.builtInTypesMgr.getRuntimeTypeName(id);
        if (result != null) {
            return result;
        }
        EObject eObject = this.findDatatype(id);
        if (eObject != null && (aspect = WorkspaceDatatypeManager.getSqlAspect(eObject)) != null) {
            return aspect.getJavaClassName(eObject);
        }
        return null;
    }

    public EObject[] getSubtypes(EObject datatype) {
        EObject[] subtypes;
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)datatype);
        ArrayList<Object> tmp = new ArrayList<Object>();
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(datatype);
        if (aspect != null && aspect.isURType(datatype)) {
            subtypes = this.builtInTypesMgr.getBuiltInPrimitiveTypes();
            tmp.addAll(Arrays.asList(subtypes));
        } else if (aspect != null && aspect.isBuiltInDatatype(datatype)) {
            subtypes = this.builtInTypesMgr.getSubtypes(datatype);
            tmp.addAll(Arrays.asList(subtypes));
        }
        EObject[] datatypes = this.getDatatypes();
        int i = 0;
        while (i < datatypes.length) {
            XSDSimpleTypeDefinition sdt = (XSDSimpleTypeDefinition)datatypes[i];
            if (sdt != null) {
                XSDSimpleTypeDefinition basetype = sdt.getBaseTypeDefinition();
                aspect = WorkspaceDatatypeManager.getSqlAspect((EObject)basetype);
                if (aspect != null && aspect.isBuiltInDatatype((EObject)basetype)) {
                    basetype = this.builtInTypesMgr.getEmfType((EObject)basetype);
                }
                if (datatype.equals(basetype)) {
                    tmp.add(sdt);
                }
            }
            ++i;
        }
        WorkspaceDatatypeManager.removeDuplicates(tmp);
        WorkspaceDatatypeManager.sortByName(tmp);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public String getDescription(EObject type) {
        String description = null;
        SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(type);
        if (aspect != null) {
            description = aspect.getDescription(type);
        }
        return description == null ? "" : description;
    }

    protected EObject getDatatypeForXsdType(XSDSimpleTypeDefinition simpleType) {
        CoreArgCheck.isNotNull((Object)simpleType);
        XSDSimpleTypeDefinition builtInType = simpleType;
        while (!this.isBuiltInDatatype((EObject)builtInType)) {
            EObject baseType = this.getBaseType((EObject)builtInType);
            if (builtInType == baseType) {
                builtInType = null;
                break;
            }
            builtInType = baseType;
        }
        if (builtInType == null) {
            return this.getAnySimpleType();
        }
        return this.getBuiltInDatatype(builtInType.getName());
    }

    protected EObject getDatatypeForXsdType(XSDComplexTypeDefinition complexType) {
        CoreArgCheck.isNotNull((Object)complexType);
        return null;
    }

    protected EObject[] getDatatypes() {
        List resources = this.getDatatypeResources();
        return this.getDatatypes(resources);
    }

    protected EObject[] getDatatypes(List emfResources) {
        CoreArgCheck.isNotNull((Object)emfResources);
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        for (Resource resource : emfResources) {
            tmp.addAll(Arrays.asList(this.getDatatypes(resource)));
        }
        EObject[] result = new EObject[tmp.size()];
        tmp.toArray(result);
        return result;
    }

    protected EObject[] getDatatypes(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        ArrayList<XSDSimpleTypeDefinition> tmp = new ArrayList<XSDSimpleTypeDefinition>();
        for (EObject eObj : resource.getContents()) {
            if (eObj == null || !(eObj instanceof XSDSchema)) continue;
            XSDSchema schema = (XSDSchema)eObj;
            for (EObject eObj2 : schema.eContents()) {
                if (eObj2 == null || !(eObj2 instanceof XSDSimpleTypeDefinition)) continue;
                XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)eObj2;
                XsdUtil.checkForEnterpriseConversion((XSDSimpleTypeDefinition)simpleType);
                tmp.add(simpleType);
            }
        }
        EObject[] result = new EObject[tmp.size()];
        tmp.toArray(result);
        return result;
    }

    protected EObject findEObject(String id) {
        if (id == null) {
            return null;
        }
        EObject result = null;
        if (WorkspaceDatatypeManager.containsUuidPattern(id)) {
            String uuidString = WorkspaceDatatypeManager.extractUuidString(id);
            ResourceSet rsrcSet = this.getContainer();
            Container container = null;
            if (rsrcSet instanceof Container) {
                container = (Container)this.getContainer();
            }
            if (container != null) {
                try {
                    ObjectID uuid = IDGenerator.getInstance().stringToObject(uuidString);
                    result = (EObject)container.getEObjectFinder().find((Object)uuid);
                }
                catch (InvalidIDException e) {
                    ModelerSdtPlugin.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
            if (result != null) {
                return result instanceof XSDSimpleTypeDefinition ? result : null;
            }
            EObject[] allDatatypes = this.getAllDatatypes();
            int i = 0;
            while (i != allDatatypes.length) {
                EObject datatype = allDatatypes[i];
                SqlDatatypeAspect aspect = WorkspaceDatatypeManager.getSqlAspect(datatype);
                if (aspect != null && uuidString.equals(aspect.getUuidString(datatype))) {
                    return datatype;
                }
                ++i;
            }
        }
        List resources = this.getDatatypeResources();
        for (Resource emfResource : resources) {
            result = emfResource.getEObject(id);
            if (result == null) continue;
            return result instanceof XSDSimpleTypeDefinition ? result : null;
        }
        return result;
    }

    public EObject[] getBuiltInDatatypes() {
        return this.builtInTypesMgr.getBuiltInDatatypes();
    }

    public boolean isEnterpriseDatatype(EObject simpleType) {
        return this.builtInTypesMgr.isEnterpriseDatatype(this.resolveWhenProxy(simpleType));
    }

    public EnterpriseDatatypeInfo getEnterpriseDatatypeInfo(XSDSimpleTypeDefinition simpleType) {
        return this.builtInTypesMgr.getEnterpriseDatatypeInfo((XSDSimpleTypeDefinition)this.resolveWhenProxy((EObject)simpleType));
    }

    public void setBasetypeDefinition(XSDSimpleTypeDefinition simpleType, XSDSimpleTypeDefinition baseType) {
        WorkspaceDatatypeManager.getSqlAspect((EObject)simpleType).setBasetype((XSDSimpleTypeDefinition)this.resolveWhenProxy((EObject)simpleType), (XSDSimpleTypeDefinition)this.resolveWhenProxy((EObject)baseType));
    }

    private EObject resolveWhenProxy(EObject e) {
        EObject resolvedEObject = e;
        if (e.eIsProxy() && (resolvedEObject = EcoreUtil.resolve((EObject)e, (ResourceSet)this.getContainer())).eIsProxy()) {
            throw new TeiidDesignerRuntimeException(ModelerSdtPlugin.Util.getString("WorkspaceDatatypeManager.Error_EObject_can_not_be_a_proxy", (Object)resolvedEObject.toString()));
        }
        return resolvedEObject;
    }
}

