/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.cnd.CndImporter;
import org.jboss.tools.modeshape.jcr.cnd.CompactNodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.JcrUiConstants;
import org.jboss.tools.modeshape.jcr.ui.JcrUiUtils;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;

public final class CndPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static CompactNodeTypeDefinition _previewCnd;
    private Combo cbxNotationType;
    private String notationType;
    private Text txtPreview;

    public CndPreferencePage() {
        if (_previewCnd == null) {
            _previewCnd = new CompactNodeTypeDefinition();
            CndImporter importer = new CndImporter();
            ArrayList problems = new ArrayList();
            _previewCnd = importer.importFrom("<abc = 'http://namespace.com/abc/1.0'>\n<xyz = 'http://namespace.com/xyz/1.0'>\n/* This is a comment for node type definition abc:NodeType. */\n[abc:NodeType] > abc:ParentType1, abc:ParentType2 abstract orderable mixin noquery primaryitem abc:propertyABC\n- abc:propertyABC (STRING) = 'default1', 'default2' mandatory autocreated protected multiple VERSION\n queryops '=, <>, <, <=, >, >=, LIKE' nofulltext noqueryorder < 'constraint1', 'constraint2'+ abc:node (abc:reqType1, abc:reqType2) = abc:defaultType mandatory autocreated protected sns version\n[xyz:NodeTypeX]\n/* This is a comment for property definition xyz:propertyX. */\n- xyz:propertyX\n[xyz:NodeTypeY]\n- xyz:propertyY (LONG)\n/* This is a comment for child node definition xyz:childNodeX. */\n+ xyz:childNodeY\n", problems, "string");
            if (_previewCnd == null) {
                for (Throwable e : problems) {
                    Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, null, e));
                }
            }
        }
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(2, false));
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lbl = new Label(panel, 0);
        lbl.setText(CndMessages.notationTypeLabel);
        this.cbxNotationType = new Combo(panel, 0);
        this.cbxNotationType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cbxNotationType.setItems(new String[]{CndElement.NotationType.LONG.toString(), CndElement.NotationType.COMPRESSED.toString(), CndElement.NotationType.COMPACT.toString()});
        this.cbxNotationType.setToolTipText(CndMessages.notationTypeToolTip);
        this.notationType = JcrPreferenceStore.get().get((JcrPreferenceConstants.Preference)JcrPreferenceConstants.CndPreference.NOTATION_TYPE);
        if (this.notationType == null) {
            this.notationType = CndElement.NotationType.LONG.toString();
        }
        this.cbxNotationType.setText(this.notationType);
        this.cbxNotationType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CndPreferencePage.this.handleNotationTypeChanged();
            }
        });
        Composite previewPanel = new Composite(parent, 0);
        previewPanel.setLayout((Layout)new GridLayout());
        previewPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblPreview = new Label(previewPanel, 0);
        lblPreview.setText(CndMessages.previewLabel);
        this.txtPreview = new Text(previewPanel, 2826);
        this.txtPreview.setLayoutData((Object)new GridData(4, 4, true, true));
        this.txtPreview.setBackground(this.getShell().getDisplay().getSystemColor(34));
        ((GridData)this.txtPreview.getLayoutData()).widthHint = this.convertWidthInCharsToPixels(100);
        ((GridData)this.txtPreview.getLayoutData()).heightHint = this.convertHeightInCharsToPixels(20);
        this.refreshPreview();
        IWorkbenchHelpSystem helpSystem = Activator.getSharedInstance().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)panel, JcrUiConstants.HelpContexts.CND_PREFERENCE_PAGE_HELP_CONTEXT);
        return panel;
    }

    public String getDescription() {
        return CndMessages.cndPrefPageDescription;
    }

    public Image getImage() {
        return JcrUiUtils.getCndEditorImage();
    }

    public String getMessage() {
        return CndMessages.cndPrefPageMessage;
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public String getTitle() {
        return CndMessages.cndPrefPageTitle;
    }

    void handleNotationTypeChanged() {
        this.notationType = this.cbxNotationType.getText();
        this.refreshPreview();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        JcrPreferenceStore prefStore = JcrPreferenceStore.get();
        String defaultNotationType = prefStore.getDefault((JcrPreferenceConstants.Preference)JcrPreferenceConstants.CndPreference.NOTATION_TYPE);
        if (defaultNotationType == null) {
            defaultNotationType = CndElement.NotationType.LONG.toString();
        }
        this.notationType = defaultNotationType;
        this.cbxNotationType.setText(defaultNotationType);
        super.performDefaults();
    }

    public boolean performOk() {
        JcrPreferenceStore.get().set((JcrPreferenceConstants.Preference)JcrPreferenceConstants.CndPreference.NOTATION_TYPE, this.notationType);
        return super.performOk();
    }

    private void refreshPreview() {
        if (_previewCnd == null) {
            this.txtPreview.setText(CndMessages.previewNotAvailableMessage);
        } else {
            this.txtPreview.setText(_previewCnd.toCndNotation(CndElement.NotationType.valueOf((String)this.notationType)));
        }
    }
}

