/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.dnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.jboss.tools.modeshape.jcr.ItemOwnerProvider;
import org.jboss.tools.modeshape.jcr.JcrModelObject;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.JcrUiConstants;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;
import org.jboss.tools.modeshape.ui.UiUtils;

abstract class JcrTransfer
extends ByteArrayTransfer {
    private final String name;
    private final int id;
    private final int[] ids;
    private final String[] names;

    protected JcrTransfer(Class<? extends JcrTransfer> transferClass) {
        UiUtils.verifyIsNotNull(transferClass, (String)"transferClass");
        this.name = transferClass.getName();
        this.names = new String[]{this.name};
        this.id = JcrTransfer.registerType((String)this.name);
        this.ids = new int[]{this.id};
    }

    protected abstract Class<? extends JcrModelObject> getJcrModelObjectClass();

    protected final int[] getTypeIds() {
        return this.ids;
    }

    protected final String[] getTypeNames() {
        return this.names;
    }

    protected final void javaToNative(Object object, TransferData transferData) {
        block9: {
            if (!this.validate(object)) {
                DND.error((int)2003);
            }
            assert (object instanceof JcrModelObject);
            ByteArrayOutputStream out = null;
            DataOutputStream dataOut = null;
            try {
                out = new ByteArrayOutputStream();
                dataOut = new DataOutputStream(out);
                this.writeToStream((JcrModelObject)object, dataOut);
                byte[] bytes = out.toByteArray();
                super.javaToNative((Object)bytes, transferData);
            }
            catch (Exception e) {
                Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, CndMessages.errorCopyingOrReadingJcrModelObjectToFromClipboard, (Throwable)e));
                if (dataOut != null) {
                    try {
                        dataOut.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out == null) break block9;
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected final Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            return this.readFromStream(in);
        }
        catch (Exception e) {
            Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, CndMessages.errorCopyingOrReadingJcrModelObjectToFromClipboard, (Throwable)e));
            return null;
        }
    }

    protected abstract JcrModelObject readFromStream(DataInputStream var1) throws Exception;

    protected final boolean validate(Object object) {
        Class<? extends JcrModelObject> jcrModelObjectClass = this.getJcrModelObjectClass();
        return jcrModelObjectClass.isInstance(object);
    }

    protected abstract void writeToStream(JcrModelObject var1, DataOutputStream var2) throws Exception;

    protected class OwnerProvider
    implements ItemOwnerProvider {
        private final QualifiedName qName;

        protected OwnerProvider(String qualifiedName) {
            this.qName = QualifiedName.parse((String)qualifiedName);
        }

        public QualifiedName getOwnerQualifiedName() {
            return this.qName;
        }
    }
}

