/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.dnd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.ItemOwnerProvider;
import org.jboss.tools.modeshape.jcr.JcrModelObject;
import org.jboss.tools.modeshape.jcr.ui.dnd.JcrTransfer;
import org.jboss.tools.modeshape.ui.UiUtils;

public final class ChildNodeDefinitionTransfer
extends JcrTransfer {
    private static ChildNodeDefinitionTransfer _instance;

    public static ChildNodeDefinitionTransfer get() {
        if (_instance == null) {
            _instance = new ChildNodeDefinitionTransfer();
        }
        return _instance;
    }

    private ChildNodeDefinitionTransfer() {
        super(ChildNodeDefinitionTransfer.class);
    }

    @Override
    protected Class<? extends JcrModelObject> getJcrModelObjectClass() {
        return ChildNodeDefinition.class;
    }

    @Override
    protected JcrModelObject readFromStream(DataInputStream inStream) throws Exception {
        String ownerQualifiedName = inStream.readUTF();
        ChildNodeDefinition childNodeDefn = new ChildNodeDefinition((ItemOwnerProvider)new JcrTransfer.OwnerProvider(ownerQualifiedName));
        childNodeDefn.setName(inStream.readUTF());
        childNodeDefn.setComment(inStream.readUTF());
        childNodeDefn.setAutoCreated(inStream.readBoolean());
        childNodeDefn.setMandatory(inStream.readBoolean());
        childNodeDefn.setProtected(inStream.readBoolean());
        childNodeDefn.setOnParentVersion(inStream.readInt());
        childNodeDefn.setSameNameSiblings(inStream.readBoolean());
        childNodeDefn.setDefaultPrimaryTypeName(inStream.readUTF());
        int requiredTypesCount = inStream.readInt();
        if (requiredTypesCount != 0) {
            String[] requiredTypes = new String[requiredTypesCount];
            int requiredTypeIndex = 0;
            while (requiredTypeIndex < requiredTypesCount) {
                requiredTypes[requiredTypeIndex] = inStream.readUTF();
                ++requiredTypeIndex;
            }
            childNodeDefn.setRequiredPrimaryTypeNames(requiredTypes);
        }
        return childNodeDefn;
    }

    @Override
    protected void writeToStream(JcrModelObject jcrModelObject, DataOutputStream outStream) throws Exception {
        assert (jcrModelObject instanceof ChildNodeDefinition);
        ChildNodeDefinition childNodeDefn = (ChildNodeDefinition)jcrModelObject;
        outStream.writeUTF(childNodeDefn.getQualifiedName().get());
        outStream.writeUTF(UiUtils.ensureNotNull((String)childNodeDefn.getName()));
        outStream.writeUTF(UiUtils.ensureNotNull((String)childNodeDefn.getComment()));
        outStream.writeBoolean(childNodeDefn.isAutoCreated());
        outStream.writeBoolean(childNodeDefn.isMandatory());
        outStream.writeBoolean(childNodeDefn.isProtected());
        outStream.writeInt(childNodeDefn.getOnParentVersion());
        outStream.writeBoolean(childNodeDefn.allowsSameNameSiblings());
        outStream.writeUTF(UiUtils.ensureNotNull((String)childNodeDefn.getDefaultPrimaryTypeName()));
        String[] requiredTypes = childNodeDefn.getRequiredPrimaryTypeNames();
        if (requiredTypes == null || requiredTypes.length == 0) {
            outStream.writeInt(0);
        } else {
            outStream.writeInt(requiredTypes.length);
            String[] stringArray = requiredTypes;
            int n = requiredTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredType = stringArray[n2];
                outStream.writeUTF(requiredType);
                ++n2;
            }
        }
    }
}

