/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.ValidationStatus;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.ui.forms.ErrorMessage;

public class JcrUiUtils {
    public static Image getCndEditorImage() {
        return Activator.getSharedInstance().getImage("icons/cnd-editor-16x.png");
    }

    public static ImageDescriptor getDeleteImageDescriptor() {
        return org.jboss.tools.modeshape.ui.Activator.getSharedInstance().getImageDescriptor("icons/delete-16x.gif");
    }

    public static ImageDescriptor getEditImageDescriptor() {
        return org.jboss.tools.modeshape.ui.Activator.getSharedInstance().getImageDescriptor("icons/edit-16x.png");
    }

    public static int getMarkerSeverity(ValidationStatus status) {
        Utils.verifyIsNotNull((Object)status, (String)"status");
        if (status.isOk()) {
            return -1;
        }
        if (status.isError()) {
            return 2;
        }
        if (status.isWarning()) {
            return 1;
        }
        if (status.isInfo()) {
            return 0;
        }
        assert (false) : "Unexpected severity type";
        return 2;
    }

    public static int getMessageType(ValidationStatus status) {
        Utils.verifyIsNotNull((Object)status, (String)"status");
        if (status.isOk()) {
            return 0;
        }
        if (status.isError()) {
            return 3;
        }
        if (status.isWarning()) {
            return 2;
        }
        if (status.isInfo()) {
            return 1;
        }
        assert (false) : "Unexpected severity type";
        return 3;
    }

    public static ImageDescriptor getNewImageDescriptor() {
        return org.jboss.tools.modeshape.ui.Activator.getSharedInstance().getImageDescriptor("icons/new-16x.png");
    }

    public static boolean isCndFile(IResource resource) {
        return resource != null && resource.getType() == 1 && "cnd".equals(resource.getFileExtension()) && resource.exists();
    }

    public static void setMessage(ValidationStatus status, ErrorMessage message) {
        if (status.isError()) {
            message.setErrorMessage(status.getMessage());
        } else if (status.isWarning()) {
            message.setWarningMessage(status.getMessage());
        } else if (status.isInfo()) {
            message.setInformationMessage(status.getMessage());
        } else if (status.isOk()) {
            message.setOkMessage(status.getMessage());
        } else assert (false) : "Unexpected status type";
    }

    private JcrUiUtils() {
    }
}

