/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.tools.models.switchyard1_0.switchyard.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardPackage;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.switchyard.util.SwitchyardResourceImpl;
import org.switchyard.tools.models.switchyard1_0.transform.JAXBTransformType;
import org.switchyard.tools.models.switchyard1_0.transform.JavaTransformType1;
import org.switchyard.tools.models.switchyard1_0.transform.JsonTransformType;
import org.switchyard.tools.models.switchyard1_0.transform.SmooksTransformType;
import org.switchyard.tools.models.switchyard1_0.transform.SmooksTransformType1;
import org.switchyard.tools.models.switchyard1_0.transform.TransformFactory;
import org.switchyard.tools.models.switchyard1_0.transform.XsltTransformType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;
import org.switchyard.tools.ui.editor.model.merge.SwitchYardMergedModelAdapter;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;

public final class TransformTypesUtil {
    private Set<QName> _outputTypeQNames = null;
    private Set<QName> _inputTypeQNames = null;
    private List<TransformType> _targetTransforms = null;

    public TransformTypesUtil(SwitchYardType switchYard) {
        try {
            this._inputTypeQNames = this.getInputTypesForConfig();
            this._outputTypeQNames = this.getOutputTypesForConfig();
            this._targetTransforms = this.loadTransformsFromTarget(switchYard);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
    }

    private String[] getTypesAsStrings(Set<QName> typesList) throws Exception {
        String[] outList = new String[typesList.size()];
        int count = 0;
        for (QName qName : typesList) {
            outList[count] = qName.toString();
            ++count;
        }
        return outList;
    }

    public String[] getTypesAsStringsForConfig() throws Exception {
        return this.getTypesAsStrings(this.getTypesForConfig());
    }

    public String[] getInputTypesAsStringsForConfig() throws Exception {
        return this.getTypesAsStrings(this._inputTypeQNames);
    }

    public String[] getOutputTypesAsStringsForConfig() throws Exception {
        return this.getTypesAsStrings(this._outputTypeQNames);
    }

    public Set<QName> getTypesForConfig() throws Exception {
        HashSet<QName> typesList = new HashSet<QName>();
        if (this._inputTypeQNames != null) {
            typesList.addAll(this._inputTypeQNames);
        }
        if (this._outputTypeQNames != null) {
            typesList.addAll(this._outputTypeQNames);
        }
        return typesList;
    }

    private Set<QName> getInputTypesForConfig() throws Exception {
        HashSet<QName> typesList = new HashSet<QName>();
        ArrayList<ServiceInterface> services = this.getOperationsForConfig();
        for (ServiceInterface baseService : services) {
            Set ops = baseService.getOperations();
            for (ServiceOperation serviceOperation : ops) {
                if (serviceOperation.getInputType() == null) continue;
                typesList.add(serviceOperation.getInputType());
            }
        }
        return typesList;
    }

    private Set<QName> getOutputTypesForConfig() throws Exception {
        HashSet<QName> typesList = new HashSet<QName>();
        ArrayList<ServiceInterface> services = this.getOperationsForConfig();
        for (ServiceInterface baseService : services) {
            Set ops = baseService.getOperations();
            for (ServiceOperation serviceOperation : ops) {
                if (serviceOperation.getOutputType() != null) {
                    typesList.add(serviceOperation.getOutputType());
                }
                if (serviceOperation.getFaultType() == null) continue;
                typesList.add(serviceOperation.getFaultType());
            }
        }
        return typesList;
    }

    public boolean isQNameInput(String input) {
        try {
            QName toTest = QName.valueOf(input);
            Set<QName> inputQNames = this._inputTypeQNames;
            if (inputQNames.contains(toTest)) {
                return true;
            }
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        return false;
    }

    public boolean isQNameOutput(String input) {
        try {
            QName toTest = QName.valueOf(input);
            Set<QName> outputQNames = this._outputTypeQNames;
            if (outputQNames.contains(toTest)) {
                return true;
            }
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        return false;
    }

    private ArrayList<ServiceInterface> getOperationsForConfig() throws Exception {
        Composite composite = this.getCompositeFromTarget();
        ArrayList<ServiceInterface> runtimeServices = new ArrayList<ServiceInterface>();
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JavaUtil.getProjectClassLoader((IJavaProject)JavaCore.create((IProject)SwitchyardSCAEditor.getActiveEditor().getTargetModelFile().getProject()), null));
        try {
            for (Service service : composite.getService()) {
                if (service.getInterface() == null) continue;
                runtimeServices.add(SwitchYardModelUtils.getServiceInterface((Interface)service.getInterface()));
            }
            for (Reference reference : composite.getReference()) {
                if (reference.getInterface() == null) continue;
                runtimeServices.add(SwitchYardModelUtils.getServiceInterface((Interface)reference.getInterface()));
            }
            for (Component component : composite.getComponent()) {
                for (ComponentService service : component.getService()) {
                    if (service.getInterface() == null) continue;
                    runtimeServices.add(SwitchYardModelUtils.getServiceInterface((Interface)service.getInterface()));
                }
                for (ComponentReference reference : component.getReference()) {
                    if (reference.getInterface() == null) continue;
                    runtimeServices.add(SwitchYardModelUtils.getServiceInterface((Interface)reference.getInterface()));
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
        return runtimeServices;
    }

    private Composite getCompositeFromTarget() {
        IFile target = SwitchyardSCAEditor.getActiveEditor().getTargetModelFile();
        if (target != null) {
            try {
                SwitchYardType switchyard = this.loadModelFile(target);
                return switchyard.getComposite();
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        }
        return null;
    }

    private SwitchYardType loadModelFile(IFile file) throws IOException {
        DocumentRoot docroot;
        SwitchyardPackage.eINSTANCE.eClass();
        ResourceSet resourceSet = SwitchYardModelUtils.newResourceSet();
        URI modelUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        SwitchyardResourceImpl resource = null;
        try {
            resource = (SwitchyardResourceImpl)resourceSet.getResource(modelUri, true);
        }
        catch (WrappedException wrappedException) {
            resource = (SwitchyardResourceImpl)resourceSet.getResource(modelUri, true);
        }
        catch (Exception exception) {
            resource = (SwitchyardResourceImpl)resourceSet.getResource(modelUri, true);
        }
        if (resource != null && (docroot = (DocumentRoot)resource.getContents().get(0)) != null) {
            SwitchYardType switchyard = docroot.getSwitchyard();
            return switchyard;
        }
        return null;
    }

    public static List<TransformType> getSupportedTransformTypes() {
        ArrayList<TransformType> typeList = new ArrayList<TransformType>();
        JAXBTransformType jaxbType = TransformFactory.eINSTANCE.createJAXBTransformType();
        typeList.add((TransformType)jaxbType);
        XsltTransformType xsltType = TransformFactory.eINSTANCE.createXsltTransformType();
        typeList.add((TransformType)xsltType);
        SmooksTransformType1 smooksType = TransformFactory.eINSTANCE.createSmooksTransformType1();
        smooksType.setType(SmooksTransformType.SMOOKS);
        typeList.add((TransformType)smooksType);
        JsonTransformType jsonType = TransformFactory.eINSTANCE.createJsonTransformType();
        typeList.add((TransformType)jsonType);
        JavaTransformType1 javaType = TransformFactory.eINSTANCE.createJavaTransformType1();
        typeList.add((TransformType)javaType);
        return typeList;
    }

    public static String getLabelForType(String typeString) {
        if (typeString == null || typeString.length() == 0) {
            return "";
        }
        QName qname = QName.valueOf(typeString);
        if (NewTransformWizard.isJavaType(typeString)) {
            int lastDot = qname.getLocalPart().lastIndexOf(46);
            if (lastDot >= 0) {
                return String.valueOf(qname.getLocalPart().substring(lastDot + 1)) + " {" + qname.getLocalPart().substring(5, lastDot) + "}";
            }
            return qname.getLocalPart().substring(5);
        }
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI == null || namespaceURI.isEmpty()) {
            return qname.getLocalPart();
        }
        return String.valueOf(qname.getLocalPart()) + " {" + namespaceURI + "}";
    }

    private List<TransformType> loadTransformsFromTarget(SwitchYardType switchYard) {
        return MergedModelUtil.getAdapter((EObject)switchYard, SwitchYardMergedModelAdapter.class).getTransforms();
    }

    public boolean transformExists(String from, String to) {
        if (this._targetTransforms != null) {
            for (TransformType targetTransformType : this._targetTransforms) {
                boolean testToMatch = targetTransformType.getTo().equals(to);
                boolean testFromMatch = targetTransformType.getFrom().equals(from);
                if (!testToMatch || !testFromMatch) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getInputTypesAsStringsForEObjectConfig(EObject modelObj) throws Exception {
        return this.getTypesAsStrings(this.getTypesForConfigFromModelObject(modelObj, true, false, false));
    }

    public String[] getTypesAsStringsForEObjectConfig(EObject modelObj) throws Exception {
        return this.getTypesAsStrings(this.getTypesForConfigFromModelObject(modelObj, true, true, true));
    }

    public String[] getOutputTypesAsStringsForEObjectConfig(EObject modelObj) throws Exception {
        return this.getTypesAsStrings(this.getTypesForConfigFromModelObject(modelObj, false, true, true));
    }

    private Set<QName> getTypesForConfigFromModelObject(EObject modelObj, boolean input, boolean output, boolean fault) throws Exception {
        HashSet<QName> typesList = new HashSet<QName>();
        ArrayList<ServiceInterface> services = this.getOperationsForConfigFromModelObject(modelObj);
        for (ServiceInterface baseService : services) {
            Set ops = baseService.getOperations();
            for (ServiceOperation serviceOperation : ops) {
                if (serviceOperation.getInputType() != null && input) {
                    typesList.add(serviceOperation.getInputType());
                }
                if (serviceOperation.getOutputType() != null && output) {
                    typesList.add(serviceOperation.getOutputType());
                }
                if (serviceOperation.getFaultType() == null || !fault) continue;
                typesList.add(serviceOperation.getFaultType());
            }
        }
        return typesList;
    }

    public boolean isOnlyOneServiceOperation(EObject object) throws Exception {
        ArrayList<ServiceInterface> services = this.getOperationsForConfigFromModelObject(object);
        for (ServiceInterface service : services) {
            if (service.getOperations().size() != 1) continue;
            return true;
        }
        return false;
    }

    public HashMap<String, String> createMappings(EObject fromObj, EObject toObj) throws Exception {
        HashMap<String, String> mappings = new HashMap<String, String>();
        ArrayList<ServiceInterface> fromservices = this.getOperationsForConfigFromModelObject(fromObj);
        ArrayList<ServiceInterface> toservices = this.getOperationsForConfigFromModelObject(toObj);
        for (ServiceInterface baseFromService : fromservices) {
            Set fromOps = baseFromService.getOperations();
            for (ServiceOperation fromServiceOperation : fromOps) {
                block2: for (ServiceInterface baseToService : toservices) {
                    Set toOps = baseToService.getOperations();
                    for (ServiceOperation toServiceOperation : toOps) {
                        if (!fromServiceOperation.getName().equals(toServiceOperation.getName())) continue;
                        if (fromServiceOperation.getInputType() != null && toServiceOperation.getInputType() != null) {
                            mappings.put(fromServiceOperation.getInputType().toString(), toServiceOperation.getInputType().toString());
                        }
                        if (fromServiceOperation.getOutputType() != null && toServiceOperation.getOutputType() != null) {
                            mappings.put(fromServiceOperation.getOutputType().toString(), toServiceOperation.getOutputType().toString());
                        }
                        if (fromServiceOperation.getFaultType() == null || toServiceOperation.getFaultType() == null) continue block2;
                        mappings.put(fromServiceOperation.getFaultType().toString(), toServiceOperation.getFaultType().toString());
                        continue block2;
                    }
                }
            }
        }
        return mappings;
    }

    private ArrayList<ServiceInterface> getOperationsForConfigFromModelObject(EObject modelObj) throws Exception {
        ArrayList<ServiceInterface> runtimeServices = new ArrayList<ServiceInterface>();
        ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(JavaUtil.getProjectClassLoader((IJavaProject)JavaCore.create((IProject)SwitchyardSCAEditor.getActiveEditor().getTargetModelFile().getProject()), null));
        try {
            Contract contract;
            if (modelObj instanceof Contract && (contract = (Contract)modelObj).getInterface() != null) {
                runtimeServices.add(SwitchYardModelUtils.getServiceInterface((Interface)contract.getInterface()));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTCCL);
        }
        return runtimeServices;
    }
}

