/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.transform.JsonTransformType;
import org.switchyard.tools.models.switchyard1_0.transform.TransformFactory;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.transform.INewTransformWizard;
import org.switchyard.tools.ui.editor.transform.ITransformControl;
import org.switchyard.tools.ui.editor.transform.ITransformProvider;
import org.switchyard.tools.ui.editor.transform.NewTransformWizard;

public class JSONTransformProvider
implements ITransformProvider {
    private Collection<TransformType> _transforms;

    @Override
    public boolean providesWizard() {
        return false;
    }

    @Override
    public INewTransformWizard createWizard() {
        return null;
    }

    @Override
    public ITransformControl createTransformControl(Composite parent, ITransformProvider.IContainer container) {
        return new ITransformControl(){

            @Override
            public IStatus validate() {
                if (JSONTransformProvider.this._transforms != null) {
                    for (TransformType transformer : JSONTransformProvider.this._transforms) {
                        if (!(NewTransformWizard.isJavaType(transformer.getFrom()) ? NewTransformWizard.isJavaType(transformer.getTo()) : !NewTransformWizard.isJavaType(transformer.getTo()))) continue;
                        return new Status(4, "org.switchyard.tools.ui.editor", Messages.error_jsonTransformerOnlySupportsJsonToFromJava);
                    }
                }
                return Status.OK_STATUS;
            }

            @Override
            public void dispose() {
            }

            @Override
            public void setVisible(boolean visible) {
            }

            @Override
            public void setSelectedTransforms(Collection<TransformType> transforms) {
                JSONTransformProvider.this._transforms = transforms;
            }

            @Override
            public void setLayoutData(Object data) {
            }

            @Override
            public Collection<TransformType> createTransforms() {
                if (JSONTransformProvider.this._transforms == null) {
                    return Collections.emptyList();
                }
                ArrayList<TransformType> jsonTransforms = new ArrayList<TransformType>(JSONTransformProvider.this._transforms.size());
                for (TransformType transform : JSONTransformProvider.this._transforms) {
                    JsonTransformType jsonTransform = TransformFactory.eINSTANCE.createJsonTransformType();
                    jsonTransform.setFrom(transform.getFrom());
                    jsonTransform.setTo(transform.getTo());
                    jsonTransforms.add((TransformType)jsonTransform);
                }
                return jsonTransforms;
            }
        };
    }

    @Override
    public String getName() {
        return Messages.label_jsonTransformer;
    }
}

