/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.model.merge;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.switchyard.tools.models.switchyard1_0.switchyard.ArtifactsType;
import org.switchyard.tools.models.switchyard1_0.switchyard.DocumentRoot;
import org.switchyard.tools.models.switchyard1_0.switchyard.DomainType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.models.switchyard1_0.switchyard.TransformsType;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidatesType;
import org.switchyard.tools.models.switchyard1_0.switchyard.util.SwitchyardResourceImpl;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.editor.model.merge.AbstractMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.ArtifactsMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.ComponentMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.CompositeMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.ContractMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.DomainMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUpdateAdapter;
import org.switchyard.tools.ui.editor.model.merge.SwitchYardDiffEngine;
import org.switchyard.tools.ui.editor.model.merge.SwitchYardMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.TransformsMergedModelAdapter;
import org.switchyard.tools.ui.editor.model.merge.ValidatesMergedModelAdapter;

public class MergedModelAdapterFactory
extends AdapterFactoryImpl {
    private Resource _source;
    private Resource _generated;
    private SwitchYardType _switchYard;
    private MatchCrossReferencer _crossReferencedMatches;
    private Comparison _comparison;
    private Map<AbstractMergedModelAdapter, Map<EStructuralFeature, Object>> _cache = new HashMap<AbstractMergedModelAdapter, Map<EStructuralFeature, Object>>();
    private MergedModelUpdateAdapter _mergedModelUpdater;

    public MergedModelAdapterFactory(SwitchyardResourceImpl source) {
        EObject content;
        this._source = source;
        this._generated = source.getGeneratedResource();
        this._switchYard = this._source.getContents().isEmpty() ? null : ((content = (EObject)this._source.getContents().get(0)) instanceof SwitchYardType ? (SwitchYardType)content : (content instanceof DocumentRoot ? ((DocumentRoot)content).getSwitchyard() : null));
        this.calculateDifferences();
        this._mergedModelUpdater = new MergedModelUpdateAdapter(this);
        if (this._switchYard != null) {
            this._mergedModelUpdater.setTarget((Notifier)source);
        }
    }

    public boolean processUpdatesToGenerated(IFile generatedFile) {
        block18: {
            if (this._generated == null || generatedFile == null || !generatedFile.exists()) {
                return false;
            }
            ResourceSet rs = SwitchYardModelUtils.newResourceSet();
            Resource generatedResource = rs.createResource(URI.createPlatformResourceURI((String)generatedFile.getFullPath().toString(), (boolean)true), "org.switchyard.content-type.1.x");
            try {
                try {
                    generatedResource.load(null);
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                }
                if (!generatedResource.isLoaded()) {
                    return false;
                }
                Comparison comparison = this.createComparison((Notifier)generatedResource, (Notifier)this._generated);
                EList generatedDifferences = comparison.getDifferences();
                if (generatedDifferences.size() <= 0) break block18;
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this._switchYard);
                InternalTransaction transaction = domain instanceof TransactionalEditingDomainImpl ? ((TransactionalEditingDomainImpl)domain).getActiveTransaction() : null;
                if (transaction != null) {
                    transaction.pause();
                }
                try {
                    if (this._generated.getContents().size() == 0) {
                        if (generatedResource.getContents().size() > 0) {
                            this._generated.getContents().addAll((Collection)generatedResource.getContents());
                            generatedResource.getContents().clear();
                        }
                    } else {
                        new BatchMerger(EMFCompareRCPPlugin.getDefault().getMergerRegistry(), (Predicate)new Predicate<Diff>(){

                            public boolean apply(Diff object) {
                                return object.getKind() != DifferenceKind.MOVE;
                            }
                        }).copyAllLeftToRight((Iterable)generatedDifferences, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
                        this.pruneMissingReferences();
                    }
                }
                finally {
                    if (transaction != null) {
                        transaction.resume(null);
                    }
                }
                this.calculateDifferences();
                DiagramAffectedDiffSwitch affectedSwitch = new DiagramAffectedDiffSwitch();
                for (Diff element : generatedDifferences) {
                    Boolean affected = (Boolean)affectedSwitch.doSwitch((EObject)element);
                    if (affected == null || !affected.booleanValue()) continue;
                    return true;
                }
            }
            finally {
                generatedResource.unload();
            }
        }
        return false;
    }

    private void pruneMissingReferences() {
        for (Map.Entry<EObject, Collection<EStructuralFeature.Setting>> entry : new MissingReferencesCrossReferencer((EObject)this._switchYard).findMissingCrossReferences().entrySet()) {
            EObject proxySource = entry.getKey();
            for (EStructuralFeature.Setting setting : entry.getValue()) {
                EStructuralFeature feature = setting.getEStructuralFeature();
                if (feature.isMany()) {
                    List value = (List)setting.getEObject().eGet(setting.getEStructuralFeature());
                    value.remove(proxySource);
                    continue;
                }
                if (feature.isUnsettable()) {
                    setting.getEObject().eUnset(feature);
                    continue;
                }
                setting.getEObject().eSet(feature, null);
            }
        }
    }

    public boolean isFactoryForType(Object type) {
        return type instanceof Class && (AbstractMergedModelAdapter.class.isAssignableFrom((Class)type) || type == ((Object)((Object)this)).getClass());
    }

    protected Adapter createAdapter(Notifier target) {
        if (target instanceof SwitchYardType) {
            return new SwitchYardMergedModelAdapter(this);
        }
        if (target instanceof ArtifactsType) {
            return new ArtifactsMergedModelAdapter(this);
        }
        if (target instanceof Composite) {
            return new CompositeMergedModelAdapter(this);
        }
        if (target instanceof Component) {
            return new ComponentMergedModelAdapter(this);
        }
        if (target instanceof Contract) {
            return new ContractMergedModelAdapter(this);
        }
        if (target instanceof DomainType) {
            return new DomainMergedModelAdapter(this);
        }
        if (target instanceof TransformsType) {
            return new TransformsMergedModelAdapter(this);
        }
        if (target instanceof ValidatesType) {
            return new ValidatesMergedModelAdapter(this);
        }
        return null;
    }

    protected Comparison getDifferences(EObject target) {
        if (target == null || target.eResource() != this._source) {
            return null;
        }
        return this._comparison;
    }

    protected SwitchYardType getSwitchYard() {
        return this._switchYard;
    }

    protected Object getCachedFeatureDifferences(AbstractMergedModelAdapter mergedModel, EStructuralFeature feature) {
        Map<EStructuralFeature, Object> modelCache = this._cache.get(mergedModel);
        if (modelCache == null) {
            return null;
        }
        return modelCache.get(feature);
    }

    protected void cacheFeatureDifferences(AbstractMergedModelAdapter mergedModel, EStructuralFeature feature, Object differences) {
        Map<EStructuralFeature, Object> modelCache = this._cache.get(mergedModel);
        if (modelCache == null) {
            modelCache = new HashMap<EStructuralFeature, Object>();
            this._cache.put(mergedModel, modelCache);
        }
        modelCache.put(feature, differences);
    }

    protected void clearFeatureDifferencesCache(AbstractMergedModelAdapter mergedModel) {
        this._cache.remove(mergedModel);
    }

    protected EObject getGenerated(EObject source) {
        if (this._crossReferencedMatches == null || source == null) {
            return null;
        }
        Collection settings = (Collection)this._crossReferencedMatches.get(source);
        if (settings == null) {
            return null;
        }
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != ComparePackage.eINSTANCE.getMatch_Left()) continue;
            return ((Match)setting.getEObject()).getRight();
        }
        return source;
    }

    public EObject getSource(EObject generated) {
        if (this._crossReferencedMatches == null || generated == null) {
            return generated;
        }
        Collection settings = (Collection)this._crossReferencedMatches.get(generated);
        if (settings == null) {
            return generated;
        }
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != ComparePackage.eINSTANCE.getMatch_Right()) continue;
            return ((Match)setting.getEObject()).getLeft();
        }
        return generated;
    }

    protected void setMatchedFromSource(EObject source, EObject generated) {
        if (this._crossReferencedMatches == null) {
            return;
        }
        Match match = this.getMatch(source, true);
        if (match == null) {
            return;
        }
        match.setRight(generated);
        this._crossReferencedMatches.getCollection(generated).add(((InternalEObject)match).eSetting((EStructuralFeature)ComparePackage.eINSTANCE.getMatch_Right()));
    }

    protected void removeMatchFromSource(Object source) {
        if (!(source instanceof EObject)) {
            return;
        }
        Match match = this.getMatch((EObject)source, true);
        ((Collection)match.eContainer().eGet(match.eContainingFeature())).remove(match);
        this._crossReferencedMatches.remove((EObject)source);
        if (match.getRight() != null) {
            this._crossReferencedMatches.remove(match.getRight());
        }
    }

    private Match getMatch(EObject object, boolean isLeft) {
        if (object == null) {
            return null;
        }
        Collection<EStructuralFeature.Setting> settings = this._crossReferencedMatches.getCollection(object);
        if (settings.isEmpty()) {
            Match parentMatch = this.getMatch(object.eContainer(), isLeft);
            if (parentMatch == null) {
                return null;
            }
            Match newMatch = CompareFactory.eINSTANCE.createMatch();
            if (isLeft) {
                newMatch.setLeft(object);
                settings.add(((InternalEObject)newMatch).eSetting((EStructuralFeature)ComparePackage.eINSTANCE.getMatch_Left()));
            } else {
                newMatch.setRight(object);
                settings.add(((InternalEObject)newMatch).eSetting((EStructuralFeature)ComparePackage.eINSTANCE.getMatch_Right()));
            }
            parentMatch.getSubmatches().add((Object)newMatch);
            return newMatch;
        }
        Iterator<EStructuralFeature.Setting> iterator = settings.iterator();
        if (iterator.hasNext()) {
            EStructuralFeature.Setting setting = iterator.next();
            return (Match)setting.getEObject();
        }
        return null;
    }

    public void calculateDifferences() {
        if (this._generated == null) {
            this._comparison = null;
            this._crossReferencedMatches = null;
            return;
        }
        this._comparison = this.createComparison((Notifier)this._source, (Notifier)this._generated);
        this._crossReferencedMatches = new MatchCrossReferencer((Collection)this._comparison.getMatches());
        this._cache.clear();
    }

    private Comparison createComparison(Notifier source, Notifier generated) {
        return EMFCompare.builder().setMatchEngineFactoryRegistry(EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry()).setDiffEngine((IDiffEngine)new SwitchYardDiffEngine((IDiffProcessor)new DiffBuilder())).build().compare(EMFCompare.createDefaultScope((Notifier)source, (Notifier)generated));
    }

    protected boolean isCopiedSource(EObject source, EObject generated) {
        if (source == generated) {
            return true;
        }
        if (this.getDifferencesFor(source).size() > 0 || generated == null) {
            return false;
        }
        final EObject sourceParent = this.getSource(generated.eContainer());
        for (Diff diff : this.getDifferencesFor(generated)) {
            if (!((Boolean)new CompareSwitch<Boolean>(){

                public Boolean caseAttributeChange(AttributeChange object) {
                    if (object.getMatch().getLeft() == sourceParent) {
                        return true;
                    }
                    return false;
                }

                public Boolean caseReferenceChange(ReferenceChange object) {
                    if (object.getMatch().getLeft() == sourceParent) {
                        return true;
                    }
                    return false;
                }

                public Boolean defaultCase(EObject object) {
                    return false;
                }
            }.doSwitch((EObject)diff)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected List<Diff> getDifferencesFor(EObject object) {
        if (this._comparison == null) {
            return Collections.emptyList();
        }
        ArrayList<Diff> objectDifferences = new ArrayList<Diff>();
        for (Diff diff : this._comparison.getDifferences()) {
            if (!this.isPertinentDiff(diff, object)) continue;
            objectDifferences.add(diff);
        }
        return objectDifferences;
    }

    private boolean isPertinentDiff(Diff diff, final EObject modelElement) {
        return (Boolean)new CompareSwitch<Boolean>(){

            public Boolean caseAttributeChange(AttributeChange object) {
                if (object.getMatch().getLeft() != modelElement && object.getMatch().getRight() != modelElement) {
                    return false;
                }
                return true;
            }

            public Boolean caseReferenceChange(ReferenceChange object) {
                if (object.getMatch().getLeft() != modelElement && object.getMatch().getRight() != modelElement) {
                    return false;
                }
                return true;
            }

            public Boolean defaultCase(EObject object) {
                return false;
            }
        }.doSwitch((EObject)diff);
    }

    private static final class DiagramAffectedDiffSwitch
    extends CompareSwitch<Boolean> {
        private DiagramAffectedDiffSwitch() {
        }

        public Boolean caseDiff(Diff object) {
            if (object.getKind() != DifferenceKind.MOVE) {
                return false;
            }
            EObject leftTarget = object.getMatch().getLeft();
            EObject rightTarget = object.getMatch().getRight();
            if (!(leftTarget instanceof Component || leftTarget instanceof Contract || rightTarget instanceof Component || rightTarget instanceof Contract)) {
                return false;
            }
            return true;
        }
    }

    private static final class MatchCrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;

        private MatchCrossReferencer(Collection<?> emfObjects) {
            super(emfObjects);
            this.crossReference();
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return eReference == ComparePackage.eINSTANCE.getMatch_Left() || eReference == ComparePackage.eINSTANCE.getMatch_Right();
        }

        public Collection<EStructuralFeature.Setting> getCollection(Object key) {
            return super.getCollection(key);
        }
    }

    private static final class MissingReferencesCrossReferencer
    extends EcoreUtil.UnresolvedProxyCrossReferencer {
        private static final long serialVersionUID = 1L;

        private MissingReferencesCrossReferencer(EObject eObject) {
            super(eObject);
            this.crossReference();
        }

        protected Map<EObject, Collection<EStructuralFeature.Setting>> findMissingCrossReferences() {
            return super.findUnresolvedProxyCrossReferences();
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return crossReferencedEObject.eResource() == null;
        }
    }
}

