/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram;

import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class SynchronizeGeneratedModelFeature
extends AbstractCustomFeature {
    private boolean _hasDoneChanges;
    private boolean _automated;

    public SynchronizeGeneratedModelFeature(IFeatureProvider fp) {
        this(fp, false);
    }

    public SynchronizeGeneratedModelFeature(IFeatureProvider fp, boolean automated) {
        super(fp);
        this._automated = automated;
    }

    public void execute(ICustomContext context) {
        this._hasDoneChanges = false;
        ResourceSet rs = this.getDiagramBehavior().getEditingDomain().getResourceSet();
        SwitchyardSCAEditor.SwitchyardSCAEditorAdapter editorAdapter = (SwitchyardSCAEditor.SwitchyardSCAEditorAdapter)EcoreUtil.getAdapter((List)rs.eAdapters(), SwitchyardSCAEditor.SwitchyardSCAEditorAdapter.class);
        if (editorAdapter == null) {
            return;
        }
        if (editorAdapter.getSwitchyardEditor().isDirty()) {
            if (!this._automated) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.title_cannotSynchronize, (String)Messages.error_cannotSynchronize);
            }
            return;
        }
        if (!this.getUserDecision()) {
            return;
        }
        this._hasDoneChanges = editorAdapter.getSwitchyardEditor().synchronizeGeneratedModel();
    }

    public String getName() {
        return Messages.featureName_synchronizeConfiguration;
    }

    public String getDescription() {
        return Messages.featureDescription_synchronizeConfiguration;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_SYNCHRONIZE;
    }

    public boolean canExecute(ICustomContext context) {
        SwitchyardSCAEditor.SwitchyardSCAEditorAdapter editorAdapter = (SwitchyardSCAEditor.SwitchyardSCAEditorAdapter)EcoreUtil.getAdapter((List)this.getDiagramBehavior().getEditingDomain().getResourceSet().eAdapters(), SwitchyardSCAEditor.SwitchyardSCAEditorAdapter.class);
        return editorAdapter != null && editorAdapter.getSwitchyardEditor().needToSynchronizeGeneratedModel();
    }

    public boolean hasDoneChanges() {
        return this._hasDoneChanges;
    }

    public boolean canUndo(IContext context) {
        return false;
    }

    protected boolean getUserDecision() {
        return this._automated || MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.title_synchronizeConfiguration, (String)Messages.warning_synchronizeConfiguration);
    }
}

