/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.soap;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.soap.ProxyType;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPBindingType;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPFactory;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyIntegerValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;

public class SOAPProxyComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private SOAPBindingType _binding = null;
    private Text _proxyHostText;
    private Text _proxyPortText;
    private Text _proxyUserText;
    private Text _proxyPasswordText;
    private ComboViewer _proxyTypeCombo;
    private WritableValue _bindingValue;

    SOAPProxyComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_proxySettings;
    }

    @Override
    public String getDescription() {
        return Messages.description_soapProxySettings;
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getProxyTabControl(this._panel);
        this.bindControls(context);
    }

    private Control getProxyTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._proxyTypeCombo = this.createLabelAndComboViewer(composite, Messages.label_type, true);
        this._proxyTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._proxyTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        String[] proxyTypes = new String[]{"HTTP", "SOCKS"};
        this._proxyTypeCombo.setInput((Object)proxyTypes);
        this._proxyHostText = this.createLabelAndText(composite, Messages.label_host);
        this._proxyPortText = this.createLabelAndText(composite, Messages.label_port);
        this._proxyUserText = this.createLabelAndText(composite, Messages.label_userName);
        this._proxyPasswordText = this.createLabelAndText(composite, Messages.label_password);
        return composite;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    public void setBinding(Binding switchYardBindingType) {
        super.setBinding(switchYardBindingType);
        if (switchYardBindingType instanceof SOAPBindingType) {
            this.setTargetObject(switchYardBindingType.eContainer());
            this._binding = (SOAPBindingType)switchYardBindingType;
            this._bindingValue.setValue((Object)this._binding);
        } else {
            this._bindingValue.setValue(null);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._proxyHostText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, SOAPBindingType.class);
        WritableValue proxyTypeValue = new WritableValue(realm, null, String.class);
        WritableValue hostValue = new WritableValue(realm, null, String.class);
        WritableValue passwordValue = new WritableValue(realm, null, String.class);
        WritableValue portValue = new WritableValue(realm, null, String.class);
        WritableValue userValue = new WritableValue(realm, null, String.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._proxyHostText, (int)24), (IObservableValue)hostValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._proxyTypeCombo), (IObservableValue)proxyTypeValue);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._proxyPasswordText, (int)24), (IObservableValue)passwordValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._proxyPortText, (int)24), (IObservableValue)portValue, new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Port must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._proxyUserText, (int)24), (IObservableValue)userValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        ComputedValue computedProxy = new ComputedValue((IObservableValue)proxyTypeValue, (IObservableValue)hostValue, (IObservableValue)passwordValue, (IObservableValue)portValue, (IObservableValue)userValue){
            private final /* synthetic */ IObservableValue val$proxyTypeValue;
            private final /* synthetic */ IObservableValue val$hostValue;
            private final /* synthetic */ IObservableValue val$passwordValue;
            private final /* synthetic */ IObservableValue val$portValue;
            private final /* synthetic */ IObservableValue val$userValue;
            {
                this.val$proxyTypeValue = iObservableValue;
                this.val$hostValue = iObservableValue2;
                this.val$passwordValue = iObservableValue3;
                this.val$portValue = iObservableValue4;
                this.val$userValue = iObservableValue5;
            }

            protected Object calculate() {
                String proxyType = (String)this.val$proxyTypeValue.getValue();
                String host = (String)this.val$hostValue.getValue();
                String pwd = (String)this.val$passwordValue.getValue();
                String port = (String)this.val$portValue.getValue();
                String user = (String)this.val$userValue.getValue();
                if (host != null || pwd != null || port != null || user != null) {
                    ProxyType proxy = SOAPFactory.eINSTANCE.createProxyType();
                    proxy.setHost(host);
                    proxy.setPassword(pwd);
                    proxy.setPort((Object)port);
                    proxy.setUser(user);
                    proxy.setType(proxyType);
                    return proxy;
                }
                return null;
            }

            protected void doSetValue(Object value) {
                if (value instanceof ProxyType) {
                    ProxyType proxy = (ProxyType)value;
                    this.val$hostValue.setValue((Object)proxy.getHost());
                    this.val$passwordValue.setValue((Object)proxy.getPassword());
                    this.val$portValue.setValue(proxy.getPort());
                    this.val$userValue.setValue((Object)proxy.getUser());
                    this.val$proxyTypeValue.setValue((Object)proxy.getType());
                } else {
                    this.val$hostValue.setValue(null);
                    this.val$passwordValue.setValue(null);
                    this.val$portValue.setValue(null);
                    this.val$userValue.setValue(null);
                    this.val$proxyTypeValue.setValue((Object)"HTTP");
                }
                this.getValue();
            }
        };
        binding = context.bindValue((IObservableValue)computedProxy, ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__PROXY));
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

