/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.test.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.test.util.ResourcesUtils;

public class ResourceFactory {
    public static final IFile createFile(String content) {
        Object proxy = Proxy.newProxyInstance(IFile.class.getClassLoader(), new Class[]{IFile.class}, (InvocationHandler)new FileInvocationHandler(content));
        return (IFile)proxy;
    }

    public static final IFile createFile(String content, IPath fullPath) {
        Object proxy = Proxy.newProxyInstance(IFile.class.getClassLoader(), new Class[]{IFile.class}, (InvocationHandler)new FileInvocationHandler(content, fullPath));
        return (IFile)proxy;
    }

    public static final IFile createFile(String content, String project, String fileName) throws CoreException, IOException {
        IProject prj = ResourcesUtils.createEclipseProject("Test");
        IFile result = prj.getFile(fileName);
        result.create((InputStream)new StringBufferInputStream(content), true, null);
        return result;
    }

    public static class FileInvocationHandler
    implements InvocationHandler {
        private String content;
        private IPath fullPath;

        public FileInvocationHandler(String content) {
            this.content = content;
        }

        public FileInvocationHandler(String content, IPath fullPath) {
            this(content);
            this.fullPath = fullPath;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            if (method.equals(IFile.class.getMethod("getContents", new Class[0]))) {
                result = new StringBufferInputStream(this.content);
            } else if (method.equals(IFile.class.getMethod("exists", new Class[0]))) {
                result = Boolean.TRUE;
            } else if (method.equals(IFile.class.getMethod("getFullPath", new Class[0]))) {
                result = this.fullPath;
            } else if (method.equals(IFile.class.getMethod("isAccessible", new Class[0]))) {
                return true;
            }
            return result;
        }
    }
}

