/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.util;

import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;

public class NameUtil {
    public static String normalizeName(String nameIn) {
        String normal = nameIn.trim();
        normal = NameUtil.removeDuplicate(normal);
        normal = NameUtil.removeSpaces(normal);
        normal = NameUtil.removeIllegalChars(normal);
        normal = NameUtil.removeTrailingUnderscore(normal);
        normal = NameUtil.removeLeadingUnderscore(normal);
        normal = NameUtil.checkReservedWords(normal);
        return normal;
    }

    private static String checkReservedWords(String normal) {
        IQueryService sqlSyntaxService = ModelerCore.getTeiidQueryService();
        if (sqlSyntaxService.isReservedWord(normal) || sqlSyntaxService.isProcedureReservedWord(normal)) {
            normal = String.valueOf(normal) + "_";
        }
        return normal;
    }

    private static String removeTrailingUnderscore(String normal) {
        if (normal.endsWith("_")) {
            return normal.substring(0, normal.lastIndexOf(95));
        }
        return normal;
    }

    private static String removeIllegalChars(String normal) {
        String edit = normal;
        edit = edit.replace('.', '_');
        edit = edit.replace('(', '_');
        edit = edit.replace(')', '_');
        edit = edit.replace('/', '_');
        edit = edit.replace('\\', '_');
        edit = edit.replace(':', '_');
        edit = edit.replace('\'', '_');
        edit = edit.replace('-', '_');
        edit = edit.replace("%", "percentage");
        edit = edit.replace("#", "number");
        edit = edit.replace("$", "_");
        edit = edit.replace("{", "_");
        edit = edit.replace("}", "_");
        return edit;
    }

    private static String removeSpaces(String normal) {
        return normal.replace(' ', '_');
    }

    private static String removeDuplicate(String normal) {
        String secondPart;
        if (normal.indexOf(40) < 0 || normal.indexOf(41) != normal.length() - 1) {
            return normal;
        }
        String firstPart = normal.substring(0, normal.indexOf(40)).trim();
        if (firstPart.equals(secondPart = normal.substring(normal.indexOf(40) + 1, normal.length() - 1).trim()) || secondPart.equals("null")) {
            return firstPart;
        }
        return normal;
    }

    private static String removeLeadingUnderscore(String normal) {
        while (normal.indexOf(95) == 0) {
            normal = normal.substring(1);
        }
        return normal;
    }
}

