/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.connection.impl;

import com.sforce.soap.partner.CallOptions;
import com.sforce.soap.partner.InvalidIdFault;
import com.sforce.soap.partner.LoginFault;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.SessionHeader;
import com.sforce.soap.partner.SforceService;
import com.sforce.soap.partner.Soap;
import com.sforce.soap.partner.UnexpectedErrorFault;
import java.net.URL;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.designer.modelgenerator.salesforce.connection.SalesforceConnection;
import org.teiid.designer.modelgenerator.salesforce.connection.impl.SalesforceHandlerResolver;

public class Connection
implements SalesforceConnection {
    private SforceService sfService;
    private Soap sfSoap;
    private SessionHeader sh;
    private CallOptions co;

    String getUserName() throws Exception {
        try {
            return this.sfSoap.getUserInfo().getUserName();
        }
        catch (UnexpectedErrorFault e) {
            throw new Exception(e);
        }
    }

    @Override
    public Soap getBinding() {
        return this.sfSoap;
    }

    @Override
    public void login(String username, String password, URL url) throws Exception {
        if (!this.isValid()) {
            LoginResult loginResult = null;
            this.sfSoap = null;
            this.sfService = null;
            this.co = new CallOptions();
            this.co.setClient("RedHat/MetaMatrix/");
            if (url == null) {
                throw new Exception("SalesForce URL is not specified, please provide a valid URL");
            }
            try {
                this.sfService = new SforceService();
                this.sh = new SessionHeader();
                this.sfService.setHandlerResolver((HandlerResolver)new SalesforceHandlerResolver(this.sh));
                this.sfSoap = this.sfService.getSoap();
                ((BindingProvider)this.sfSoap).getRequestContext().put("javax.xml.ws.service.endpoint.address", url.toExternalForm());
                loginResult = this.sfSoap.login(username, password);
                this.sh.setSessionId(loginResult.getSessionId());
            }
            catch (LoginFault e) {
                throw new Exception(e);
            }
            catch (InvalidIdFault e) {
                throw new Exception(e);
            }
            catch (UnexpectedErrorFault e) {
                throw new Exception(e);
            }
            ((BindingProvider)this.sfSoap).getRequestContext().put("javax.xml.ws.service.endpoint.address", loginResult.getServerUrl());
            ((BindingProvider)this.sfSoap).getRequestContext().put("javax.xml.ws.session.maintain", Boolean.TRUE);
            try {
                this.sfSoap.getUserInfo();
            }
            catch (UnexpectedErrorFault e) {
                throw new Exception(e);
            }
        }
    }

    public boolean isValid() {
        boolean result = true;
        if (this.sfSoap == null) {
            result = false;
        } else {
            try {
                this.sfSoap.getServerTimestamp();
            }
            catch (Throwable t) {
                CoreModelerPlugin.Util.log(t);
                result = false;
            }
        }
        return result;
    }
}

