/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.wizards;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;
import org.teiid.designer.ui.viewsupport.NewModelProjectWorker;

public class CloneProjectWizard
extends BasicNewProjectResourceWizard
implements UiConstants {
    private WizardNewProjectCreationPage mainPage;
    private IProject selectedProject;
    private IProject clonedProject;
    private static final String[] MODEL_NATURES = new String[]{"org.teiid.designer.core.modelNature"};

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage");
        this.mainPage.setTitle(Util.getString("CloneProjectWizard.title", new Object[0]));
        this.mainPage.setDescription(Util.getString("CloneProjectWizard.description", new Object[0]));
        this.setWindowTitle(Util.getString("CloneProjectWizard.title", new Object[0]));
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        String projName = this.mainPage.getProjectName();
        ValidationResultImpl result = new ValidationResultImpl((Object)projName);
        this.checkInvalidChars((ValidationResult)result, projName, UiConstants.NamingAttributes.VALID_PROJECT_CHARS);
        if (result.hasProblems()) {
            String eMsg = String.valueOf(Util.getString("NewModelProjectWizard.namingError.msg", new Object[0])) + '\n' + result.getProblems()[0].getMessage();
            String eTitle = Util.getString("NewModelProjectWizard.namingError.title", new Object[0]);
            MessageDialog.openWarning((Shell)this.getShell(), (String)eTitle, (String)eMsg);
            return false;
        }
        this.clonedProject = this.createProject();
        if (this.clonedProject == null) {
            return false;
        }
        try {
            String productName;
            IProjectDescription desc = this.clonedProject.getDescription();
            desc.setNatureIds(MODEL_NATURES);
            if (ProductCustomizerMgr.getInstance() != null && !CoreStringUtil.isEmpty((String)(productName = ProductCustomizerMgr.getInstance().getProductName()))) {
                desc.setComment(String.valueOf(productName) + ", version " + ModelerCore.ILicense.VERSION);
            }
            this.clonedProject.setDescription(desc, null);
            this.clonedProject.close(null);
            this.clonedProject.open(null);
            this.cloneProject();
            ModelerUiViewUtils.refreshModelExplorerResourceNavigatorTree();
            ModelerUiViewUtils.refreshWorkspace();
            return true;
        }
        catch (CoreException err) {
            Util.log(4, (Throwable)err, err.getMessage());
            return false;
        }
    }

    private void checkInvalidChars(ValidationResult result, String stringToValidate, char[] validChars) {
        CoreArgCheck.isNotNull((Object)stringToValidate);
        CoreArgCheck.isNotNull((Object)result);
        StringNameValidator validator = new StringNameValidator(validChars);
        String reasonInvalid = validator.checkValidName(stringToValidate);
        if (reasonInvalid != null) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, reasonInvalid);
            result.addProblem((ValidationProblem)problem);
        }
    }

    public void setProject(IProject theProject) {
        this.selectedProject = theProject;
    }

    private void cloneProject() {
        try {
            ModelerCore.getModelEditor().cloneProject(this.selectedProject.getLocation().toOSString(), this.clonedProject.getLocation().toOSString());
        }
        catch (IOException theException) {
            UiConstants.Util.log(4, (Throwable)theException, theException.getLocalizedMessage());
        }
    }

    private IProject createProject() {
        IProject proj = null;
        IPath locationPath = this.mainPage.getLocationPath();
        if (locationPath != null && locationPath.toOSString().equalsIgnoreCase(Platform.getLocation().toOSString())) {
            locationPath = null;
        }
        NewModelProjectWorker worker = new NewModelProjectWorker();
        proj = worker.createNewProject(locationPath, this.mainPage.getProjectName(), (IProgressMonitor)new NullProgressMonitor());
        return proj;
    }
}

