/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.viewsupport;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.ICheatSheetEvent;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.ui.viewsupport.DesignerProperties;

public class PropertiesContextManager
extends CheatSheetListener {
    Map<String, Properties> cachedPropertiesMap = new HashMap<String, Properties>();

    public void addProperty(String id, String key, String value) {
        CoreArgCheck.isNotEmpty((String)id, (String)"id");
        CoreArgCheck.isNotEmpty((String)key, (String)"key");
        CoreArgCheck.isNotEmpty((String)value, (String)"value");
        Properties sheetProperties = this.getProperties(id);
        sheetProperties.put(key, value);
    }

    public String getProperty(String id, String key) {
        CoreArgCheck.isNotEmpty((String)id, (String)"id");
        CoreArgCheck.isNotEmpty((String)key, (String)"key");
        Properties sheetProperties = this.cachedPropertiesMap.get(id);
        if (sheetProperties != null) {
            return (String)sheetProperties.get(key);
        }
        return null;
    }

    public Properties getProperties(String id) {
        CoreArgCheck.isNotEmpty((String)id, (String)"id");
        Properties sheetProperties = this.cachedPropertiesMap.get(id);
        if (sheetProperties == null) {
            sheetProperties = new DesignerProperties(id);
            this.cachedPropertiesMap.put(id, sheetProperties);
        }
        return sheetProperties;
    }

    public void cheatSheetEvent(ICheatSheetEvent event) {
        Properties sheetProperties;
        if (event.getEventType() == 3 && (sheetProperties = this.cachedPropertiesMap.get(event.getCheatSheetID())) != null) {
            sheetProperties.clear();
        }
    }
}

