/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionProvider;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.print.IPrintable;
import org.teiid.designer.ui.common.print.Printable;
import org.teiid.designer.ui.common.table.DoubleClickTableViewer;
import org.teiid.designer.ui.common.table.TableColumnSelectionHelper;
import org.teiid.designer.ui.common.util.SystemClipboardUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.IInlineRenameable;
import org.teiid.designer.ui.editors.INavigationSupported;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorPageOutline;
import org.teiid.designer.ui.editors.NavigableEditor;
import org.teiid.designer.ui.editors.NavigationMarker;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.properties.udp.ExtensionPropertyDescriptor;
import org.teiid.designer.ui.table.ClipboardPasteProblemDialog;
import org.teiid.designer.ui.table.ClipboardPasteStatusRecord;
import org.teiid.designer.ui.table.ITablePasteValidator;
import org.teiid.designer.ui.table.ModelObjectTableModel;
import org.teiid.designer.ui.table.ModelObjectTableModelFactory;
import org.teiid.designer.ui.table.ModelObjectTableSelectionManager;
import org.teiid.designer.ui.table.ModelObjectTableSorter;
import org.teiid.designer.ui.table.ModelRowElement;
import org.teiid.designer.ui.table.ModelTableContentProvider;
import org.teiid.designer.ui.table.ModelTableEditorActionContributor;
import org.teiid.designer.ui.table.ModelTableEditorViewer;
import org.teiid.designer.ui.table.ModelTableLabelProvider;
import org.teiid.designer.ui.table.TableNotificationHandler;
import org.teiid.designer.ui.util.NoOpDropTargetAdapter;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelTableEditor
extends NavigableEditor
implements ModelEditorPage,
IInlineRenameable,
ITablePasteValidator,
INavigationSupported,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ModelTableEditor.class);
    static final String UNDO_PREFIX = String.valueOf(UiConstants.Util.getString("ModelTableEditor.undoPrefix", new Object[0])) + ' ';
    private static final String UNDO_INSERT_ROWS = UiConstants.Util.getString("ModelTableEditor.undoInsertRows", new Object[0]);
    private static final String TOOLTIP = UiConstants.Util.getString("ModelTableEditor.tooltip", new Object[0]);
    private ILabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    TabFolder tabFolder;
    ModelObjectSelectionManager selectionMgr;
    Map viewers = new HashMap();
    private ModelTableEditorActionContributor actionContributor;
    private TableNotificationHandler notificationHandler;
    private ModelResource modelResource;
    private Resource emfResource;
    Map selectionHelperMap = new HashMap();
    Map modelMap = new HashMap();
    private String title;
    private boolean lastReadOnly;
    private IBaseLabelProvider tableLabelProvider = new ModelTableLabelProvider();
    ModelEditor meParentEditor;

    @Override
    public void createPartControl(Composite parent) {
        this.selectionMgr = new ModelObjectSelectionManager();
        this.tabFolder = this.createContainer(parent);
        this.createTabs();
        int tabID = this.getActiveTab();
        if (tabID == 1 || tabID == 0) {
            this.setActiveTab(0);
            this.pageChange(0);
        }
    }

    private TabFolder createContainer(Composite parent) {
        final TabFolder container = new TabFolder(parent, 128);
        container.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = container.indexOf((TabItem)e.item);
                ModelTableEditor.this.pageChange(newPageIndex);
            }
        });
        return container;
    }

    protected void createTabs() {
        try {
            this.labelProvider = new ModelExplorerLabelProvider();
            this.contentProvider = ModelUtilities.getModelContentProvider();
            HashMap objectTypeMap = new HashMap();
            Collection types = this.buildObjectTypeMap(objectTypeMap);
            int tabIndex = 0;
            for (EClass tabClass : types) {
                ArrayList instanceList = (ArrayList)objectTypeMap.get(tabClass);
                if (this.canAddTable(instanceList.get(0))) {
                    this.addTab(tabClass, instanceList, tabIndex);
                } else {
                    --tabIndex;
                }
                ++tabIndex;
            }
        }
        catch (Exception e) {
            Util.log(4, (Throwable)e, String.valueOf(PREFIX) + "loadError");
        }
    }

    public boolean canAddTable(Object instance) {
        IPropertySource propertySource = ModelUtilities.getEmfPropertySourceProvider().getPropertySource(instance);
        IPropertyDescriptor[] properties = propertySource.getPropertyDescriptors();
        return properties.length > 0;
    }

    protected int addTab(EClass tabClass, ArrayList instanceList, int tabIndex) {
        boolean supportsDescriptions = ModelUtilities.supportsModelDescription(this.modelResource.getResource());
        ModelObjectTableModel model = ModelObjectTableModelFactory.createModelObjectTableModel(supportsDescriptions, tabClass, instanceList);
        if (model.canView()) {
            ModelTableEditorViewer tableViewer = new ModelTableEditorViewer((Composite)this.tabFolder, 66306);
            tableViewer.addDropSupport(1, new Transfer[0], (DropTargetListener)NoOpDropTargetAdapter.getInstance());
            this.selectionHelperMap.put(tableViewer, new TableColumnSelectionHelper((TableViewer)tableViewer));
            this.modelMap.put(tableViewer, model);
            tableViewer.getTable().setHeaderVisible(true);
            tableViewer.getTable().setLinesVisible(true);
            TableLayout layout = new TableLayout();
            tableViewer.getTable().setLayout((Layout)layout);
            model.setTableViewer((TableViewer)tableViewer);
            tableViewer.setCellModifier(new TableCellModifier());
            tableViewer.setContentProvider((IContentProvider)new ModelTableContentProvider(model));
            tableViewer.setLabelProvider(this.tableLabelProvider);
            tableViewer.setSorter((ViewerSorter)new ModelObjectTableSorter((TableViewer)tableViewer));
            ModelObjectTableSelectionManager tableSelectionMgr = new ModelObjectTableSelectionManager((TableViewer)tableViewer, model);
            tableSelectionMgr.addSelectionChangedListener(this.selectionMgr);
            this.selectionMgr.addSelectionChangedListener(tableSelectionMgr);
            tabIndex = tabIndex >= 0 ? this.addTab(tableViewer.getControl(), tabIndex) : this.addTab(tableViewer.getControl());
            TabItem item = this.tabFolder.getItems()[tabIndex];
            item.setData((Object)tabClass);
            String tabName = tabClass.getName();
            tabName = CoreStringUtil.computePluralForm((String)CoreStringUtil.computeDisplayableForm((String)tabName));
            this.setTabText(tabIndex, tabName);
            this.setTabToolTipText(tabIndex, tabName);
            Object o = instanceList.get(0);
            this.setTabImage(tabIndex, this.labelProvider.getImage(o));
            tableSelectionMgr.setName(tabName);
            this.viewers.put(tabName, tableViewer);
            this.getNotificationHandler().addTable(tabClass, (TableViewer)tableViewer, model);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (event.getSource() instanceof TabFolder && ModelTableEditor.this.getCurrentViewer() != null) {
                        StructuredSelection tableSel = (StructuredSelection)ModelTableEditor.this.getCurrentViewer().getSelection();
                        Iterator rowIter = tableSel.iterator();
                        ArrayList<EObject> objectList = new ArrayList<EObject>(tableSel.size());
                        Iterator iter = rowIter;
                        while (iter.hasNext()) {
                            ModelRowElement mre = (ModelRowElement)iter.next();
                            objectList.add(mre.getModelObject());
                        }
                        ModelTableEditor.this.selectionMgr.selectionChanged(new SelectionChangedEvent((ISelectionProvider)ModelTableEditor.this.getCurrentViewer(), (ISelection)new StructuredSelection(objectList)));
                    }
                }
            });
        }
        return tabIndex;
    }

    private Collection buildObjectTypeMap(HashMap objectTypeMap) throws CoreException {
        List modelContent = this.modelResource.getEObjects();
        Iterator iter = modelContent.iterator();
        while (iter.hasNext()) {
            this.loadObjectTypeMap(iter.next(), objectTypeMap);
        }
        TreeSet orderedSet = new TreeSet(new EClassNameComparator());
        orderedSet.addAll(objectTypeMap.keySet());
        return orderedSet;
    }

    private void loadObjectTypeMap(Object o, HashMap objectTypeMap) {
        EObject eObj;
        if (o instanceof EObject && ModelObjectUtilities.isPrimaryMetamodelObject(eObj = (EObject)o)) {
            ArrayList<Object> list = (ArrayList<Object>)objectTypeMap.get(eObj.eClass());
            if (list == null) {
                list = new ArrayList<Object>();
                objectTypeMap.put(eObj.eClass(), list);
            }
            list.add(o);
            if (this.contentProvider.hasChildren((Object)eObj)) {
                Object[] children = this.contentProvider.getChildren((Object)eObj);
                int i = 0;
                while (i < children.length) {
                    this.loadObjectTypeMap(children[i], objectTypeMap);
                    ++i;
                }
            }
        }
    }

    protected int addTab(Control control) {
        this.createTab(control);
        return this.getTabCount() - 1;
    }

    protected int addTab(Control control, int index) {
        return this.tabFolder.indexOf(this.createTab(control, index));
    }

    private TabItem createTab(Control control) {
        TabItem item = new TabItem(this.tabFolder, 0);
        item.setControl(control);
        return item;
    }

    private TabItem createTab(Control control, int index) {
        TabItem item = new TabItem(this.tabFolder, 0, index);
        item.setControl(control);
        return item;
    }

    protected Control getControl(int tabIndex) {
        if (tabIndex >= 0 && tabIndex < this.tabFolder.getItemCount()) {
            return this.getItem(tabIndex).getControl();
        }
        return null;
    }

    private TabItem getItem(int tabIndex) {
        if (this.tabFolder != null && !this.tabFolder.isDisposed() && tabIndex > -1 && tabIndex < this.tabFolder.getItemCount()) {
            return this.tabFolder.getItem(tabIndex);
        }
        return null;
    }

    protected int getTabCount() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            return this.tabFolder.getItemCount();
        }
        return 0;
    }

    protected void setTabImage(int tabIndex, Image image) {
        this.getItem(tabIndex).setImage(image);
    }

    protected void setTabText(int tabIndex, String text) {
        this.getItem(tabIndex).setText(text);
    }

    protected void setTabToolTipText(int tabIndex, String text) {
        this.getItem(tabIndex).setToolTipText(text);
    }

    protected void setActiveTab(int tabIndex) {
        if (tabIndex >= 0 && tabIndex < this.getTabCount()) {
            this.tabFolder.setSelection(tabIndex);
        }
    }

    @Override
    public void setFocus() {
        int index = this.getActiveTab();
        if (index != -1) {
            this.setFocus(index);
            if (this.meParentEditor != null) {
                this.meParentEditor.setIgnoreInternalFocus(true);
            }
        }
    }

    private void setFocus(int tabIndex) {
        if (tabIndex < 0 || tabIndex >= this.getTabCount()) {
            return;
        }
        Control control = this.getControl(tabIndex);
        if (control != null) {
            control.setFocus();
        }
    }

    protected int getActiveTab() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            return this.tabFolder.getSelectionIndex();
        }
        return -1;
    }

    public Map getTableViewerMap() {
        return this.viewers;
    }

    protected void pageChange(int newPageIndex) {
        UiBusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (ModelTableEditor.this.getCurrentModel() != null) {
                    ModelTableEditor.this.getCurrentModel().buildColumns();
                }
            }
        });
    }

    protected boolean isReadOnly() {
        IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
        return ModelUtil.isIResourceReadOnly((IResource)input.getFile());
    }

    private TableNotificationHandler getNotificationHandler() {
        if (this.notificationHandler == null) {
            this.notificationHandler = new TableNotificationHandler(this);
        }
        return this.notificationHandler;
    }

    protected Resource getEmfResource() {
        return this.emfResource;
    }

    void addTable(EClass eClass, ArrayList instanceList) {
        String className = eClass.getName();
        TreeSet<Object> orderedNames = new TreeSet<Object>();
        orderedNames.addAll(this.viewers.keySet());
        orderedNames.add(className);
        int index = 0;
        Iterator iter = orderedNames.iterator();
        while (iter.hasNext()) {
            if (className.equals(iter.next())) break;
            ++index;
        }
        index = this.addTab(eClass, instanceList, index);
        this.actionContributor.addContextMenu(this.getControl(index), className);
    }

    @Override
    public IMarker createMarker() {
        NavigationMarker nmMarker = new NavigationMarker();
        return nmMarker;
    }

    @Override
    public void gotoMarker(IMarker marker) {
        EObject targetEObject = ModelObjectUtilities.getMarkedEObject(marker);
        if (targetEObject != null) {
            this.selectionMgr.setSelection((ISelection)new StructuredSelection((Object)targetEObject));
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        try {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            this.modelResource = ModelUtil.getModelResource((IFile)fileInput.getFile(), (boolean)true);
            if (this.modelResource != null) {
                this.emfResource = this.modelResource.getEmfResource();
            }
        }
        catch (CoreException e) {
            throw new PartInitException(Util.getString(String.valueOf(PREFIX) + "resourceError", (Object)input.getName()), (Throwable)e);
        }
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    public Image getTitleImage() {
        return UiPlugin.getDefault().getImage("icons/full/cview16/table.gif");
    }

    public void dispose() {
        this.labelProvider.dispose();
        this.actionContributor.dispose();
    }

    @Override
    public void preDispose() {
    }

    @Override
    public boolean canDisplay(IEditorInput input) {
        return true;
    }

    @Override
    public boolean canOpenContext(Object input) {
        return input instanceof EObject;
    }

    @Override
    public void openContext(Object input) {
    }

    @Override
    public void openContext(Object input, boolean forceRefresh) {
    }

    @Override
    public void initializeEditorPage() {
    }

    @Override
    public Control getControl() {
        return this.getControl(this.getActiveTab());
    }

    @Override
    public ISelectionProvider getModelObjectSelectionProvider() {
        return this.selectionMgr;
    }

    @Override
    public ISelectionChangedListener getModelObjectSelectionChangedListener() {
        return this.selectionMgr;
    }

    @Override
    public AbstractModelEditorPageActionBarContributor getActionBarContributor() {
        if (this.actionContributor == null) {
            this.actionContributor = new ModelTableEditorActionContributor(this);
        }
        return this.actionContributor;
    }

    @Override
    public void setLabelProvider(ILabelProvider provider) {
    }

    @Override
    public INotifyChangedListener getNotifyChangedListener() {
        return this.getNotificationHandler();
    }

    @Override
    public ModelEditorPageOutline getOutlineContribution() {
        return null;
    }

    @Override
    public void setParent(ModelEditor meParentEditor) {
        this.meParentEditor = meParentEditor;
    }

    public boolean canInsertRows() {
        IStructuredSelection selection;
        boolean bResult = false;
        TableViewer viewer = this.getCurrentViewer();
        if (viewer != null && (selection = (IStructuredSelection)viewer.getSelection()) != null && !selection.isEmpty() && SelectionUtilities.isSingleSelection((ISelection)selection)) {
            ModelRowElement mre = (ModelRowElement)selection.getFirstElement();
            EObject eObj = mre.getModelObject();
            bResult = !ModelObjectUtilities.isReadOnly(eObj);
        }
        return bResult;
    }

    public void insertRows(int iRowCount) {
        TableViewer viewer = this.getCurrentViewer();
        if (viewer != null) {
            block26: {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (!selection.isEmpty()) {
                    ModelRowElement mre = (ModelRowElement)selection.getFirstElement();
                    EObject eObj = mre.getModelObject();
                    boolean started = ModelerCore.startTxn((boolean)true, (String)UNDO_INSERT_ROWS, (Object)this);
                    boolean succeeded = false;
                    try {
                        try {
                            EClass eClass = eObj.eClass();
                            Collection commands = ModelerCore.getModelEditor().getNewSiblingCommands(eObj);
                            if (commands != null && !commands.isEmpty()) {
                                Iterator itr = commands.iterator();
                                Command cmd = null;
                                while (itr.hasNext()) {
                                    EObject sibling;
                                    Command tempCmd = (Command)itr.next();
                                    Collection result = tempCmd.getResult();
                                    if (result == null || result.isEmpty() || !(sibling = (EObject)result.iterator().next()).eClass().equals(eClass)) continue;
                                    cmd = tempCmd;
                                    break;
                                }
                                if (cmd == null) {
                                    Util.log(4, Util.getString(String.valueOf(PREFIX) + "msg.noSiblingCommandFound", new Object[]{eClass}));
                                } else if (cmd.canExecute()) {
                                    String originalName = ModelerCore.getModelEditor().getName(eObj);
                                    if (iRowCount > 1) {
                                        Collection clonedChildren = ModelerCore.getModelEditor().cloneMultiple(eObj, iRowCount);
                                        if (clonedChildren != null) {
                                            EObject[] newChildArray = new EObject[clonedChildren.size()];
                                            clonedChildren.toArray(newChildArray);
                                            int i = newChildArray.length - 1;
                                            while (i >= 0) {
                                                this.renameToUniqueName(newChildArray[i], originalName);
                                                --i;
                                            }
                                        }
                                    } else {
                                        EObject newChild = ModelerCore.getModelEditor().clone(eObj);
                                        this.renameToUniqueName(newChild, originalName);
                                    }
                                    succeeded = true;
                                } else {
                                    Util.log(4, Util.getString(String.valueOf(PREFIX) + "msg.newSiblingCommandProblem", new Object[]{eClass}));
                                }
                            }
                        }
                        catch (ModelerCoreException theException) {
                            Util.log(4, (Throwable)theException, Util.getString(String.valueOf(PREFIX) + "NewSiblingMenu.problem", new Object[]{eObj}));
                            if (started) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        if (started) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        throw throwable;
                    }
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
            viewer.refresh();
        }
    }

    public boolean canPaste() {
        TableColumnSelectionHelper helper;
        int selectedColumn;
        IStructuredSelection selection;
        TableViewer viewer;
        boolean result = false;
        if (!SystemClipboardUtilities.isEmpty() && (viewer = this.getCurrentViewer()) != null && !(selection = (IStructuredSelection)viewer.getSelection()).isEmpty() && SelectionUtilities.isSingleSelection((ISelection)selection) && (selectedColumn = (helper = this.getCurrentSelectionHelper()).getSelectedColumn()) != -1 && selectedColumn < viewer.getCellEditors().length) {
            result = viewer.getCellEditors()[selectedColumn] != null;
        }
        return result;
    }

    @Override
    public ClipboardPasteStatusRecord constructPasteStatusRecord(String theProposedValue, int theRow, int theColumn) {
        ClipboardPasteStatusRecord result = null;
        Integer statusType = ClipboardPasteStatusRecord.VALID;
        String columnName = null;
        String errorMsg = null;
        if (!this.willPasteDataRowFit(theRow)) {
            statusType = ClipboardPasteStatusRecord.ROW_TRUNCATED;
            errorMsg = this.getErrorMsg(theProposedValue, theRow, theColumn);
        } else if (!this.willPasteDataColumnFit(theColumn)) {
            statusType = ClipboardPasteStatusRecord.COLUMN_TRUNCATED;
            errorMsg = this.getErrorMsg(theProposedValue, theRow, theColumn);
            columnName = ClipboardPasteProblemDialog.TRUNCATED_COLUMN_TITLE;
        } else if (this.isProtected(theColumn)) {
            statusType = ClipboardPasteStatusRecord.PROTECTED_COLUMN;
            errorMsg = this.getErrorMsg(theProposedValue, theRow, theColumn);
        } else {
            errorMsg = this.getErrorMsg(theProposedValue, theRow, theColumn);
            if (errorMsg != null) {
                statusType = errorMsg.equals(ClipboardPasteStatusRecord.REFERENCE_COLUMN_MSG) ? ClipboardPasteStatusRecord.PROTECTED_COLUMN : ClipboardPasteStatusRecord.ERROR;
            }
        }
        if (columnName == null) {
            columnName = this.willPasteDataColumnFit(theColumn) ? this.getCurrentTable().getColumn(theColumn).getText() : ClipboardPasteProblemDialog.TRUNCATED_COLUMN_TITLE;
        }
        result = errorMsg == null ? new ClipboardPasteStatusRecord(columnName, theProposedValue) : new ClipboardPasteStatusRecord(statusType, columnName, theProposedValue, errorMsg);
        return result;
    }

    private List constructClipboardPasteStatusRecords(List thePasteData, int theSelectedRow, int theSelectedColumn) {
        ArrayList result = new ArrayList(thePasteData.size());
        int numRows = thePasteData.size();
        int i = 0;
        while (i < numRows) {
            List row = (List)thePasteData.get(i);
            ArrayList<ClipboardPasteStatusRecord> resultRow = new ArrayList<ClipboardPasteStatusRecord>(row.size());
            int numColumns = row.size();
            int j = 0;
            while (j < numColumns) {
                String data = (String)row.get(j);
                resultRow.add(this.constructPasteStatusRecord(data, i + theSelectedRow, j + theSelectedColumn));
                ++j;
            }
            result.add(resultRow);
            ++i;
        }
        return result;
    }

    ModelObjectTableModel getCurrentModel() {
        TableViewer viewer = this.getCurrentViewer();
        return viewer == null ? null : (ModelObjectTableModel)this.modelMap.get(viewer);
    }

    private TableColumnSelectionHelper getCurrentSelectionHelper() {
        TableViewer viewer = this.getCurrentViewer();
        return viewer == null ? null : (TableColumnSelectionHelper)this.selectionHelperMap.get(viewer);
    }

    private Table getCurrentTable() {
        TableViewer viewer = this.getCurrentViewer();
        return viewer == null ? null : viewer.getTable();
    }

    public TableViewer getCurrentViewer() {
        if (this.tabFolder != null && !this.tabFolder.isDisposed()) {
            TabItem[] item = this.tabFolder.getSelection();
            if (item == null || item.length == 0 || item[0] == null) {
                return null;
            }
            return item[0] == null ? null : (TableViewer)this.viewers.get(item[0].getText());
        }
        return null;
    }

    private String getErrorMsg(String theProposedValue, int theRow, int theColumn) {
        String result = null;
        if (!this.willPasteDataRowFit(theRow)) {
            result = ClipboardPasteStatusRecord.ROW_TRUNCATED_MSG;
        } else if (!this.willPasteDataColumnFit(theColumn)) {
            result = ClipboardPasteStatusRecord.COLUMN_TRUNCATED_MSG;
        } else if (this.isProtected(theColumn)) {
            result = ClipboardPasteStatusRecord.PROTECTED_COLUMN_MSG;
        } else {
            ModelRowElement row;
            Object propID;
            CellEditor editor = this.getCurrentViewer().getCellEditors()[theColumn];
            if (editor != null) {
                ICellEditorValidator validator = editor.getValidator();
                if (validator != null) {
                    result = validator.isValid((Object)theProposedValue);
                } else if (editor instanceof ComboBoxCellEditor) {
                    int iMatch = -1;
                    ComboBoxCellEditor cbceEditor = (ComboBoxCellEditor)editor;
                    String sNewVal = theProposedValue.trim();
                    String[] sItems = cbceEditor.getItems();
                    int i = 0;
                    while (i < sItems.length) {
                        if (sNewVal.equals(sItems[i])) {
                            iMatch = i;
                        }
                        ++i;
                    }
                    if (iMatch == -1) {
                        ModelRowElement row2 = (ModelRowElement)this.getCurrentViewer().getElementAt(theRow);
                        String propertyID = (String)row2.getPropertyIdForColumn(theColumn);
                        result = UiConstants.Util.getString("ModelRowElement.invalidValueError", new Object[]{sNewVal, propertyID});
                    }
                }
            }
            if (result == null && (propID = (row = (ModelRowElement)this.getCurrentViewer().getElementAt(theRow)).getPropertyIdForColumn(theColumn)) instanceof String) {
                result = row.getReferenceColumnMessage((String)propID, theProposedValue);
            }
            if (result == null) {
                row = (ModelRowElement)this.getCurrentViewer().getElementAt(theRow);
                propID = row.getPropertyIdForColumn(theColumn);
                if (propID instanceof String) {
                    result = row.getInvalidValueMessage((String)propID, (Object)theProposedValue);
                } else if (propID instanceof ExtensionPropertyDescriptor) {
                    result = row.getInvalidValueMessage((ExtensionPropertyDescriptor)propID, (Object)theProposedValue);
                }
            }
        }
        return result;
    }

    @Override
    public int[] getSelectedRowAndColumn() {
        TableViewer viewer = this.getCurrentViewer();
        TableColumnSelectionHelper helper = (TableColumnSelectionHelper)this.selectionHelperMap.get(viewer);
        return helper.getSelectedRowAndColumn();
    }

    private boolean isPasteDataValid(List thePasteData) {
        boolean result = true;
        boolean rawData = true;
        if (thePasteData != null && !thePasteData.isEmpty()) {
            int[] rowCol = this.getSelectedRowAndColumn();
            int selectedRow = rowCol[0];
            int selectedColumn = rowCol[1];
            int numRows = thePasteData.size();
            int i = 0;
            while (i < numRows) {
                List row = (List)thePasteData.get(i);
                int numColumns = row.size();
                int j = 0;
                while (j < numColumns) {
                    Object tempColumn;
                    if (j == 0 && (tempColumn = row.get(j)) instanceof ClipboardPasteStatusRecord) {
                        rawData = false;
                    }
                    String columnData = null;
                    columnData = rawData ? (String)row.get(j) : ((ClipboardPasteStatusRecord)row.get(j)).getPasteData();
                    if (this.getErrorMsg(columnData, i + selectedRow, j + selectedColumn) != null) {
                        boolean bl = rawData ? false : (result = !((ClipboardPasteStatusRecord)row.get(j)).isError());
                        if (!result) break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    private boolean isProtected(int theColumn) {
        boolean isProtected = false;
        ModelObjectTableModel tableModel = this.getCurrentModel();
        Object propID = tableModel.getPropertyIdAtIndex(theColumn);
        if (propID instanceof String) {
            if (this.isReadOnly()) {
                isProtected = true;
            } else if (propID.equals(UiConstants.LOCATION_KEY)) {
                return true;
            }
        } else {
            isProtected = this.isReadOnly();
        }
        return isProtected;
    }

    public void pasteClipboardContents() {
        if (this.canPaste()) {
            Table table = this.getCurrentTable();
            ModelObjectTableModel model = this.getCurrentModel();
            int[] rowCol = this.getSelectedRowAndColumn();
            int selectedRow = rowCol[0];
            int selectedColumn = rowCol[1];
            String clipboardContents = SystemClipboardUtilities.getContents();
            List pasteData = SystemClipboardUtilities.convertTableData((String)clipboardContents);
            if (this.willPasteDataFit(pasteData) && this.isPasteDataValid(pasteData)) {
                int numRows = table.getItemCount();
                int numCols = table.getColumnCount();
                int numPasteDataRows = pasteData.size();
                int numPasteDataColumns = ((List)pasteData.get(0)).size();
                this.getCurrentViewer().cancelEditing();
                boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)Util.getString(String.valueOf(PREFIX) + "tablePasteTransactionDescription.msg", new Object[0]), (Object)this);
                boolean succeeded = false;
                try {
                    int i = 0;
                    while (i < numPasteDataRows) {
                        int modelRow = selectedRow + i;
                        if (modelRow != numRows) {
                            List pasteRow = (List)pasteData.get(i);
                            TableItem ti = this.getCurrentViewer().getTable().getItem(modelRow);
                            ModelRowElement mreRow = (ModelRowElement)ti.getData();
                            int j = 0;
                            while (j < numPasteDataColumns) {
                                int modelColumn = selectedColumn + j;
                                if (modelColumn != numCols) {
                                    Object propID = model.getPropertyIdAtIndex(modelColumn);
                                    if (propID instanceof String) {
                                        mreRow.setValue((String)propID, pasteRow.get(j));
                                    } else if (propID instanceof ExtensionPropertyDescriptor) {
                                        mreRow.setValue((ExtensionPropertyDescriptor)propID, pasteRow.get(j));
                                    }
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    } else {
                        Util.log(4, Util.getString(String.valueOf(PREFIX) + "tablePasteStartTransactionProblem.msg", new Object[0]));
                    }
                }
            }
            List statusRecords = this.constructClipboardPasteStatusRecords(pasteData, selectedRow, selectedColumn);
            Shell shell = UiUtil.getWorkbenchWindowOnlyIfUiThread().getShell();
            ClipboardPasteProblemDialog dialog = new ClipboardPasteProblemDialog(shell, statusRecords, this);
            int returnStatus = dialog.open();
            if (returnStatus == 0 && (statusRecords = dialog.getStatusRecords()) != null && !statusRecords.isEmpty() && this.isPasteDataValid(statusRecords)) {
                this.getCurrentViewer().cancelEditing();
                boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)Util.getString(String.valueOf(PREFIX) + "tablePasteTransactionDescription.msg", new Object[0]), (Object)this);
                boolean succeeded = false;
                try {
                    int numRows = statusRecords.size();
                    int i = 0;
                    while (i < numRows) {
                        List pasteRow = (List)statusRecords.get(i);
                        int modelRow = selectedRow + i;
                        int numColumns = pasteRow.size();
                        int j = 0;
                        while (j < numColumns) {
                            int modelColumn = selectedColumn + j;
                            ClipboardPasteStatusRecord statusRecord = (ClipboardPasteStatusRecord)pasteRow.get(j);
                            if (!(statusRecord.isColumnTruncated() || statusRecord.isRowTruncated() || statusRecord.isProtectedColumn())) {
                                model.setValueAt(statusRecord.getPasteData(), modelRow, modelColumn);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    } else {
                        Util.log(4, Util.getString(String.valueOf(PREFIX) + "tablePasteStartTransactionProblem.msg", new Object[0]));
                    }
                }
            }
        }
    }

    private boolean willPasteDataColumnFit(int theColumn) {
        boolean result = false;
        if (theColumn >= 0) {
            Table table = this.getCurrentTable();
            result = theColumn < table.getColumnCount();
        }
        return result;
    }

    private boolean willPasteDataFit(List thePasteData) {
        boolean result = false;
        if (thePasteData != null && !thePasteData.isEmpty()) {
            TableViewer viewer = this.getCurrentViewer();
            int[] rowCol = this.getSelectedRowAndColumn();
            int selectedRow = rowCol[0];
            int selectedColumn = rowCol[1];
            if (selectedColumn != -1 && selectedRow != -1) {
                Table table = viewer.getTable();
                int tableColumnCount = table.getColumnCount();
                int pasteDataRows = thePasteData.size();
                int pasteDataColumns = ((List)thePasteData.get(0)).size();
                if (selectedColumn + pasteDataColumns - 1 <= tableColumnCount && selectedRow + pasteDataRows - 1 < table.getItemCount()) {
                    result = true;
                }
            }
        }
        return result;
    }

    private boolean willPasteDataRowFit(int theRow) {
        boolean result = false;
        if (theRow >= 0) {
            Table table = this.getCurrentTable();
            result = theRow < table.getItemCount();
        }
        return result;
    }

    public void copySelectedToSystemClipboard() {
        Table table = this.getCurrentTable();
        int[] iSelectedRows = table.getSelectionIndices();
        int numCols = table.getColumnCount();
        String sVal = "";
        String sFullString = "";
        int iRow = 0;
        while (iRow < iSelectedRows.length) {
            String sRowString = "";
            int iThisRow = iSelectedRows[iRow];
            TableItem ti = this.getCurrentViewer().getTable().getItem(iThisRow);
            ModelRowElement mreRow = (ModelRowElement)ti.getData();
            int iCol = 0;
            while (iCol < numCols) {
                if (iCol > 0) {
                    sRowString = String.valueOf(sRowString) + "\t";
                }
                sVal = (String)mreRow.getValue(iCol);
                sRowString = String.valueOf(sRowString) + sVal;
                ++iCol;
            }
            sFullString = String.valueOf(sFullString) + sRowString + "\n";
            ++iRow;
        }
        SystemClipboardUtilities.setContents((String)sFullString);
    }

    public String getTitleToolTip() {
        return TOOLTIP;
    }

    public String getTitle() {
        if (this.title == null) {
            return super.getTitle();
        }
        return this.title;
    }

    @Override
    public void setTitleText(String newTitle) {
        this.title = newTitle;
    }

    public Object getAdapter(Class type) {
        if (type == IPrintable.class && this.getTitleToolTip() != null) {
            return new Printable((Object)this.getControl(this.tabFolder.getSelectionIndex()));
        }
        return super.getAdapter(type);
    }

    @Override
    public void updateReadOnlyState(boolean isReadOnly) {
        if (this.lastReadOnly != isReadOnly) {
            this.lastReadOnly = isReadOnly;
            for (Object key : this.modelMap.keySet()) {
                Object val = this.modelMap.get(key);
                if (!(key instanceof TableViewer) || !(val instanceof ModelObjectTableModel)) continue;
                TableViewer tv = (TableViewer)key;
                ModelObjectTableModel model = (ModelObjectTableModel)val;
                model.rebuildColumnEditors(tv.getTable());
            }
        }
    }

    public void processEvent(EventObject obj) {
        ModelResourceEvent event = (ModelResourceEvent)obj;
        if (event.getType() == 6) {
            this.refresh();
        }
    }

    private void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ModelTableEditor.this.getControl() != null && !ModelTableEditor.this.getControl().isDisposed()) {
                    TabItem[] tabs = ModelTableEditor.this.tabFolder.getItems();
                    int i = tabs.length - 1;
                    while (i >= 0) {
                        tabs[i].dispose();
                        --i;
                    }
                    ModelTableEditor.this.modelMap.clear();
                    ModelTableEditor.this.viewers.clear();
                    ModelTableEditor.this.selectionHelperMap.clear();
                    ModelTableEditor.this.selectionMgr.removeTableSelectionListeners();
                    ModelTableEditor.this.createTabs();
                    int tabID = ModelTableEditor.this.getActiveTab();
                    if (tabID == 1 || tabID == 0) {
                        ModelTableEditor.this.setActiveTab(0);
                        ModelTableEditor.this.pageChange(0);
                    }
                }
            }
        });
    }

    @Override
    public void openComplete() {
    }

    @Override
    public IInlineRenameable getInlineRenameable(EObject theObj) {
        return this;
    }

    @Override
    public void renameInline(final EObject targetEObject, IInlineRenameable renameable) {
        if (renameable == this && targetEObject != null) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ModelTableEditor.this.selectionMgr.setSelection((ISelection)new StructuredSelection((Object)targetEObject));
                    DoubleClickTableViewer dctv = (DoubleClickTableViewer)ModelTableEditor.this.getCurrentViewer();
                    TableColumn[] columns = dctv.getTable().getColumns();
                    int i = 0;
                    while (i < columns.length) {
                        if (columns[i].getText().equalsIgnoreCase("name")) {
                            dctv.renameInline(i);
                            break;
                        }
                        ++i;
                    }
                }
            });
        }
    }

    protected boolean renameToUniqueName(EObject eObject, String newName) {
        CoreArgCheck.isNotNull((Object)eObject);
        EStructuralFeature nameFeature = ModelerCore.getModelEditor().getNameFeature(eObject);
        if (nameFeature != null) {
            this.generateUniqueInternalName(eObject.eContainer() == null ? eObject.eResource().getContents() : eObject.eContainer().eContents(), eObject, nameFeature, newName);
            return true;
        }
        return false;
    }

    private void generateUniqueInternalName(EList siblings, EObject eObject, EStructuralFeature nameFeature, String name) {
        String newName = name;
        if (siblings != null) {
            HashSet<Object> siblingNames = new HashSet<Object>();
            for (EObject child : siblings) {
                if (!eObject.getClass().equals(child.getClass())) continue;
                siblingNames.add(child.eGet(nameFeature));
            }
            boolean foundUniqueName = false;
            int index = 1;
            while (!foundUniqueName) {
                if (siblingNames.contains(newName)) {
                    newName = String.valueOf(name) + String.valueOf(index++);
                    continue;
                }
                foundUniqueName = true;
            }
        }
        eObject.eSet(nameFeature, (Object)newName);
    }

    @Override
    public boolean isSelectedFirst(IEditorInput input) {
        return false;
    }

    class EClassNameComparator
    implements Comparator {
        EClassNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            EClass c1 = (EClass)o1;
            EClass c2 = (EClass)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }

    class ModelObjectSelectionManager
    extends SelectionProvider
    implements ISelectionChangedListener {
        ModelObjectSelectionManager() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IEditorPart activeEditor;
            Object obj;
            ModelTableEditor.this.getModelObjectSelectionProvider().setSelection(event.getSelection());
            if (SelectionUtilities.isSingleSelection((ISelection)event.getSelection()) && (obj = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof EObject && (activeEditor = ModelTableEditor.this.meParentEditor.getActiveEditor()) != null && activeEditor == ModelTableEditor.this) {
                ModelTableEditor.this.meParentEditor.setIgnoreInternalFocus(true);
            }
        }

        public List getListenerList() {
            return super.getListenerList();
        }

        protected void removeTableSelectionListeners() {
            List listeners = this.getListenerList();
            ArrayList removeList = new ArrayList(listeners.size());
            Object nextListener2 = null;
            for (Object nextListener2 : listeners) {
                if (!(nextListener2 instanceof ModelObjectTableSelectionManager)) continue;
                removeList.add(nextListener2);
            }
            for (Object nextListener2 : removeList) {
                super.removeSelectionChangedListener((ISelectionChangedListener)((ModelObjectTableSelectionManager)((Object)nextListener2)));
            }
        }
    }

    class TableCellModifier
    implements ICellModifier {
        Object lastGetValue = null;

        TableCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            if (ModelTableEditor.this.isReadOnly()) {
                return false;
            }
            return !property.equals(UiConstants.LOCATION_KEY);
        }

        public Object getValue(Object element, String property) {
            ModelRowElement row = (ModelRowElement)element;
            this.lastGetValue = row.getValueObject(property);
            return this.lastGetValue;
        }

        public void modify(Object element, String property, Object theValue) {
            boolean modifyValue = false;
            Object value = theValue;
            if (property.equalsIgnoreCase("name") && theValue != null && theValue instanceof String && ((String)theValue).length() == 0) {
                value = this.lastGetValue;
            }
            if (this.lastGetValue == null && value != null) {
                modifyValue = true;
            } else if (value == null && this.lastGetValue != null) {
                modifyValue = true;
            } else if (value != null && this.lastGetValue != null && !this.lastGetValue.equals(value)) {
                modifyValue = true;
            }
            if (modifyValue) {
                boolean startedTxn = ModelerCore.startTxn((String)(String.valueOf(UNDO_PREFIX) + ModelObjectTableModel.getPropertyLabel(property)), (Object)this);
                boolean succeeded = false;
                try {
                    ModelRowElement row = (ModelRowElement)((TableItem)element).getData();
                    row.setValue(property, value);
                    succeeded = true;
                }
                finally {
                    if (startedTxn) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }
}

