/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class InsertRowsDialog
extends TitleAreaDialog
implements UiConstants,
PluginConstants {
    private Spinner rowSpinner = null;
    private int currentRowValue = 1;
    private CLabel lblMessage;
    private static final String INSERT_ROWS_MESSAGE = UiConstants.Util.getString("InsertRowsDialog.message", new Object[0]);
    private static final String INSERT_ROWS_MIN = UiConstants.Util.getString("InsertRowsDialog.min", new Object[0]);
    private static final String INSERT_ROWS_MAX = UiConstants.Util.getString("InsertRowsDialog.max", new Object[0]);
    private static final String INSERT_ROWS_DYNAMIC_MESSAGE_SINGULAR = UiConstants.Util.getString("InsertRowsDialog.dynamicMessageSingular", new Object[0]);
    private static final String INSERT_ROWS_DYNAMIC_MESSAGE_PLURAL = UiConstants.Util.getString("InsertRowsDialog.dynamicMessagePlural", new Object[0]);
    private static final String DIALOG_TITLE = UiConstants.Util.getString("InsertRowsDialog.title", new Object[0]);
    private static final String INSERT_ROWS_TITLE = UiConstants.Util.getString("InsertRowsDialog.componentTitle", (Object)INSERT_ROWS_MAX);
    private static final String OUT_OF_RANGE_MESSAGE = UiConstants.Util.getString("InsertRowsDialog.outOfRange.message", new Object[]{INSERT_ROWS_MIN, INSERT_ROWS_MAX});
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent theEvent) {
            InsertRowsDialog.this.updateDynamicMessage();
        }
    };

    public InsertRowsDialog(Shell parentShell, Image img) {
        super(parentShell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnlOuter = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(pnlOuter, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.setTitle(INSERT_ROWS_TITLE);
        this.lblMessage = WidgetFactory.createLabel((Composite)composite);
        this.lblMessage.setText(INSERT_ROWS_MESSAGE);
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 2;
        this.lblMessage.setLayoutData((Object)gridData1);
        this.rowSpinner = new Spinner(composite, 2048);
        this.rowSpinner.setIncrement(1);
        this.rowSpinner.setMaximum(Integer.parseInt(INSERT_ROWS_MAX));
        this.rowSpinner.setMinimum(Integer.parseInt(INSERT_ROWS_MIN));
        this.rowSpinner.addModifyListener(this.modifyListener);
        this.rowSpinner.setEnabled(true);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 2;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.minimumWidth = 100;
        this.rowSpinner.setLayoutData((Object)gridData2);
        this.updateDynamicMessage();
        return composite;
    }

    public void updateDynamicMessage() {
        int iSpinnerValue;
        if (this.rowSpinner.getSelection() < 0) {
            this.setMessage(OUT_OF_RANGE_MESSAGE, 3);
            return;
        }
        this.currentRowValue = iSpinnerValue = this.rowSpinner.getSelection() > 0 ? this.rowSpinner.getSelection() : 1;
        if (iSpinnerValue == 1) {
            this.setMessage(String.valueOf(String.valueOf(this.currentRowValue)) + " " + INSERT_ROWS_DYNAMIC_MESSAGE_SINGULAR, 0);
        } else {
            this.setMessage(String.valueOf(String.valueOf(this.currentRowValue)) + " " + INSERT_ROWS_DYNAMIC_MESSAGE_PLURAL, 0);
        }
    }

    public int getCount() {
        return this.currentRowValue;
    }
}

