/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.table;

import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;

public final class ClipboardPasteStatusRecord
implements UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ClipboardPasteStatusRecord.class);
    public static final Integer VALID = new Integer(0);
    public static final Integer ERROR = new Integer(1);
    public static final Integer WARNING = new Integer(2);
    public static final Integer INFO = new Integer(3);
    public static final Integer ROW_TRUNCATED = new Integer(4);
    public static final Integer COLUMN_TRUNCATED = new Integer(5);
    public static final Integer PROTECTED_COLUMN = new Integer(6);
    public static final String COLUMN_TRUNCATED_MSG = Util.getString(String.valueOf(PREFIX) + "truncatedColumn.msg", new Object[0]);
    public static final String ERROR_MSG = Util.getString(String.valueOf(PREFIX) + "genericError.msg", new Object[0]);
    public static final String INFO_MSG = Util.getString(String.valueOf(PREFIX) + "genericInfo.msg", new Object[0]);
    public static final String PROTECTED_COLUMN_MSG = Util.getString(String.valueOf(PREFIX) + "protectedColumn.msg", new Object[0]);
    public static final String REFERENCE_COLUMN_MSG = Util.getString(String.valueOf(PREFIX) + "referenceColumnIsProtected.msg", new Object[0]);
    public static final String ROW_TRUNCATED_MSG = Util.getString(String.valueOf(PREFIX) + "truncatedRow.msg", new Object[0]);
    public static final String WARNING_MSG = Util.getString(String.valueOf(PREFIX) + "genericWarning.msg", new Object[0]);
    private Integer type;
    private String columnName;
    private String data;
    private String description;

    public ClipboardPasteStatusRecord(String theColumnName, String theData) {
        this(VALID, theColumnName, theData, null);
    }

    public ClipboardPasteStatusRecord(Integer theType, String theColumnName, String theData) {
        this(theType, theColumnName, theData, null);
        if (theType == ERROR) {
            this.description = ERROR_MSG;
        } else if (theType == ROW_TRUNCATED) {
            this.description = ROW_TRUNCATED_MSG;
        } else if (theType == COLUMN_TRUNCATED) {
            this.description = COLUMN_TRUNCATED_MSG;
        } else if (theType == WARNING) {
            this.description = WARNING_MSG;
        } else if (theType == INFO) {
            this.description = INFO_MSG;
        }
    }

    public ClipboardPasteStatusRecord(Integer theType, String theColumnName, String theData, String theDescription) {
        this.type = theType;
        this.columnName = theColumnName;
        this.data = theData;
        this.description = theDescription;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPasteData() {
        return this.data;
    }

    public Integer getType() {
        return this.type;
    }

    public boolean isColumnTruncated() {
        return this.type == COLUMN_TRUNCATED;
    }

    public boolean isError() {
        return this.type == ERROR;
    }

    public boolean isInfo() {
        return this.type == INFO;
    }

    public boolean isProtectedColumn() {
        return this.type == PROTECTED_COLUMN;
    }

    public boolean isRowTruncated() {
        return this.type == ROW_TRUNCATED;
    }

    public boolean isValid() {
        return this.type == VALID;
    }

    public boolean isWarning() {
        return this.type == WARNING;
    }

    public String paramString() {
        return new StringBuffer().append("isValid=").append(this.isValid()).append(", isColumnTruncated=").append(this.isColumnTruncated()).append(", isError=").append(this.isError()).append(", isInfo=").append(this.isInfo()).append(", isProtectedColumn=").append(this.isInfo()).append(", isRowTruncated=").append(this.isProtectedColumn()).append(", isValid=").append(this.isValid()).append(", isWarning=").append(this.isInfo()).append(", columnName=").append(this.getColumnName()).append(", pasteData=").append(this.getPasteData()).append(", description=").append(this.getDescription()).toString();
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public void setPasteData(String theData) {
        this.data = theData;
    }

    public void setType(Integer theType) {
        this.type = theType;
    }
}

