/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.search.ModelWorkspaceSearch;
import org.teiid.designer.core.search.runtime.ResourceObjectRecord;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.search.FindObjectLabelProvider;
import org.teiid.designer.ui.search.TwoArrayQuickSorter;

public class ModelObjectSelectionDialog
extends AbstractElementListSelectionDialog
implements StringConstants {
    private static final String TITLE = UiConstants.Util.getString("ModelObjectSelectionDialog.title", new Object[0]);
    private static final String TEXT_ENTRY_LABEL_TEXT = UiConstants.Util.getString("ModelObjectSelectionDialog.textEntryLabel.text", new Object[0]);
    private static final String UPPER_TABLE_LABEL_TEXT = UiConstants.Util.getString("ModelObjectSelectionDialog.upperTableLabel.text", new Object[0]);
    private static final String LOWER_TABLE_LABEL_TEXT = UiConstants.Util.getString("ModelObjectSelectionDialog.lowerTableLabel.text", new Object[0]);
    private static final String DOT = ".";
    private HashMap hmUniqueNames;
    private String sSelectedObject;
    private String sSelectedPath;
    private String fUpperListLabel;
    private String fLowerListLabel;
    ILabelProvider fQualifierRenderer;
    private Object[] fElements = new Object[0];
    private Table fLowerList;
    private Object[] fQualifierElements;
    private boolean bUserCancelledDuringLoad = false;

    public ModelObjectSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new FindObjectLabelProvider(0));
        this.fQualifierRenderer = new FindObjectLabelProvider(1);
        this.setSize(200, 300);
        this.setAllowDuplicates(false);
        this.setTitle(TITLE);
        this.setMessage(TEXT_ENTRY_LABEL_TEXT);
        this.setUpperListLabel(UPPER_TABLE_LABEL_TEXT);
        this.setLowerListLabel(LOWER_TABLE_LABEL_TEXT);
        this.doLoadObjects(parent);
    }

    private void doLoadObjects(Shell shell) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) {
                ModelObjectSelectionDialog.this.loadObjects(theMonitor);
                theMonitor.done();
            }
        };
        ProgressMonitorDialog dlg = null;
        try {
            dlg = new ProgressMonitorDialog(shell);
            dlg.run(true, true, (IRunnableWithProgress)op);
            if (dlg.getProgressMonitor().isCanceled()) {
                this.bUserCancelledDuringLoad = true;
            } else {
                dlg.getProgressMonitor().worked(1);
            }
        }
        catch (InterruptedException interruptedException) {
            this.bUserCancelledDuringLoad = true;
        }
        catch (InvocationTargetException e) {
            UiConstants.Util.log(e.getTargetException());
        }
    }

    public boolean userCancelledDuringLoad() {
        return this.bUserCancelledDuringLoad;
    }

    void loadObjects(IProgressMonitor monitor) {
        ModelWorkspaceSearch mwssSearch = new ModelWorkspaceSearch(monitor);
        Collection colRecordObjects = mwssSearch.getAllModelObjectRecords();
        if (colRecordObjects == null) {
            return;
        }
        this.hmUniqueNames = new HashMap();
        for (ResourceObjectRecord ror : colRecordObjects) {
            if (ror.getName().trim().equals("")) continue;
            if (this.hmUniqueNames.containsKey(ror.getName())) {
                ArrayList aryl = (ArrayList)this.hmUniqueNames.get(ror.getName());
                aryl.add(ror);
                continue;
            }
            ArrayList<ResourceObjectRecord> aryl2 = new ArrayList<ResourceObjectRecord>();
            aryl2.add(ror);
            this.hmUniqueNames.put(ror.getName(), aryl2);
        }
        this.setElements(this.getElementsFromSource());
    }

    private Object[] getElementsFromSource() {
        ArrayList arylElements = new ArrayList(this.hmUniqueNames.values().size());
        for (ArrayList arylTemp : this.hmUniqueNames.values()) {
            arylElements.add(arylTemp.get(0));
        }
        return arylElements.toArray();
    }

    public EObject getSelectedEObject() {
        String sName = this.sSelectedObject;
        ArrayList aryl = (ArrayList)this.hmUniqueNames.get(sName);
        Iterator it = aryl.iterator();
        ResourceObjectRecord rorSelected = null;
        while (it.hasNext()) {
            ResourceObjectRecord rorTemp = (ResourceObjectRecord)it.next();
            if (!this.sSelectedPath.equals(this.getFullPathForRecord(rorTemp))) continue;
            rorSelected = rorTemp;
            break;
        }
        return this.getEObjectForRecord(rorSelected);
    }

    public EObject getEObjectForRecord(ResourceObjectRecord ror) {
        EObject eObj = null;
        if (ror != null) {
            try {
                URI uri = URI.createURI((String)ror.getObjectURI());
                if (uri.fragment() != null) {
                    eObj = ModelerCore.getModelContainer().getEObject(uri, true);
                }
            }
            catch (CoreException ce) {
                ModelerCore.Util.log(4, (Throwable)ce, ce.getMessage());
            }
        }
        return eObj;
    }

    public Object[] getFoldedElements(int index) {
        String sName = null;
        Object[] oArySelection = this.fFilteredList.getSelection();
        if (oArySelection.length > 0) {
            sName = ((ResourceObjectRecord)oArySelection[0]).getName();
        }
        ArrayList aryl = (ArrayList)this.hmUniqueNames.get(sName);
        Object[] oAry = new Object[aryl.size()];
        Iterator it = aryl.iterator();
        int ix = 0;
        while (it.hasNext()) {
            ResourceObjectRecord rorTemp = (ResourceObjectRecord)it.next();
            oAry[ix++] = rorTemp;
        }
        return oAry;
    }

    public void setUpperListLabel(String label) {
        this.fUpperListLabel = label;
    }

    public void setLowerListLabel(String label) {
        this.fLowerListLabel = label;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createLabel(contents, this.fUpperListLabel);
        FilteredList listCtrl = this.createFilteredList(contents);
        GridData gdlc = (GridData)listCtrl.getLayoutData();
        gdlc.heightHint = this.convertHeightInCharsToPixels(18);
        gdlc.widthHint = 300;
        this.createLabel(contents, this.fLowerListLabel);
        this.createLowerList(contents);
        this.setListElements(this.fElements);
        List initialSelections = this.getInitialElementSelections();
        if (!initialSelections.isEmpty()) {
            Object element = initialSelections.get(0);
            this.setSelection(new Object[]{element});
            this.setLowerSelectedElement(element);
        }
        return contents;
    }

    protected Label createLabel(Composite parent, String name) {
        if (name == null) {
            return null;
        }
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setFont(parent.getFont());
        return label;
    }

    protected Table createLowerList(Composite parent) {
        Table list = new Table(parent, 2816);
        list.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                ModelObjectSelectionDialog.this.handleLowerSelectionChanged();
            }
        });
        list.addListener(8, new Listener(){

            public void handleEvent(Event evt) {
                ModelObjectSelectionDialog.this.handleDefaultSelected();
            }
        });
        list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ModelObjectSelectionDialog.this.fQualifierRenderer.dispose();
            }
        });
        GridData data = new GridData();
        data.heightHint = this.convertHeightInCharsToPixels(8);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        list.setLayoutData((Object)data);
        list.setFont(parent.getFont());
        this.fLowerList = list;
        return list;
    }

    protected void computeResult() {
        Object[] results = new Object[]{this.getLowerSelectedElement()};
        this.setResult(Arrays.asList(results));
    }

    protected void handleDefaultSelected() {
        this.handleUpperSelectionChanged();
        if (this.validateCurrentSelection() && this.getLowerSelectedElement() != null) {
            this.buttonPressed(0);
        }
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        this.handleUpperSelectionChanged();
        this.handleLowerSelectionChanged();
    }

    void handleUpperSelectionChanged() {
        Object[] oArySelection;
        int index = this.getSelectionIndex();
        this.fLowerList.removeAll();
        if (index < 0) {
            return;
        }
        this.fQualifierElements = this.getFoldedElements(index);
        if (this.fQualifierElements == null) {
            this.updateLowerListWidget(new Object[0]);
        } else {
            this.updateLowerListWidget(this.fQualifierElements);
        }
        this.updateOkState();
        if (this.getSelectedElements()[0] != null && (oArySelection = this.fFilteredList.getSelection()).length > 0) {
            this.sSelectedObject = ((ResourceObjectRecord)oArySelection[0]).getName();
        }
    }

    void handleLowerSelectionChanged() {
        this.updateOkState();
        if (this.getLowerSelectedElement() != null) {
            ResourceObjectRecord rorSelected = (ResourceObjectRecord)this.getLowerSelectedElement();
            this.sSelectedPath = this.getFullPathForRecord(rorSelected);
        }
    }

    private String getFullPathForRecord(ResourceObjectRecord ror) {
        String sPath = "";
        EObject eo = this.getEObjectForRecord(ror);
        if (eo != null) {
            IPath path = ModelerCore.getModelEditor().getModelRelativePath(eo);
            sPath = String.valueOf(ror.getResourcePath()) + path.makeAbsolute().toString();
        } else {
            sPath = ror.getResourcePath();
        }
        return sPath;
    }

    protected void setLowerSelectedElement(Object element) {
        if (this.fQualifierElements == null) {
            return;
        }
        int i = 0;
        while (i != this.fQualifierElements.length) {
            if (this.fQualifierElements[i].equals(element)) break;
            ++i;
        }
        if (i != this.fQualifierElements.length) {
            this.fLowerList.setSelection(i);
        }
    }

    protected Object getLowerSelectedElement() {
        int index = this.fLowerList.getSelectionIndex();
        if (index >= 0) {
            return this.fQualifierElements[index];
        }
        return null;
    }

    private void updateLowerListWidget(Object[] elements) {
        int length = elements.length;
        Object[] qualifiers = new String[length];
        int i = 0;
        while (i != length) {
            qualifiers[i] = this.fQualifierRenderer.getText(elements[i]);
            ++i;
        }
        TwoArrayQuickSorter sorter = new TwoArrayQuickSorter(this.isCaseIgnored());
        sorter.sort(qualifiers, elements);
        int i2 = 0;
        while (i2 != length) {
            TableItem item = new TableItem(this.fLowerList, 0);
            item.setText((String)qualifiers[i2]);
            item.setImage(this.fQualifierRenderer.getImage(elements[i2]));
            ++i2;
        }
        if (this.fLowerList.getItemCount() > 0) {
            this.fLowerList.setSelection(0);
        }
    }

    protected void handleEmptyList() {
        super.handleEmptyList();
        this.fLowerList.setEnabled(false);
    }

    protected void updateOkState() {
        Object oSelected;
        String sContainerLabel;
        String sContainerLabelLowerCase;
        super.updateOkState();
        Button okButton = this.getOkButton();
        if (okButton != null && okButton.isEnabled() && ((sContainerLabelLowerCase = (sContainerLabel = this.fQualifierRenderer.getText(oSelected = this.getLowerSelectedElement())).toLowerCase()).endsWith(".xmi") || sContainerLabelLowerCase.endsWith(".xml") || sContainerLabelLowerCase.endsWith(".xsd") || sContainerLabelLowerCase.endsWith(".vdb"))) {
            this.getOkButton().setEnabled(false);
        }
    }
}

