/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.search.IFinderHostDialog;
import org.teiid.designer.ui.search.IFinderPanel;
import org.teiid.designer.ui.search.ModelObjectSelectionPanel;
import org.teiid.designer.ui.viewsupport.EObjectSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelWorkspacePanel;
import org.teiid.designer.ui.viewsupport.PropertiesDialog;

public class ModelObjectFinderDialog
extends SelectionStatusDialog
implements IFinderHostDialog {
    private static final String TITLE = UiConstants.Util.getString("ModelObjectFinderDialog.title", new Object[0]);
    private static final String PROPERTIES_BUTTON_TEXT = UiConstants.Util.getString("ModelObjectFinderDialog.propertiesButton.text", new Object[0]);
    private int PROPERTIES_BUTTON_ID = 10234;
    private Button btnProperties;
    private Object[] oselectedObjects;
    private ISelectionStatusValidator validator;
    private int iReturnCode = 1;
    private TabFolder tabFolder;
    private TabItem tiWorkspaceTab;
    private ModelWorkspacePanel pnlWorkspace;
    private TabItem tiFinderTab;
    private ModelObjectSelectionPanel pnlFinder;

    public ModelObjectFinderDialog(Shell shell) {
        super(shell);
        this.init();
    }

    private void init() {
        this.setTitle(TITLE);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.setStatusLineAboveButtons(true);
    }

    private ISelectionStatusValidator getValidator() {
        if (this.validator == null) {
            this.validator = new EObjectSelectionValidator();
        }
        return this.validator;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this.validator = validator;
        this.updateValidators();
    }

    public void updateValidators() {
        if (this.pnlFinder != null) {
            this.pnlFinder.setValidator(this.getValidator());
        }
        if (this.pnlWorkspace != null) {
            this.pnlWorkspace.setValidator(this.getValidator());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createTabbedPane(composite);
        this.updateValidators();
        return composite;
    }

    private void createTabbedPane(Composite parent) {
        this.tabFolder = new TabFolder(parent, 128);
        GridLayout gridLayout = new GridLayout();
        this.tabFolder.setLayout((Layout)gridLayout);
        GridData gridData1 = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gridData1);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IFinderPanel fpnl = ModelObjectFinderDialog.this.getCurrentPanel();
                fpnl.updateOKStatus();
                ModelObjectFinderDialog.this.resetEnabledState();
            }
        });
        this.tiWorkspaceTab = new TabItem(this.tabFolder, 0);
        this.createWorkspacePanel((Composite)this.tabFolder);
        this.tiWorkspaceTab.setControl((Control)this.pnlWorkspace);
        this.tiFinderTab = new TabItem(this.tabFolder, 0);
        this.createFinderPanel((Composite)this.tabFolder);
        this.tiFinderTab.setControl((Control)this.pnlFinder);
    }

    private void createWorkspacePanel(Composite parent) {
        this.pnlWorkspace = new ModelWorkspacePanel(parent, this);
        GridLayout gridLayout = new GridLayout();
        this.pnlWorkspace.setLayout((Layout)gridLayout);
        GridData gridData1 = new GridData(1808);
        this.pnlWorkspace.setLayoutData(gridData1);
        this.tiWorkspaceTab.setText(this.pnlWorkspace.getTitle());
        this.tiWorkspaceTab.setToolTipText(this.pnlWorkspace.getTitle());
        this.pnlWorkspace.setValidator(this.getValidator());
    }

    private void createFinderPanel(Composite parent) {
        this.pnlFinder = new ModelObjectSelectionPanel(parent, this, false);
        GridLayout gridLayout = new GridLayout();
        this.pnlFinder.setLayout((Layout)gridLayout);
        GridData gridData1 = new GridData(1808);
        this.pnlFinder.setLayoutData(gridData1);
        this.tiFinderTab.setText(this.pnlFinder.getTitle());
        this.tiFinderTab.setToolTipText(this.pnlFinder.getTitle());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnProperties = this.createButton(parent, this.PROPERTIES_BUTTON_ID, PROPERTIES_BUTTON_TEXT, false);
        this.btnProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModelObjectFinderDialog.this.computeResult();
                Object oSelectedObject = ModelObjectFinderDialog.this.getResult()[0];
                if (oSelectedObject != null && oSelectedObject instanceof EObject) {
                    PropertiesDialog dlg = new PropertiesDialog((EObject)oSelectedObject, null);
                    dlg.open();
                }
            }
        });
        this.pnlWorkspace.createButtonsForButtonBar(parent);
        this.pnlFinder.createButtonsForButtonBar(parent);
        super.createButtonsForButtonBar(parent);
    }

    void resetEnabledState() {
        this.btnProperties.setEnabled(this.getButton(0).getEnabled());
    }

    IFinderPanel getCurrentPanel() {
        TabItem ti = this.getCurrentTab();
        return (IFinderPanel)ti.getControl();
    }

    protected void computeResult() {
        IFinderPanel fpnl = this.getCurrentPanel();
        Object[] result = fpnl.getResult();
        this.setTheResult(result);
    }

    private void setTheResult(Object[] result) {
        this.oselectedObjects = result;
    }

    public Object[] getResult() {
        return this.oselectedObjects;
    }

    private TabItem getCurrentTab() {
        int iIndex = this.tabFolder.getSelectionIndex();
        return this.tabFolder.getItem(iIndex);
    }

    @Override
    public Button getOkButton() {
        return this.getButton(0);
    }

    @Override
    public Button getCancelButton() {
        return this.getButton(1);
    }

    @Override
    public void okPressed() {
        super.okPressed();
        this.iReturnCode = 0;
    }

    @Override
    public void cancelPressed() {
        super.cancelPressed();
        this.iReturnCode = 1;
    }

    @Override
    public Button createButton(Composite parent, int iId, String sText, boolean isDefault) {
        return super.createButton(parent, iId, sText, isDefault);
    }

    @Override
    public void updateTheStatus(IStatus status) {
        this.updateStatus(status);
        this.computeResult();
        this.resetEnabledState();
    }

    @Override
    public int getReturnCode() {
        return this.iReturnCode;
    }
}

