/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.common.actions.ActionService;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.search.IModelObjectMatch;
import org.teiid.designer.ui.search.MetadataMatch;
import org.teiid.designer.ui.search.MetadataMatchInfo;
import org.teiid.designer.ui.search.MetadataSearchLabelProvider;
import org.teiid.designer.ui.search.MetadataSearchResult;

public class MetadataSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable,
UiConstants {
    private static final int DEFAULT_RESULT_LIMIT = 1000;
    private static final String RESULT_LIMIT_KEY = "org.teiid.designer.search.resultpage.limit";
    static final String[] SHOW_IN_TARGETS = new String[]{"explorer.view"};
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private ResultsContentProvider contentProvider = new ResultsContentProvider();
    private ILabelProvider labelProvider = new MetadataSearchLabelProvider();

    public MetadataSearchResultPage() {
        this.setElementLimit(new Integer(1000));
    }

    StructuredViewer accessViewer() {
        return this.getViewer();
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
            this.getViewer().refresh();
        }
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MetadataSearchResultPage.this.focusPage();
            }
        });
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MetadataSearchResultPage.this.focusPage();
            }
        });
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
            this.getViewer().refresh();
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        try {
            ActionService actionService = UiPlugin.getDefault().getActionService(this.getSite().getWorkbenchWindow().getActivePage());
            IAction action = actionService.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT);
            mgr.add(action);
        }
        catch (CoreException err) {
            Util.log((Throwable)err);
        }
        super.fillContextMenu(mgr);
    }

    void focusPage() {
        if (!this.getViewer().getControl().isDisposed()) {
            UiUtil.getWorkbenchPage().activate((IWorkbenchPart)this.getViewPart());
        }
    }

    public Object getAdapter(Class adapter) {
        if (IShowInTargetList.class.equals((Object)adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    public Match getCurrentMatch() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (!selection.isEmpty()) {
            Object element = selection.getFirstElement();
            if (element instanceof Match) {
                return (Match)element;
            }
            return super.getCurrentMatch();
        }
        return null;
    }

    public int getDisplayedMatchCount(Object element) {
        if (element instanceof Match) {
            return super.getDisplayedMatchCount(((Match)element).getElement());
        }
        return super.getDisplayedMatchCount(element);
    }

    public void gotoNextMatch() {
        Match currMatch = this.getCurrentMatch();
        Match[] matches = this.getInput().getMatches(currMatch.getElement());
        boolean foundNextMatch = false;
        int i = 0;
        while (i < matches.length) {
            if (matches[i].equals(currMatch) && i < matches.length - 1) {
                foundNextMatch = true;
                this.showMatch(matches[i + 1], 0, 0, true);
                break;
            }
            ++i;
        }
        if (!foundNextMatch) {
            this.navigate(true);
            this.showMatch(this.getCurrentMatch(), 0, 0, true);
        }
    }

    public void gotoPreviousMatch() {
        Match currMatch = this.getCurrentMatch();
        Match[] matches = this.getInput().getMatches(currMatch.getElement());
        boolean foundPrevMatch = false;
        int i = 0;
        while (i < matches.length) {
            if (matches[i].equals(currMatch) && i > 0) {
                foundPrevMatch = true;
                this.showMatch(matches[i - 1], 0, 0, true);
                break;
            }
            ++i;
        }
        if (!foundPrevMatch) {
            this.navigate(false);
            this.showMatch(this.getCurrentMatch(), 0, 0, true);
        }
    }

    public void internalRemoveSelected() {
        StructuredViewer viewer = this.getViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        this.contentProvider.remove(selection.toArray());
        viewer.refresh();
    }

    private void navigate(boolean forward) {
        if (this.getLayout() == 1) {
            Table table = (Table)this.getViewer().getControl();
            int itemCount = table.getItemCount();
            if (itemCount == 0) {
                return;
            }
            int[] selection = table.getSelectionIndices();
            int nextIndex = 0;
            if (selection.length > 0) {
                if (forward) {
                    nextIndex = selection[selection.length - 1] + 1;
                    if (nextIndex >= itemCount) {
                        nextIndex = 0;
                    }
                } else {
                    nextIndex = selection[0] - 1;
                    if (nextIndex < 0) {
                        nextIndex = itemCount - 1;
                    }
                }
            }
            table.setSelection(nextIndex);
            table.showSelection();
        }
    }

    public void setElementLimit(Integer limit) {
        super.setElementLimit(limit);
        this.getSettings().put(RESULT_LIMIT_KEY, limit.intValue());
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) {
        IModelObjectMatch modelObjMatch = (IModelObjectMatch)match;
        ModelEditorManager.open(modelObjMatch.getEObject(), true);
        this.getViewer().setSelection((ISelection)new StructuredSelection((Object)match), true);
    }

    class ResultsContentProvider
    implements ITreeContentProvider {
        private MetadataSearchResult result;
        private Map<MetadataMatchInfo, Match[]> model = new HashMap<MetadataMatchInfo, Match[]>();

        ResultsContentProvider() {
        }

        public void clear() {
            this.model.clear();
        }

        public void dispose() {
        }

        public void elementsChanged(Object[] updatedElements) {
            this.ensureModelLoaded();
        }

        private void ensureModelLoaded() {
            if (this.result == null) {
                this.model.clear();
            } else {
                Object[] objectArray = this.result.getElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object matchInfo = objectArray[n2];
                    this.model.put((MetadataMatchInfo)matchInfo, this.result.getMatches(matchInfo));
                    ++n2;
                }
            }
        }

        public Object[] getChildren(Object parentElement) {
            return this.result.getMatches(parentElement);
        }

        public Object getParent(Object element) {
            if (element instanceof Match) {
                return ((Match)element).getElement();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            this.ensureModelLoaded();
            if (MetadataSearchResultPage.this.getLayout() == 1) {
                ArrayList<Match> allMatches = new ArrayList<Match>();
                Iterator<Match[]> iterator = this.model.values().iterator();
                while (iterator.hasNext()) {
                    Match[] matches;
                    Match[] matchArray = matches = iterator.next();
                    int n = matches.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Match match = matchArray[n2];
                        allMatches.add(match);
                        ++n2;
                    }
                }
                return allMatches.toArray();
            }
            return this.model.keySet().toArray();
        }

        public boolean hasChildren(Object element) {
            return element instanceof MetadataMatchInfo;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.model.clear();
            this.result = null;
            if (newInput instanceof MetadataSearchResult) {
                this.result = (MetadataSearchResult)newInput;
            }
        }

        public void remove(Object[] removedObjects) {
            Object[] objectArray = removedObjects;
            int n = removedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof MetadataMatch) {
                    MetadataMatch match = (MetadataMatch)obj;
                    this.result.removeMatch(match);
                    if (this.result.getMatches(match.getElement()).length == 0) {
                        this.model.remove(match.getElement());
                    }
                } else if (obj instanceof MetadataMatchInfo) {
                    this.result.removeMatches(this.result.getMatches(obj));
                    this.model.remove(obj);
                }
                ++n2;
            }
        }
    }
}

