/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.search;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.search.IModelObjectMatch;
import org.teiid.designer.ui.search.MetadataMatchInfo;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class MetadataSearchLabelProvider
extends LabelProvider
implements UiConstants {
    private ModelExplorerLabelProvider delegate = new ModelExplorerLabelProvider();

    public String getText(Object element) {
        if (element instanceof MetadataMatchInfo) {
            MetadataMatchInfo matchInfo = (MetadataMatchInfo)element;
            int count = matchInfo.getMatchCount();
            if (count == 1) {
                return Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(MetadataSearchLabelProvider.class)) + "resourceOneMatch.msg", (Object)matchInfo.getResourcePath());
            }
            return Util.getString(String.valueOf(I18nUtil.getPropertyPrefix(MetadataSearchLabelProvider.class)) + "resourceMatches.msg", new Object[]{matchInfo.getResourcePath(), count});
        }
        IModelObjectMatch match = (IModelObjectMatch)element;
        return match.getMatchDescription();
    }

    public Image getImage(Object element) {
        if (element instanceof IModelObjectMatch) {
            IModelObjectMatch match = (IModelObjectMatch)element;
            EObject eObj = match.getEObject();
            if (eObj != null) {
                return this.delegate.getImage(eObj);
            }
        } else if (element instanceof MetadataMatchInfo) {
            IResource model = ((MetadataMatchInfo)element).getResource();
            return ModelIdentifier.getModelImage(model);
        }
        return super.getImage(element);
    }
}

