/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor.delete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.ui.refactor.delete.DeleteResourcesRefactoring;

public class DeleteResourcesDescriptor
extends RefactoringDescriptor {
    static final String REFACTORING_ID = DeleteResourcesDescriptor.class.getPackage().getName();
    private static final String UNAMED_DESCRIPTOR = "Unamed_Descriptor";
    private Collection<IPath> resourcePaths = Collections.emptyList();
    private boolean deleteContents;

    public DeleteResourcesDescriptor() {
        this(UNAMED_DESCRIPTOR, null);
    }

    public DeleteResourcesDescriptor(String description, String comment) {
        super(REFACTORING_ID, null, description, comment, 6);
    }

    public Collection<IPath> getResourcePaths() {
        return this.resourcePaths;
    }

    public void setResourcePathsToDelete(Collection<IPath> resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    public void setResourcesToDelete(Collection<IResource> resources) {
        CoreArgCheck.isNotNull(resources);
        this.resourcePaths = new ArrayList<IPath>();
        for (IResource resource : resources) {
            this.resourcePaths.add(resource.getFullPath());
        }
    }

    public boolean isDeleteContents() {
        return this.deleteContents;
    }

    public void setDeleteContents(boolean deleteContents) {
        this.deleteContents = deleteContents;
    }

    public Refactoring createRefactoring(RefactoringStatus status) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (IPath resourcePath : this.resourcePaths) {
            IResource resource = root.findMember(resourcePath);
            if (resource == null || !resource.exists()) {
                status.addFatalError(RefactorResourcesUtils.getString("RefactorResourceDescriptor.resourceNoExistError", resourcePath));
                return null;
            }
            resources.add(resource);
        }
        DeleteResourcesRefactoring refactoring = new DeleteResourcesRefactoring(resources);
        refactoring.setDeleteContents(this.deleteContents);
        return refactoring;
    }
}

