/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.favorites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ResourceChangeUtilities;
import org.teiid.designer.ui.IModelerCacheListener;
import org.teiid.designer.ui.ModelerCacheEvent;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.favorites.EObjectModelerCache;

class ModelerCacheEventManager
implements INotifyChangedListener,
IResourceChangeListener,
IResourceDeltaVisitor,
EventObjectListener,
UiConstants {
    private ListenerList listeners;
    private final EObjectModelerCache cache;
    private final ModelEditor modelEditor = ModelerCore.getModelEditor();
    private boolean removeDeltaProcessed = false;

    public ModelerCacheEventManager(EObjectModelerCache theCache) {
        this.cache = theCache;
    }

    void addListener(IModelerCacheListener theListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList(1);
        }
        this.listeners.add((Object)theListener);
    }

    void fireCacheEvent(ModelerCacheEvent theEvent) {
        if (this.listeners != null) {
            Object[] cacheListeners = this.listeners.getListeners();
            int i = 0;
            while (i < cacheListeners.length) {
                ((IModelerCacheListener)cacheListeners[i]).cacheChanged(theEvent);
                ++i;
            }
        }
    }

    private Collection getAffectedItems(Notification theNotification) {
        if (theNotification instanceof SourcedNotification) {
            CoreArgCheck.isTrue((boolean)false, (String)"Input should not be a SourcedNotification.");
        }
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        EObject obj = NotificationUtilities.getEObject((Notification)theNotification);
        if (obj != null) {
            Collection descendants;
            if (this.cache.contains(obj)) {
                if (result.isEmpty()) {
                    result = new ArrayList<EObject>();
                }
                result.add(obj);
            }
            if (!(descendants = this.cache.getCachedDescendants(obj)).isEmpty()) {
                if (result.isEmpty()) {
                    result = new ArrayList();
                }
                result.addAll(descendants);
            }
        }
        return result;
    }

    public Collection getAffectedItems(ModelResource modelResource) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (!this.cache.isEmpty() && modelResource != null) {
            result = new ArrayList<EObject>();
            Iterator iter = this.cache.iterator();
            ModelResource mr = null;
            EObject eObj = null;
            while (iter.hasNext()) {
                eObj = (EObject)iter.next();
                mr = this.modelEditor.findModelResource(eObj);
                if (modelResource == null || !modelResource.equals(mr)) continue;
                result.add(eObj);
            }
        }
        return result;
    }

    public Collection getStaleItems() {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        if (!this.cache.isEmpty()) {
            result = new ArrayList<EObject>();
            Iterator iter = this.cache.iterator();
            ModelResource modelResource = null;
            EObject eObj = null;
            while (iter.hasNext()) {
                eObj = (EObject)iter.next();
                modelResource = this.modelEditor.findModelResource(eObj);
                if (modelResource != null) continue;
                result.add(eObj);
            }
        }
        return result;
    }

    private boolean isAffected(EObject theEObject, IResource theResource) {
        boolean result = false;
        if (!this.cache.isEmpty()) {
            ModelResource modelResource = this.modelEditor.findModelResource(theEObject);
            if (modelResource == null) {
                result = true;
            } else {
                IResource model = modelResource.getResource();
                if (model != null) {
                    int type = theResource.getType();
                    if (type == 1 && model.equals((Object)theResource)) {
                        result = true;
                    } else if (type == 2) {
                        if (model.getFullPath().toString().startsWith(theResource.getFullPath().toString())) {
                            result = true;
                        }
                    } else if (type == 4 && model.getProject().equals((Object)theResource)) {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    public void notifyChanged(Notification theNotification) {
        if (!this.cache.isEmpty()) {
            if (theNotification instanceof SourcedNotification) {
                Collection notifications = ((SourcedNotification)theNotification).getNotifications();
                Notification nextNotification2 = null;
                for (Notification nextNotification2 : notifications) {
                    if (NotificationUtilities.isRemoved((Notification)nextNotification2)) {
                        this.processRemove(nextNotification2);
                        continue;
                    }
                    if (!NotificationUtilities.isChanged((Notification)nextNotification2)) continue;
                    this.processChange(nextNotification2);
                }
            } else if (NotificationUtilities.isRemoved((Notification)theNotification)) {
                this.processRemove(theNotification);
            } else if (NotificationUtilities.isChanged((Notification)theNotification)) {
                this.processChange(theNotification);
            }
        }
    }

    private void processChange(Notification theNotification) {
        HashSet changedObjs = null;
        ModelerCacheEvent event = null;
        if (theNotification instanceof SourcedNotification) {
            Iterator itr = ((SourcedNotification)theNotification).getNotifications().iterator();
            while (itr.hasNext()) {
                Collection temp = this.getAffectedItems((Notification)itr.next());
                if (temp.isEmpty()) continue;
                if (changedObjs == null) {
                    changedObjs = new HashSet();
                }
                changedObjs.addAll(temp);
            }
        } else {
            Collection temp = this.getAffectedItems(theNotification);
            if (!temp.isEmpty()) {
                changedObjs = new HashSet();
                changedObjs.addAll(temp);
            }
        }
        if (changedObjs != null) {
            HashSet obj = changedObjs.size() == 1 ? changedObjs.iterator().next() : changedObjs;
            event = new ModelerCacheEvent(2, (Object)obj);
            this.fireCacheEvent(event);
        }
    }

    private void processRemove(Notification theNotification) {
        HashSet removedObjs = null;
        ModelerCacheEvent event = null;
        if (theNotification instanceof SourcedNotification) {
            Iterator itr = ((SourcedNotification)theNotification).getNotifications().iterator();
            while (itr.hasNext()) {
                Collection temp = this.removeAffectedItems((Notification)itr.next());
                if (temp.isEmpty()) continue;
                if (removedObjs == null) {
                    removedObjs = new HashSet();
                }
                removedObjs.addAll(temp);
            }
        } else {
            Collection temp = this.removeAffectedItems(theNotification);
            if (!temp.isEmpty()) {
                removedObjs = new HashSet();
                removedObjs.addAll(temp);
            }
        }
        if (removedObjs != null) {
            HashSet obj = removedObjs.size() == 1 ? removedObjs.iterator().next() : removedObjs;
            event = new ModelerCacheEvent(1, (Object)obj);
            this.fireCacheEvent(event);
        }
    }

    private Collection removeAffectedItems(IResource theResource) {
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        Iterator itr = this.cache.iterator();
        while (itr.hasNext()) {
            EObject obj = (EObject)itr.next();
            if (!this.isAffected(obj, theResource)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<EObject>();
            }
            result.add(obj);
            itr.remove();
        }
        return result;
    }

    private Collection removeAffectedItems(Notification theNotification) {
        if (theNotification instanceof SourcedNotification) {
            CoreArgCheck.isTrue((boolean)false, (String)"Input should not be a SourcedNotification.");
        }
        ArrayList<EObject> result = Collections.EMPTY_LIST;
        EObject[] kids = NotificationUtilities.getRemovedChildren((Notification)theNotification);
        int i = 0;
        while (i < kids.length) {
            Collection descendants;
            if (this.cache.contains(kids[i])) {
                if (result.isEmpty()) {
                    result = new ArrayList<EObject>();
                }
                result.add(kids[i]);
                this.cache.remove(kids[i]);
            }
            if (!(descendants = this.cache.getCachedDescendants(kids[i])).isEmpty()) {
                if (result.isEmpty()) {
                    result = new ArrayList();
                }
                result.addAll(descendants);
                this.cache.removeAll(descendants);
            }
            ++i;
        }
        return result;
    }

    void removeListener(IModelerCacheListener theListener) {
        if (this.listeners != null) {
            this.listeners.remove((Object)theListener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent theEvent) {
        if (!this.cache.isEmpty()) {
            IResource resource = theEvent.getResource();
            if (resource != null && !ModelerCore.hasModelNature((IProject)resource.getProject())) {
                return;
            }
            if (ResourceChangeUtilities.isProjectClosing((IResourceChangeEvent)theEvent)) {
                Collection removedObjs = this.removeAffectedItems(resource);
                if (!removedObjs.isEmpty()) {
                    Collection obj = removedObjs.size() > 1 ? removedObjs : removedObjs.iterator().next();
                    this.fireCacheEvent(new ModelerCacheEvent(1, (Object)obj));
                }
            } else if (ResourceChangeUtilities.isProjectRenamed((IResourceChangeEvent)theEvent)) {
                Collection changedObjs = this.removeAffectedItems(resource);
                if (!changedObjs.isEmpty()) {
                    Collection obj = changedObjs.size() > 1 ? changedObjs : changedObjs.iterator().next();
                    this.fireCacheEvent(new ModelerCacheEvent(2, (Object)obj));
                }
            } else if (ResourceChangeUtilities.isPreDelete((IResourceChangeEvent)theEvent)) {
                IProject project = (IProject)theEvent.getResource();
                if (project.isOpen()) {
                    this.validateContents();
                }
            } else if (theEvent.getType() == 1) {
                this.removeDeltaProcessed = false;
                IResourceDelta delta = theEvent.getDelta();
                if (delta == null || !ResourceChangeUtilities.isRename((IResourceChangeEvent)theEvent, (IResourceDelta[])delta.getAffectedChildren())) {
                    try {
                        theEvent.getDelta().accept((IResourceDeltaVisitor)this);
                    }
                    catch (CoreException theException) {
                        Util.log((Throwable)theException);
                    }
                }
            }
        }
    }

    private void validateContents() {
        Object obj;
        ArrayList<EObject> removedObjs = null;
        Iterator itr = this.cache.iterator();
        while (itr.hasNext()) {
            obj = (EObject)itr.next();
            if (obj.eResource() != null) continue;
            if (removedObjs == null) {
                removedObjs = new ArrayList<EObject>();
            }
            removedObjs.add((EObject)obj);
            itr.remove();
        }
        if (removedObjs != null) {
            obj = removedObjs.size() > 1 ? removedObjs : removedObjs.get(0);
            this.fireCacheEvent(new ModelerCacheEvent(1, obj));
        }
    }

    public boolean visit(IResourceDelta theDelta) {
        Collection objs;
        boolean result = true;
        if (ResourceChangeUtilities.isRemoved((IResourceDelta)theDelta) && !ResourceChangeUtilities.isMovedTo((IResourceDelta)theDelta) && !this.removeDeltaProcessed) {
            this.removeDeltaProcessed = true;
            this.validateContents();
            result = false;
        } else if (ResourceChangeUtilities.isMovedFrom((IResourceDelta)theDelta) && !(objs = this.removeAffectedItems(theDelta.getResource())).isEmpty()) {
            this.fireCacheEvent(new ModelerCacheEvent(1, objs));
        }
        return result;
    }

    public void processEvent(EventObject obj) {
        ModelResource changedResource;
        Collection changedObjs;
        ModelResourceEvent event = (ModelResourceEvent)obj;
        if (event.getType() == 6 && !(changedObjs = this.removeAffectedItems((changedResource = event.getModelResource()).getResource())).isEmpty()) {
            this.fireCacheEvent(new ModelerCacheEvent(1, changedObjs));
        }
    }
}

