/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.explorer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.views.navigator.ResourceNavigatorRenameAction;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.DelegatableAction;
import org.teiid.designer.ui.actions.TreeViewerRenameAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.refactor.rename.RenameRefactorAction;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelExplorerRenameAction
extends ResourceNavigatorRenameAction
implements ISelectionProvider,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(ModelExplorerRenameAction.class);
    private static final String RENAME_NOT_SUPPORTED_MESSAGE = ModelExplorerRenameAction.getString("renameNotSupportedMessage");
    private TreeViewerRenameAction inlineRenameAction = new TreeViewerRenameAction();
    private IActionDelegate delRefactorRename;
    private IAction actRefactorRename;

    private static String getString(Object id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public ModelExplorerRenameAction(Shell shell, TreeViewer treeViewer) {
        super(shell, treeViewer);
        this.inlineRenameAction.setTreeViewer(treeViewer, (ILabelProvider)treeViewer.getLabelProvider());
    }

    public void run() {
        Object selection = this.getStructuredSelection().getFirstElement();
        if (selection instanceof EObject) {
            this.inlineRenameAction.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.getStructuredSelection()));
            this.inlineRenameAction.run();
        } else if (selection instanceof IResource && ModelerCore.hasModelNature((IProject)((IResource)selection).getProject())) {
            if (selection instanceof IFile) {
                IFile file = (IFile)selection;
                if (ModelUtilities.isModelFile((IResource)file)) {
                    this.renameModelResource((IResource)file);
                } else if (file.getFileExtension() != null && ".vdb".endsWith(file.getFileExtension().toLowerCase())) {
                    WidgetUtil.showError((String)RENAME_NOT_SUPPORTED_MESSAGE);
                } else {
                    super.run();
                }
            } else if (selection instanceof IProject) {
                this.renameModelResource((IResource)selection);
            } else if (selection instanceof IFolder) {
                this.renameModelResource((IResource)selection);
            } else {
                super.run();
            }
        } else {
            super.run();
        }
    }

    private void renameModelResource(IResource theResource) {
        this.getRenameActionDelegate().selectionChanged(this.actRefactorRename, this.getSelection());
        if (this.actRefactorRename != null && this.actRefactorRename.isEnabled()) {
            this.actRefactorRename.run();
        }
    }

    private IActionDelegate getRenameActionDelegate() {
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (this.actRefactorRename == null) {
            this.delRefactorRename = new RenameRefactorAction();
            this.actRefactorRename = new DelegatableAction(this.delRefactorRename, window);
            this.actRefactorRename.setEnabled(false);
        }
        return this.delRefactorRename;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result = SelectionUtilities.isSingleSelection((ISelection)selection);
        if (result) {
            EObject selectedEObject = SelectionUtilities.getSelectedEObject((ISelection)selection);
            if (selectedEObject != null) {
                this.inlineRenameAction.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection));
                result = this.inlineRenameAction.isEnabled();
            } else {
                this.getRenameActionDelegate().selectionChanged(this.actRefactorRename, (ISelection)selection);
                result = this.actRefactorRename.isEnabled();
            }
        }
        return result;
    }

    public ISelection getSelection() {
        return this.getStructuredSelection();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        throw new RuntimeException("ModelExplorerRenameAction.addSelectionChangedListener is not supported");
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        throw new RuntimeException("ModelExplorerRenameAction.removeSelectionChangedListener is not supported");
    }

    public void setSelection(ISelection selection) {
        throw new RuntimeException("ModelExplorerRenameAction.setSelection is not supported");
    }
}

