/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.explorer;

import java.io.File;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.ui.PluginConstants;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.viewsupport.DiagramLabelProvider;
import org.teiid.designer.ui.viewsupport.ExtendedModelObjectLabelProvider;
import org.teiid.designer.ui.viewsupport.ImportContainer;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelExplorerLabelProvider
extends LabelProvider
implements ILightweightLabelDecorator,
UiConstants,
PluginConstants.Images {
    public static boolean debug = false;
    private static int instanceCounter = 0;
    private ILabelProvider defaultProvider;
    private ExtendedModelObjectLabelProvider extendedModelObjectLabelProvider;
    private IResourceChangeListener resrcChgListener;
    private DiagramLabelProvider diagramLabelProvider;
    private IBaseLabelProvider eventSource;
    ListenerList myListeners = new ListenerList(1);

    public ModelExplorerLabelProvider() {
        if (debug) {
            System.err.println("ModelExplorerLabelProvider instantiated: " + ++instanceCounter + " instance(s) in memory.");
        }
        this.eventSource = this;
        this.resrcChgListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                Display display = Display.getDefault();
                if (display.isDisposed()) {
                    return;
                }
                if (ModelExplorerLabelProvider.this.myListeners == null || ModelExplorerLabelProvider.this.myListeners.isEmpty()) {
                    return;
                }
                IMarkerDelta[] deltas = event.findMarkerDeltas(null, true);
                if (deltas != null && deltas.length > 0) {
                    HashSet<IResource> resources = new HashSet<IResource>();
                    int i = 0;
                    while (i < deltas.length) {
                        resources.add(deltas[i].getResource());
                        ++i;
                    }
                    final Object[] resourcesToUpdate = resources.toArray();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ModelExplorerLabelProvider.this.changeLabel(resourcesToUpdate);
                        }
                    });
                }
            }
        };
        ModelerCore.getWorkspace().addResourceChangeListener(this.resrcChgListener);
        this.diagramLabelProvider = new DiagramLabelProvider();
        this.extendedModelObjectLabelProvider = new ExtendedModelObjectLabelProvider();
    }

    void changeLabel(Object[] resourcesToUpdate) {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent(this.getLabelProviderChangedEventSource(), resourcesToUpdate));
    }

    public void setLabelProviderChangedEventSource(IBaseLabelProvider theSource) {
        this.eventSource = theSource;
    }

    public IBaseLabelProvider getLabelProviderChangedEventSource() {
        return this.eventSource;
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.myListeners.add((Object)listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.myListeners.remove((Object)listener);
    }

    IResourceChangeListener getResourceChangeListener() {
        return this.resrcChgListener;
    }

    private ILabelProvider getDefaultProvider() {
        if (this.defaultProvider == null) {
            this.defaultProvider = new WorkbenchLabelProvider();
        }
        return this.defaultProvider;
    }

    public void dispose() {
        if (debug) {
            System.err.println("ModelExplorerLabelProvider disposed: " + --instanceCounter + " instance(s) in memory.");
        }
        ModelerCore.getWorkspace().removeResourceChangeListener(this.getResourceChangeListener());
    }

    public Image getImage(Object element) {
        Image result;
        block19: {
            result = null;
            boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)this);
            boolean succeeded = false;
            try {
                try {
                    if (element instanceof Diagram) {
                        result = this.diagramLabelProvider.getImage(element);
                        if (result == null) {
                            result = UiPlugin.getDefault().getImage("icons/full/obj16/Diagram.gif");
                        }
                    } else {
                        result = element instanceof ImportContainer ? UiPlugin.getDefault().getImage("icons/full/obj16/Imports.gif") : (element instanceof EObject ? (element instanceof TransformationMappingRoot ? UiPlugin.getDefault().getImage("icons/full/obj16/Transform.gif") : ModelUtilities.getEMFLabelProvider().getImage(element)) : (element instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)element)) && ((IFile)element).exists() ? ModelIdentifier.getModelImage((IResource)element) : this.extendedModelObjectLabelProvider.getImage(element)));
                    }
                    if (result == null) {
                        result = this.getDefaultProvider().getImage(element);
                    }
                    succeeded = true;
                }
                catch (Exception err) {
                    Util.log((Throwable)err);
                    if (startedTxn) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (startedTxn) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        if (result != null) {
            return result;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        String result = null;
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)this);
        boolean succeeded = false;
        try {
            if (element instanceof Diagram) {
                result = this.diagramLabelProvider.getText(element);
                if (result == null) {
                    result = UiConstants.Util.getString("ModelExplorerLabelProvider.genericDiagramLabel", new Object[0]);
                }
            } else if (element instanceof ImportContainer) {
                result = element.toString();
            } else if (element instanceof EObject) {
                if (element instanceof TransformationMappingRoot) {
                    result = UiConstants.Util.getString("ModelExplorerLabelProvider.genericTransformationLabel", new Object[0]);
                } else {
                    ILabelProvider p = ModelUtilities.getEMFLabelProvider();
                    result = p.getText(element);
                }
            } else {
                result = this.extendedModelObjectLabelProvider.getText(element);
                if (result == null) {
                    String defaultText = this.getDefaultProvider().getText(element);
                    if (ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric() && defaultText.endsWith(".xmi")) {
                        int len = defaultText.lastIndexOf(".xmi");
                        defaultText = defaultText.substring(0, len);
                    }
                    result = defaultText;
                }
            }
            succeeded = true;
        }
        finally {
            if (startedTxn) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        return result;
    }

    public void decorate(Object element, IDecoration decoration) {
        ImageDescriptor decorationIcon;
        Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        IResource resrc = this.getResource(element);
        if (resrc == null || !resrc.exists() || resrc instanceof IProject && !((IProject)resrc).isOpen()) {
            return;
        }
        IMarker[] markers = null;
        boolean errorOccurred = false;
        try {
            markers = ModelUtil.isVdbArchiveFile((IResource)resrc) ? resrc.findMarkers("org.teiid.designer.vdb.ui.vdbMarker", false, 2) : resrc.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        }
        catch (CoreException ex) {
            Util.log((Throwable)ex);
            errorOccurred = true;
        }
        if (!errorOccurred && (decorationIcon = this.getDecorationIcon(markers)) != null) {
            decoration.addOverlay(decorationIcon);
        }
        try {
            IMarker[] problems = resrc.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            int i = 0;
            while (i < problems.length) {
                IMarker marker = problems[i];
                String value = marker.getAttribute("org.teiid.designer.core.problemDecoratorText", null);
                if (value != null) {
                    String message = UiConstants.Util.getString("ModelExplorerLabelProvider.problemMarkerBrackets", (Object)value);
                    decoration.addSuffix(message);
                    break;
                }
                ++i;
            }
        }
        catch (CoreException ex) {
            Util.log((Throwable)ex);
        }
        if (element instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)element))) {
            File file = ((IFile)element).getLocation().toFile();
            ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
            try {
                for (String namespacePrefix : registry.getAllNamespacePrefixes()) {
                    ModelExtensionAssistant assistant = registry.getModelExtensionAssistant(namespacePrefix);
                    if (assistant.getModelExtensionDefinition().isBuiltIn() || !(assistant instanceof ModelObjectExtensionAssistant) || !((ModelObjectExtensionAssistant)assistant).supportsMyNamespace(element)) continue;
                    decoration.addOverlay(UiPlugin.getDefault().getExtensionDecoratorImage(), 0);
                    break;
                }
            }
            catch (Exception e) {
                Util.log(1, (Throwable)e, Util.getString("ModelExplorerLabelProvider.modelExtensionError", (Object)file.getName()));
            }
        }
    }

    private ImageDescriptor getDecorationIcon(IMarker[] markers) {
        boolean startedTxn = ModelerCore.startTxn((boolean)false, (boolean)false, null, (Object)this);
        ImageDescriptor icon = null;
        int ndx = markers.length;
        while (--ndx >= 0) {
            Object attr = MarkerUtilities.getMarkerAttribute(markers[ndx], "severity");
            if (attr == null) continue;
            int severity = (Integer)attr;
            if (severity == 2) {
                icon = UiPlugin.getDefault().getErrorDecoratorImage();
                break;
            }
            if (icon != null || severity != 1) continue;
            icon = UiPlugin.getDefault().getWarningDecoratorImage();
        }
        if (startedTxn) {
            ModelerCore.commitTxn();
        }
        return icon;
    }

    private IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IAdaptable) {
            return (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return null;
    }
}

