/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.refactor.ModelCopyCommand;
import org.teiid.designer.core.search.ModelWorkspaceSearch;
import org.teiid.designer.core.search.runtime.ResourceImportRecord;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelResourceReloadVetoListener;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.dialog.CheckedListSelectionDialog;
import org.teiid.designer.ui.common.print.IPrintable;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.viewsupport.ListContentProvider;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.IEditorActionExporter;
import org.teiid.designer.ui.editors.IInitializationCompleteListener;
import org.teiid.designer.ui.editors.IInitializationCompleteNotifier;
import org.teiid.designer.ui.editors.IInlineRenameable;
import org.teiid.designer.ui.editors.INavigationSupported;
import org.teiid.designer.ui.editors.ModelEditorActionContributor;
import org.teiid.designer.ui.editors.ModelEditorEventObjectListener;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorSelectionProvider;
import org.teiid.designer.ui.editors.ModelEditorSelectionSynchronizer;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.ModelObjectEditorPanel;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.editors.NavigationMarker;
import org.teiid.designer.ui.editors.OpenEditorMap;
import org.teiid.designer.ui.editors.SaveAsDialog;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.explorer.ModelExplorerResourceNavigator;
import org.teiid.designer.ui.outline.ModelOutlinePage;
import org.teiid.designer.ui.properties.ModelObjectPropertySourceProvider;
import org.teiid.designer.ui.undo.IUndoManager;
import org.teiid.designer.ui.undo.ModelerUndoManager;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.StatusBarUpdater;

public class ModelEditor
extends MultiPageModelEditor
implements IEditorActionExporter,
INavigationLocationProvider,
INotifyChangedListener,
ITextEditorExtension2,
UiConstants.ExtensionPoints.ModelEditorPage,
IResourceChangeListener,
INavigationSupported,
IInitializationCompleteListener,
IInlineRenameable,
UiConstants {
    static final String PREFIX = I18nUtil.getPropertyPrefix(ModelEditor.class);
    public static boolean NEVER_DIRTY = false;
    public static long INITIAL_STAMP = -1L;
    private ModelOutlinePage contentOutlinePage;
    private ModelObjectPropertySourceProvider propertySourceProvider;
    private ModelEditorSelectionProvider selectionProvider;
    private ModelEditorSelectionSynchronizer selectionSynchronizer;
    private ModelExplorerLabelProvider labelProvider = new ModelExplorerLabelProvider();
    ModelResource modelResource;
    private ModelEditorActionContributor actionBarHandler;
    private ArrayList completionEditors = new ArrayList(1);
    private int nEditorsCompleted = 0;
    boolean resourceDirty = false;
    private boolean initialized = false;
    boolean isClosing = false;
    private Menu contextMenu;
    private ModelResourceReloadVetoListener vetoListener;
    EventObjectListener modelResourceListener;
    private UndoActionHandler undoAction;
    private RedoActionHandler redoAction;
    private int iCurrentPage;

    public boolean hasInitialized() {
        return this.initialized;
    }

    @Override
    protected void createPages() {
        String message;
        this.actionBarHandler = (ModelEditorActionContributor)this.getEditorSite().getActionBarContributor();
        this.actionBarHandler.setEditorInput((IFileEditorInput)this.getEditorInput());
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "modelEditorPage");
        IExtension[] extensions = extensionPoint.getExtensions();
        Object[] editorList = new Object[10];
        String[] nameList = new String[10];
        int i = extensions.length - 1;
        while (i >= 0) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                block22: {
                    try {
                        Object extension = elements[j].createExecutableExtension("name");
                        String orderString = elements[j].getAttribute("order");
                        if (orderString == null) break block22;
                        int order = extensions.length;
                        try {
                            order = new Integer(orderString);
                        }
                        catch (Exception exception) {}
                        boolean tryAgain = true;
                        int index = order;
                        while (tryAgain) {
                            if (editorList[index] == null) {
                                editorList[index] = extension;
                                nameList[index] = elements[j].getAttribute("tabName");
                                tryAgain = false;
                                continue;
                            }
                            ++index;
                        }
                    }
                    catch (Exception e) {
                        message = UiConstants.Util.getString("ModelEditor.pageInitializationErrorMessage", (Object)elements[j].getAttribute("name"));
                        UiConstants.Util.log(4, (Throwable)e, message);
                        String title = UiConstants.Util.getString("ModelEditor.pageInitializationErrorTitle", new Object[0]);
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)message);
                    }
                }
                ++j;
            }
            --i;
        }
        i = 0;
        while (i < editorList.length) {
            block23: {
                int index = -1;
                Object extension = editorList[i];
                try {
                    if (extension instanceof ModelEditorPage) {
                        ModelEditorPage page = (ModelEditorPage)extension;
                        if (page.canDisplay(this.getEditorInput())) {
                            page.setLabelProvider((ILabelProvider)this.labelProvider);
                            if (page instanceof IInitializationCompleteNotifier) {
                                ((IInitializationCompleteNotifier)((Object)page)).addListener(this);
                                this.completionEditors.add(page);
                            }
                            index = this.addPage(page, this.getEditorInput());
                            page.setTitleText(nameList[i]);
                            this.setPageText(index, nameList[i]);
                            this.setPageImage(index, page.getTitleImage());
                            this.setPageToolTipText(index, page.getTitleToolTip());
                        } else {
                            page.preDispose();
                        }
                    }
                }
                catch (Exception e) {
                    message = UiConstants.Util.getString("ModelEditor.pageInitializationErrorMessage", (Object)extension.toString());
                    UiConstants.Util.log(4, (Throwable)e, message);
                    String title = UiConstants.Util.getString("ModelEditor.pageInitializationErrorTitle", new Object[0]);
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)message);
                    if (index == -1) break block23;
                    try {
                        this.removePage(index);
                    }
                    catch (Exception exception) {}
                }
            }
            ++i;
        }
        this.selectionSynchronizer = new ModelEditorSelectionSynchronizer(this, ((IFileEditorInput)this.getEditorInput()).getFile());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.selectionSynchronizer);
        IStatusLineManager slManager = this.getEditorSite().getActionBars().getStatusLineManager();
        this.selectionProvider.addSelectionChangedListener(new StatusBarUpdater(slManager));
        ModelUtilities.addNotifyChangedListener(this);
        ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        try {
            if (this.modelResource.getEmfResource().isModified()) {
                this.resourceDirty = true;
                this.firePropertyChange(257);
            }
        }
        catch (ModelWorkspaceException e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
        this.modelResourceListener = new ModelEditorEventObjectListener(this);
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, this.modelResourceListener);
        }
        catch (EventSourceException e) {
            Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    @Override
    protected void initializeEditor(IEditorPart editor) {
        ModelEditorPage page;
        AbstractModelEditorPageActionBarContributor contributor;
        if (editor instanceof EventObjectListener) {
            try {
                UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, (EventObjectListener)editor);
            }
            catch (EventSourceException e) {
                Util.log(4, (Throwable)e, e.getMessage());
            }
        }
        if ((contributor = (page = (ModelEditorPage)editor).getActionBarContributor()) != null) {
            this.actionBarHandler.addContributor(editor, (IEditorActionBarContributor)contributor);
            contributor.createContextMenu();
            contributor.getActionService();
        }
        page.setLabelProvider((ILabelProvider)this.labelProvider);
        if (page instanceof INavigationSupported) {
            ((INavigationSupported)((Object)page)).setParent(this);
        }
        this.getContentOutline().addOutlineContribution(page);
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            page.initializeEditorPage();
        }
    }

    public ModelResource getModelResource() {
        return this.modelResource;
    }

    public IFile getModelFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    public void doSave(IProgressMonitor monitor) {
        if (ModelUtil.isIResourceReadOnly((IResource)this.modelResource.getResource())) {
            String message = UiConstants.Util.getString("ModelEditor.resourceReadonlySaveError", (Object)this.modelResource.getResource().getName());
            String title = UiConstants.Util.getString("ModelEditor.resourceSaveErrorTitle", new Object[0]);
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)message);
            return;
        }
        super.preSave(false);
        WorkspaceJob job = new WorkspaceJob(UiConstants.Util.getString("ModelEditor.saveModelJob", (Object)this.modelResource.getResource().getName())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    ModelUtilities.saveModelResource(ModelEditor.this.modelResource, monitor, true, (Object)this);
                    ModelEditor.this.resourceDirty = false;
                    UiUtil.runInSwtThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ModelEditor.this.firePropertyChange(257);
                        }
                    }, (boolean)true);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.teiid.designer.ui", 0, e.getLocalizedMessage(), (Throwable)e));
                }
            }
        };
        job.setRule((ISchedulingRule)this.modelResource.getResource());
        job.schedule();
    }

    public boolean isSaveAsAllowed() {
        IWorkbenchPart activePart = this.getSite().getWorkbenchWindow().getPartService().getActivePart();
        return this == activePart;
    }

    public void doSaveAs() {
        final SaveAsDialog dialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell(), this.modelResource);
        int result = dialog.open();
        if (result == 0) {
            ModelDependencyCheck check = new ModelDependencyCheck(dialog.getCommand());
            UiBusyIndicator.showWhile(null, (Runnable)check);
            result = check.result;
            if (result == 0) {
                WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                        String undoLabel = UiConstants.Util.getString("ModelEditor.saveAs=", new Object[0]);
                        boolean started = ModelerCore.startTxn((boolean)true, (boolean)false, (String)undoLabel, (Object)ModelEditor.this);
                        boolean succeeded = false;
                        try {
                            IStatus status = dialog.getCommand().execute(progressMonitor);
                            if (status == null || status.isOK()) {
                                ModelEditor.this.modelResource.close();
                                ModelEditorManager.close((IFile)ModelEditor.this.modelResource.getResource(), false);
                                ModelEditorManager.activate(dialog.getCommand().getNewIFile(), true);
                            }
                            succeeded = true;
                        }
                        finally {
                            if (started) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
                }
                catch (InvocationTargetException e) {
                    UiConstants.Util.log(e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public void gotoMarker(IMarker marker) {
        String sMarkerType = marker.getAttribute("markerType", "unknown");
        if (sMarkerType.equals("navigation")) {
            Object oDelegate = MarkerUtilities.getMarkerAttribute(marker, "delegate");
            Object oDelegatesMarker = MarkerUtilities.getMarkerAttribute(marker, "delegatesMarker");
            if (oDelegate != null && oDelegate instanceof IEditorPart && oDelegatesMarker != null && oDelegatesMarker instanceof IMarker) {
                IEditorPart iepDelegate = (IEditorPart)oDelegate;
                IDE.gotoMarker((IEditorPart)iepDelegate, (IMarker)((IMarker)oDelegatesMarker));
            } else {
                int iPage = marker.getAttribute("tabIndex", 0);
                this.setActivePage(iPage);
            }
        } else {
            EObject targetEObject = ModelObjectUtilities.getMarkedEObject(marker);
            if (targetEObject != null) {
                IViewPart part;
                if (ModelEditorManager.canEdit(targetEObject)) {
                    if (this.getActiveObjectEditor() == null) {
                        ModelEditorManager.edit(targetEObject);
                    } else if (!this.getActiveObjectEditor().isEditingObject(targetEObject)) {
                        ModelEditorManager.edit(targetEObject);
                    }
                } else if (this.getActiveObjectEditor() != null) {
                    this.closeObjectEditor();
                }
                ModelEditorPage page2 = null;
                Collection allPages = this.getModelPagesFor(targetEObject);
                boolean foundPage = false;
                for (ModelEditorPage page2 : allPages) {
                    if (page2 == null) continue;
                    if (!super.hasInitialized(page2)) {
                        super.initializePage(page2);
                    }
                    IDE.gotoMarker((IEditorPart)page2, (IMarker)marker);
                    foundPage = true;
                }
                if (!foundPage && (part = UiUtil.getWorkbenchPage().findView("explorer.view")) != null) {
                    ((ModelExplorerResourceNavigator)part).gotoMarker(marker);
                }
            }
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!(input instanceof IFileEditorInput) || !ModelUtilities.existsOnFilesystem((IResource)((IFileEditorInput)input).getFile())) {
            String message = UiConstants.Util.getString("ModelEditor.invalidInputError", (Object)input.getName());
            throw new PartInitException(message);
        }
        IFile file = ((IFileEditorInput)input).getFile();
        if (!ModelUtil.isModelFile((IResource)file) && !ModelFileUtil.isModelFileExtension((String)file.getFileExtension(), (boolean)true) && ModelFileUtil.isModelFileExtension((String)file.getFileExtension(), (boolean)false)) {
            String actualFileName = file.getName();
            String actualExtension = file.getFileExtension();
            int endIndex = actualFileName.length() - actualExtension.length();
            String expectedFileName = String.valueOf(actualFileName.substring(0, endIndex)) + actualExtension.toLowerCase();
            Object[] params = new Object[]{actualFileName, expectedFileName};
            String msg = UiConstants.Util.getString("ModelEditor.file_extension_not_correct_case_please_rename_file", params);
            throw new PartInitException(msg);
        }
        try {
            this.modelResource = ModelUtil.getModelResource((IFile)((IFileEditorInput)input).getFile(), (boolean)false);
            if (this.modelResource == null) {
                String message = UiConstants.Util.getString("ModelEditor.modelResourceError", (Object)input.getName());
                throw new PartInitException(message);
            }
            this.vetoListener = new ModelResourceReloadVetoListener(){

                public boolean canReload(ModelResource theModelResource) {
                    return ModelEditor.this.handleCanReload(theModelResource);
                }
            };
            this.modelResource.getModelWorkspace().addModelResourceReloadVetoListener(this.vetoListener);
            OpenEditorMap.getInstance().addModelEditor(this, this.modelResource);
        }
        catch (ModelWorkspaceException e) {
            String message = UiConstants.Util.getString("ModelEditor.modelResourceError", (Object)input.getName());
            throw new PartInitException(message, (Throwable)e);
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(((IFileEditorInput)this.getEditorInput()).getFile().getName());
        this.setTitleImage(ModelIdentifier.getModelImage(this.modelResource));
        this.selectionProvider = new ModelEditorSelectionProvider(this);
        super.getEditorSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.getEditorSite().getWorkbenchWindow().getWorkbench().addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow theWindow) {
                ModelEditor.this.getActionBarContributor().setReadOnlyState();
            }

            public void windowOpened(IWorkbenchWindow theWindow) {
            }

            public void windowDeactivated(IWorkbenchWindow theWindow) {
            }

            public void windowClosed(IWorkbenchWindow theWindow) {
            }
        });
        IUndoContext undoContext = ModelerUndoManager.getInstance().getUndoContext();
        this.undoAction = new UndoActionHandler(this.getSite(), undoContext);
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.redoAction = new RedoActionHandler(this.getSite(), undoContext);
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        this.initialized = true;
    }

    protected boolean handleCanReload(ModelResource theModelResource) {
        boolean canReload = true;
        if (this.modelResource != null && this.modelResource.equals(theModelResource)) {
            ReloadRequestRunnable runnable = new ReloadRequestRunnable();
            Display.getDefault().syncExec((Runnable)runnable);
            canReload = runnable.canReload();
        }
        return canReload;
    }

    public ModelEditorActionContributor getActionBarContributor() {
        return (ModelEditorActionContributor)this.getEditorSite().getActionBarContributor();
    }

    public IEditorPart getCurrentPage() {
        return this.getActiveEditor();
    }

    @Override
    public void contributeExportedActions(IMenuManager theMenuMgr) {
        ModelEditorPage page = (ModelEditorPage)this.getCurrentPage();
        AbstractModelEditorPageActionBarContributor contributor = page.getActionBarContributor();
        if (contributor != null) {
            contributor.contributeExportedActions(theMenuMgr);
        }
    }

    @Override
    public List<IAction> getAdditionalModelingActions(ISelection selection) {
        ModelEditorPage page = (ModelEditorPage)this.getCurrentPage();
        AbstractModelEditorPageActionBarContributor contributor = page.getActionBarContributor();
        if (contributor != null) {
            return contributor.getAdditionalModelingActions(selection);
        }
        return Collections.EMPTY_LIST;
    }

    public ISelection getSelection() {
        return this.selectionProvider.getSelection();
    }

    @Override
    public void setFocus() {
        ModelEditorPage page = (ModelEditorPage)this.getActiveEditor();
        if (page != null && page.getControl() != null) {
            page.getControl().setFocus();
        }
        super.setFocus();
        ModelEditorActionContributor abc = this.getActionBarContributor();
        if (abc != null) {
            abc.setEditorInput((IFileEditorInput)this.getEditorInput());
            abc.setReadOnlyState();
            if (page != null) {
                page.updateReadOnlyState(abc.getReadOnlyState());
            }
            this.updateReadOnlyState();
        }
    }

    public void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
    }

    @Override
    public Object getAdapter(Class key) {
        Object undoMgr;
        ModelObjectEditorPage objectEditor;
        if (key.equals(IContentOutlinePage.class)) {
            return this.getContentOutline();
        }
        if (key.equals(IPropertySheetPage.class)) {
            if (this.propertySourceProvider == null) {
                this.propertySourceProvider = ModelUtilities.getPropertySourceProvider();
            }
            return this.propertySourceProvider.getPropertySheetPage();
        }
        if (key.equals(IFindReplaceTarget.class)) {
            if (this.editorContainer.hasFocus()) {
                if (this.editorContainer.getActiveEditor() instanceof IAdaptable) {
                    return ((IAdaptable)this.editorContainer.getActiveEditor()).getAdapter(key);
                }
                return null;
            }
            return this.getCurrentPage() == null ? null : this.getCurrentPage().getAdapter(key);
        }
        if (key.equals(IPrintable.class)) {
            if (this.getCurrentPage() != null) {
                return this.getCurrentPage().getAdapter(IPrintable.class);
            }
        } else if (key.equals(IUndoManager.class) && this.editorContainer.hasFocus() && (objectEditor = this.editorContainer.getActiveEditor()) instanceof IAdaptable && (undoMgr = ((IAdaptable)objectEditor).getAdapter(key)) != null) {
            return undoMgr;
        }
        return super.getAdapter(key);
    }

    public IAdaptable getExternalAdaptable() {
        if (this.editorContainer != null) {
            return this.editorContainer;
        }
        return null;
    }

    public ModelObjectEditorPanel getEditorContainer() {
        return this.editorContainer;
    }

    @Override
    public void dispose() {
        if (this.propertySourceProvider != null) {
            this.propertySourceProvider.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        if (this.selectionSynchronizer != null) {
            this.selectionSynchronizer.dispose();
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this.selectionSynchronizer);
        }
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
        }
        ModelUtilities.removeNotifyChangedListener(this);
        ModelerCore.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.modelResource.getModelWorkspace().removeModelResourceReloadVetoListener(this.vetoListener);
        Iterator iter = this.getAllEditors().iterator();
        Object nextEditor = null;
        while (iter.hasNext()) {
            nextEditor = iter.next();
            if (!(nextEditor instanceof EventObjectListener)) continue;
            try {
                UiPlugin.getDefault().getEventBroker().removeListener(ModelResourceEvent.class, (EventObjectListener)nextEditor);
            }
            catch (EventSourceException e) {
                Util.log(4, (Throwable)e, e.getMessage());
            }
        }
        try {
            UiPlugin.getDefault().getEventBroker().removeListener(ModelResourceEvent.class, this.modelResourceListener);
        }
        catch (EventSourceException e) {
            Util.log(4, (Throwable)e, e.getMessage());
        }
        this.labelProvider.dispose();
        if (this.modelResource != null && this.modelResource.isOpen()) {
            try {
                OpenEditorMap.getInstance().removeModelEditor(this.modelResource);
                if (this.isDirty()) {
                    ModelResourceEvent event = new ModelResourceEvent(this.modelResource, 2, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                    this.modelResource.close();
                    event = new ModelResourceEvent(this.modelResource, 3, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                    event = new ModelResourceEvent(this.modelResource, 6, (Object)this);
                    UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
                }
            }
            catch (ModelWorkspaceException e) {
                String message = UiConstants.Util.getString("ModelEditor.modelResourceCloseError", (Object)this.modelResource);
                UiConstants.Util.log(4, (Throwable)e, message);
            }
        }
        super.dispose();
    }

    public boolean canOpenModelObject(Object modelObject) {
        boolean result = false;
        if (modelObject != null) {
            int i = 0;
            while (i < super.getPageCount()) {
                ModelEditorPage page = (ModelEditorPage)this.getEditor(i);
                if (page.canOpenContext(modelObject)) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public ModelEditorPage getModelPageFor(Object modelObject) {
        ModelEditorPage result = null;
        if (modelObject != null) {
            int i = 0;
            while (i < super.getPageCount()) {
                ModelEditorPage page = (ModelEditorPage)this.getEditor(i);
                if (page.canOpenContext(modelObject)) {
                    result = page;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public Collection getModelPagesFor(Object modelObject) {
        ArrayList<ModelEditorPage> pages = new ArrayList<ModelEditorPage>();
        if (modelObject != null) {
            int i = 0;
            while (i < super.getPageCount()) {
                ModelEditorPage page = (ModelEditorPage)this.getEditor(i);
                if (page.canOpenContext(modelObject)) {
                    pages.add(page);
                }
                ++i;
            }
        }
        if (pages.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return pages;
    }

    public boolean openModelObject(Object modelObject) {
        return this.openModelObject(modelObject, false);
    }

    public boolean openModelObject(Object modelObject, boolean forceRefresh) {
        boolean result = false;
        ModelEditorPage focusPage = null;
        int pageIndex = -1;
        if (modelObject != null) {
            int i = 0;
            while (i < super.getPageCount()) {
                ModelEditorPage page = (ModelEditorPage)this.getEditor(i);
                if (page.canOpenContext(modelObject)) {
                    if (!this.hasInitialized(page)) {
                        this.initializePage(page);
                    }
                    page.openContext(modelObject, forceRefresh);
                    if (focusPage == null || this.getActiveEditor() == page) {
                        focusPage = page;
                        pageIndex = i;
                        result = true;
                    }
                }
                ++i;
            }
            if (focusPage != null) {
                if (this.getActiveEditor() != focusPage) {
                    if (!this.hasInitialized(focusPage)) {
                        super.initializePage(focusPage, super.getItem(pageIndex));
                    }
                    super.setActivePage(pageIndex);
                }
                this.pageChange(pageIndex);
                if (this.getActiveEditor() != focusPage) {
                    this.setFocus();
                    focusPage.setFocus();
                }
                if (this.selectionProvider != null) {
                    this.selectionProvider.setSourcePage(focusPage);
                }
                this.setPageImage(pageIndex, focusPage.getTitleImage());
                this.setPageText(pageIndex, focusPage.getTitle());
                this.setPageToolTipText(pageIndex, focusPage.getTitleToolTip());
            }
        }
        return result;
    }

    public void refreshEditorTabs() {
        int i = 0;
        while (i < super.getPageCount()) {
            ModelEditorPage page = (ModelEditorPage)this.getEditor(i);
            if (page != null) {
                this.setPageImage(i, page.getTitleImage());
                this.setPageText(i, page.getTitle());
                this.setPageToolTipText(i, page.getTitleToolTip());
            }
            ++i;
        }
    }

    private ModelOutlinePage getContentOutline() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new ModelOutlinePage(this);
        }
        return this.contentOutlinePage;
    }

    @Override
    protected void pageChange(int newPageIndex) {
        IEditorActionBarContributor contributor;
        Control control = this.getControl(newPageIndex);
        if (control != null) {
            control.setVisible(true);
        }
        this.iCurrentPage = newPageIndex;
        IEditorPart activeEditor = this.getEditor(newPageIndex);
        if (activeEditor != null) {
            IWorkbenchPage workbenchPage = UiUtil.getWorkbenchPage();
            if (workbenchPage != null) {
                workbenchPage.getNavigationHistory().markLocation((IEditorPart)this);
            }
            this.getContentOutline().setActiveEditorPage((ModelEditorPage)activeEditor);
            if (this.selectionProvider != null) {
                this.selectionProvider.setSourcePage((ModelEditorPage)activeEditor);
            }
            activeEditor.setFocus();
        }
        if ((contributor = this.getEditorSite().getActionBarContributor()) != null && contributor instanceof ModelEditorActionContributor && activeEditor != null) {
            ((ModelEditorActionContributor)contributor).setActivePage(activeEditor);
        }
    }

    public void displayModelEditorPage(ModelEditorPage mepPageEditor) {
        int i = 0;
        while (i < super.getPageCount()) {
            ModelEditorPage page = (ModelEditorPage)this.getEditor(i);
            if (page == mepPageEditor) {
                this.setActivePage(i);
                break;
            }
            ++i;
        }
    }

    public void notifyChanged(final Notification notification) {
        if (this.modelResource.isOpen()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < ModelEditor.this.getPageCount()) {
                        INotifyChangedListener listener;
                        ModelEditorPage page = (ModelEditorPage)ModelEditor.this.getEditor(i);
                        if (page != null && ModelEditor.this.hasInitialized(page) && (listener = page.getNotifyChangedListener()) != null) {
                            listener.notifyChanged(notification);
                        }
                        ++i;
                    }
                }
            });
            if (!this.resourceDirty && NotificationUtilities.isChanged((Notification)notification)) {
                try {
                    if (this.modelResource.isOpen() && this.modelResource.getEmfResource().isModified()) {
                        this.resourceDirty = true;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ModelEditor.this.dirtyProperty();
                            }
                        });
                    }
                }
                catch (ModelWorkspaceException mwe) {
                    UiConstants.Util.log((Throwable)mwe);
                }
            } else if (notification.getNotifier() instanceof Resource) {
                try {
                    boolean rsrcDirty;
                    if (this.modelResource.isOpen() && (rsrcDirty = this.modelResource.getEmfResource().isModified()) != this.resourceDirty) {
                        this.resourceDirty = rsrcDirty;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ModelEditor.this.dirtyProperty();
                            }
                        });
                    }
                }
                catch (ModelWorkspaceException mwe) {
                    UiConstants.Util.log((Throwable)mwe);
                }
            }
            if (this.getActiveObjectEditor() != null && !this.getActiveObjectEditor().isResourceValid()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ModelEditor.this.closeObjectEditor();
                    }
                });
            }
        }
    }

    void dirtyProperty() {
        this.firePropertyChange(257);
    }

    @Override
    public boolean isResourceDirty() {
        return this.resourceDirty;
    }

    @Override
    public boolean isDirty() {
        if (NEVER_DIRTY || this.isClosing) {
            return false;
        }
        return super.isDirty();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int type = event.getType();
        if (type == 1) {
            try {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            if (delta.getResource().equals((Object)ModelEditor.this.getModelFile()) && (delta.getKind() & 2) != 0) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (Display.getDefault().isDisposed()) {
                                            return;
                                        }
                                        if (UiPlugin.getDefault().getCurrentWorkbenchWindow() != null && UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage() != null) {
                                            UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().closeEditor((IEditorPart)ModelEditor.this, false);
                                        }
                                    }
                                });
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
    }

    public boolean isEditorInputModifiable() {
        IFindReplaceTarget target = (IFindReplaceTarget)this.getAdapter(IFindReplaceTarget.class);
        return target == null ? false : target.isEditable();
    }

    public boolean validateEditorInputState() {
        return true;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        return null;
    }

    @Override
    public IMarker createMarker() {
        NavigationMarker nmMarker = new NavigationMarker();
        IEditorPart iepActiveEditor = this.getActiveEditor();
        nmMarker.setAttribute("markerType", "navigation");
        if (iepActiveEditor != null) {
            if (iepActiveEditor instanceof INavigationLocationProvider && iepActiveEditor instanceof INavigationSupported) {
                nmMarker.setAttribute("delegate", iepActiveEditor);
                nmMarker.setAttribute("delegatesMarker", ((INavigationSupported)iepActiveEditor).createMarker());
            } else {
                nmMarker.setAttribute("tabIndex", this.iCurrentPage);
            }
        }
        return nmMarker;
    }

    public void openComplete() {
        Display display = this.getSite().getWorkbenchWindow().getShell().getDisplay();
        UiBusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < ModelEditor.this.getPageCount()) {
                    ModelEditorPage page = (ModelEditorPage)ModelEditor.this.getEditor(i);
                    if (page != null && ModelEditor.this.hasInitialized(page)) {
                        page.openComplete();
                    }
                    ++i;
                }
            }
        });
    }

    @Override
    public void processInitializationComplete() {
        if (this.nEditorsCompleted < this.completionEditors.size()) {
            ++this.nEditorsCompleted;
            if (this.nEditorsCompleted == this.completionEditors.size()) {
                this.nEditorsCompleted = 0;
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        List allEditors = ModelEditor.this.getAllEditors();
                        for (Object nextEditor : allEditors) {
                            if (!(nextEditor instanceof IInitializationCompleteNotifier)) continue;
                            ((IInitializationCompleteNotifier)nextEditor).removeListener(ModelEditor.this);
                        }
                        if ((ModelEditor.this.resourceDirty || ModelEditor.this.isDirty()) && !ModelEditor.this.isClosing) {
                            NullProgressMonitor monitor = new NullProgressMonitor();
                            ModelEditor.this.doSave((IProgressMonitor)monitor);
                        }
                        if (ModelEditor.this.isClosing) {
                            return;
                        }
                        try {
                            if (UiUtil.getPerspectiveId() != null && UiUtil.getPerspectiveId().equals("modelerPerspective")) {
                                return;
                            }
                            IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
                            String openPerspective = prefStore.getString("autoOpenPerspectiveWhenModelEditorOpened");
                            boolean shouldOpen = false;
                            if ("always".equals(openPerspective)) {
                                shouldOpen = true;
                            } else if (!"never".equals(openPerspective)) {
                                String toggleMsg;
                                String msg;
                                String title;
                                Shell shell = ModelEditor.this.getSite().getShell();
                                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)(title = Util.getString(String.valueOf(PREFIX) + "OpenPerspectiveDialog.title", new Object[0])), (String)(msg = Util.getString(String.valueOf(PREFIX) + "OpenPerspectiveDialog.msg", new Object[0])), (String)(toggleMsg = Util.getString(String.valueOf(PREFIX) + "OpenPerspectiveDialog.toggleMsg", new Object[0])), (boolean)false, (IPreferenceStore)UiPlugin.getDefault().getPreferenceStore(), (String)"autoOpenPerspectiveWhenModelEditorOpened");
                                boolean bl = shouldOpen = dialog.getReturnCode() == 2;
                                if (dialog.getToggleState()) {
                                    UiPlugin.getDefault().getPreferences().flush();
                                }
                            }
                            if (shouldOpen) {
                                UiUtil.openPerspective((String)"modelerPerspective");
                            }
                        }
                        catch (Exception e) {
                            UiConstants.Util.log((Throwable)e);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void setParent(ModelEditor meParentEditor) {
    }

    @Override
    public IInlineRenameable getInlineRenameable(EObject theObj) {
        List allEditors = this.getAllEditors();
        for (Object nextEditor : allEditors) {
            boolean isThisActivePage;
            if (!(nextEditor instanceof IInlineRenameable) || !(nextEditor instanceof EditorPart)) continue;
            boolean bl = isThisActivePage = this.getActiveEditor() == nextEditor;
            if (!isThisActivePage) continue;
            return (IInlineRenameable)nextEditor;
        }
        return null;
    }

    @Override
    public void renameInline(EObject theObj, IInlineRenameable renameable) {
        boolean isThisActivePage;
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        boolean bl = isThisActivePage = window.getActivePage().getActivePart() == renameable;
        if (renameable != null) {
            if (!isThisActivePage) {
                ((IWorkbenchPart)renameable).setFocus();
            }
            renameable.renameInline(theObj, renameable);
        }
    }

    public class ModelDependencyCheck
    implements Runnable {
        public int result;
        public ModelCopyCommand copyCommand;

        public ModelDependencyCheck(ModelCopyCommand copyCommand) {
            this.copyCommand = copyCommand;
        }

        @Override
        public void run() {
            this.result = 0;
            ModelWorkspaceSearch search = new ModelWorkspaceSearch();
            Collection colDependentResources = search.getModelsImportingResources(ModelEditor.this.modelResource.getResource().getFullPath().toString());
            if (!colDependentResources.isEmpty()) {
                Object[] models;
                ArrayList<IFile> fileList = new ArrayList<IFile>(colDependentResources.size());
                Iterator iter = colDependentResources.iterator();
                while (iter.hasNext()) {
                    String pathString = ((ResourceImportRecord)iter.next()).getPath();
                    Path path = new Path(pathString);
                    fileList.add(ModelerCore.getWorkspace().getRoot().getFile((IPath)path));
                }
                ModelLabelProvider labelProvider = new ModelLabelProvider();
                labelProvider.setFullpath(true);
                CheckedListSelectionDialog depDialog = new CheckedListSelectionDialog(ModelEditor.this.getSite().getWorkbenchWindow().getShell(), fileList, (IStructuredContentProvider)new ListContentProvider(), (ILabelProvider)labelProvider, UiConstants.Util.getString("ModelEditor.redirectReferencesMessage", new Object[0]));
                depDialog.setTitle(UiConstants.Util.getString("ModelEditor.redirectReferencesTitle", new Object[0]));
                depDialog.setSelectionStatusValidator(new ISelectionStatusValidator(){
                    private Collection dirtyFiles = ModelEditorManager.getDirtyResources();

                    public IStatus validate(Object[] selection) {
                        int i = 0;
                        while (i < selection.length) {
                            if (ModelUtil.isIResourceReadOnly((IResource)((IFile)selection[i]))) {
                                String name = ((IFile)selection[i]).getName();
                                return new StatusInfo("org.teiid.designer.ui", 4, UiConstants.Util.getString("ModelEditor.redirectReferencesReadOnlyError", (Object)name));
                            }
                            if (this.dirtyFiles.contains(selection[i])) {
                                String name = ((IFile)selection[i]).getName();
                                return new StatusInfo("org.teiid.designer.ui", 4, UiConstants.Util.getString("ModelEditor.redirectReferencesDirtyFileError", (Object)name));
                            }
                            ++i;
                        }
                        return null;
                    }
                });
                this.result = depDialog.open();
                if (this.result == 0 && (models = depDialog.getResult()) != null && models.length > 0) {
                    ArrayList<ModelResource> modelList = new ArrayList<ModelResource>(models.length);
                    int i = 0;
                    while (i < models.length) {
                        IFile file = (IFile)models[i];
                        if (file.exists()) {
                            try {
                                modelList.add(ModelUtil.getModelResource((IFile)file, (boolean)true));
                            }
                            catch (ModelWorkspaceException e) {
                                String message = UiConstants.Util.getString("ModelEditor.modelResourceError", (Object)file.getName());
                                UiConstants.Util.log(4, (Throwable)e, message);
                            }
                        }
                        ++i;
                    }
                    this.copyCommand.setModelsToRedirect(modelList);
                }
            }
        }
    }

    protected class ReloadRequestRunnable
    implements Runnable {
        private boolean reload;

        protected ReloadRequestRunnable() {
        }

        @Override
        public void run() {
            this.reload = MessageDialog.openQuestion((Shell)ModelEditor.this.getSite().getShell(), (String)Util.getString(String.valueOf(PREFIX) + "dialog.fileSystemChange.title", new Object[0]), (String)Util.getString(String.valueOf(PREFIX) + "dialog.fileSystemChange.msg", new Object[]{ModelEditor.this.modelResource.getItemName()}));
        }

        public boolean canReload() {
            return this.reload;
        }
    }
}

