/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.actions.ModelStatisticsReporter;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ShowModelStatisticsAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction {
    private IFile selectedModel;

    public ShowModelStatisticsAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/statistics.gif"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object obj;
        boolean enable = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)obj))) {
            this.selectedModel = (IFile)obj;
            enable = true;
        }
        this.setEnabled(enable);
    }

    public void run() {
        if (this.selectedModel != null) {
            ModelStatisticsReporter reporter = new ModelStatisticsReporter(this.selectedModel);
            reporter.show();
        }
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    @Override
    public boolean isApplicable(ISelection selection) {
        Object obj;
        boolean result = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)obj))) {
            result = true;
        }
        return result;
    }
}

