/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.IPasteSpecialContributor;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.actions.PasteSpecialDescriptor;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PasteSpecialAction
extends ModelObjectAction
implements UiConstants.ExtensionPoints.MetadataPasteSpecialExtension {
    private static List<IPasteSpecialContributor> extensionList;
    private boolean editorIsOpening = false;
    private List<IPasteSpecialContributor> enabledExtensionList;
    private IFile modelFile;
    private EObject selectedEObject;
    private ISelection tempSelection;

    public static List<IPasteSpecialContributor> getPasteSpecialContributors() {
        if (extensionList == null) {
            extensionList = new ArrayList<IPasteSpecialContributor>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "metadataPasteSpecial");
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = extensions.length - 1;
            while (i >= 0) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                Object extension = null;
                int j = 0;
                while (j < elements.length) {
                    try {
                        extension = elements[j].createExecutableExtension("classname");
                        if (extension instanceof IPasteSpecialContributor) {
                            IPasteSpecialContributor action = (IPasteSpecialContributor)extension;
                            String label = elements[j].getAttribute("label");
                            String description = elements[j].getAttribute("description");
                            extensionList.add(new PasteSpecialDescriptor(action, label, description));
                        }
                    }
                    catch (Exception e) {
                        UiConstants.Util.log(4, (Throwable)e, e.getClass().getName());
                    }
                    ++j;
                }
                --i;
            }
        }
        return extensionList;
    }

    public PasteSpecialAction() {
        super(UiPlugin.getDefault());
    }

    private void determineEnablement(IWorkbenchPart thePart, ISelection theSelection) {
        boolean enable = false;
        this.selectedEObject = null;
        this.modelFile = null;
        if (SelectionUtilities.isSingleSelection((ISelection)theSelection) && !PasteSpecialAction.getPasteSpecialContributors().isEmpty()) {
            this.enabledExtensionList = new ArrayList<IPasteSpecialContributor>();
            Object o = SelectionUtilities.getSelectedObject((ISelection)this.getSelection());
            if (o instanceof EObject) {
                this.selectedEObject = (EObject)o;
            } else if (o instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)o))) {
                this.modelFile = (IFile)o;
            }
            if (this.selectedEObject != null || this.modelFile != null) {
                for (IPasteSpecialContributor action : PasteSpecialAction.getPasteSpecialContributors()) {
                    action.selectionChanged(thePart, theSelection);
                    if (!action.canPaste()) continue;
                    enable = true;
                    this.enabledExtensionList.add(action);
                }
                if (!enable) {
                    this.modelFile = null;
                }
            }
        }
        this.setEnabled(enable);
    }

    @Override
    protected void doRun() {
        if (this.enabledExtensionList.size() == 1) {
            this.enabledExtensionList.get(0).run((IAction)this);
        }
    }

    public ISelection getSelection() {
        if (this.editorIsOpening && this.tempSelection != null) {
            return this.tempSelection;
        }
        return super.getSelection();
    }

    @Override
    protected boolean preRun() {
        if (this.requiresEditorForRun()) {
            this.editorIsOpening = true;
            this.tempSelection = this.getSelection();
            if (this.selectedEObject != null) {
                if (!ModelEditorManager.isOpen(this.selectedEObject)) {
                    ModelEditorManager.open(this.selectedEObject, true);
                }
            } else if (this.modelFile != null) {
                ModelEditorManager.activate(this.modelFile, true);
            }
        }
        return true;
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    @Override
    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement(thePart, theSelection);
    }
}

