/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.DisabledCommand;
import org.teiid.designer.core.util.NewModelObjectHelperManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelObjectLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.wizards.NewModelObjectWizardManager;

public class NewChildAction
extends ModelObjectAction {
    private static final String PROBLEM = "NewChildAction.problem";
    private static final String NONE_ALLOWED = UiConstants.Util.getString("NewChildAction.noneAllowed", new Object[0]);
    private static final ModelExplorerLabelProvider diagramProvider = new ModelExplorerLabelProvider();
    private static final ModelObjectLabelProvider provider = (ModelObjectLabelProvider)ModelUtilities.getEMFLabelProvider();
    private Command descriptor;
    private EObject parentObject;
    private Resource parentResource;

    public NewChildAction() {
        super(UiPlugin.getDefault());
        this.configureNoneAllowedState();
    }

    public NewChildAction(EObject parent, Command theDescriptor) {
        super(UiPlugin.getDefault());
        this.parentObject = parent;
        this.parentResource = parent.eResource();
        this.setCommand(theDescriptor);
    }

    public NewChildAction(Resource parent, Command theDescriptor) {
        super(UiPlugin.getDefault());
        this.parentResource = parent;
        this.setCommand(theDescriptor);
    }

    private void configureAllowedState() {
        String label;
        Object result = this.descriptor.getResult().iterator().next();
        Command cmd = this.descriptor;
        if (this.descriptor instanceof DisabledCommand) {
            cmd = ((DisabledCommand)this.descriptor).getDisabledCommand();
        }
        if ((label = cmd.getLabel()) == null || label.length() == 0 || cmd instanceof AddCommand) {
            label = provider.getText(result);
        }
        if (label != null && label.startsWith("New ")) {
            label = label.substring(4);
        }
        this.setText(label);
        if (result instanceof Diagram) {
            this.setImage(diagramProvider.getImage(result));
        } else if (result instanceof EObject) {
            if (this.parentObject != null) {
                this.setImage(provider.getImage((EObject)result, ModelObjectUtilities.isVirtual(this.parentObject)));
            } else if (this.parentResource instanceof EmfResource) {
                boolean isVirtual = ModelType.VIRTUAL_LITERAL.equals(((EmfResource)this.parentResource).getModelAnnotation().getModelType());
                this.setImage(provider.getImage((EObject)result, isVirtual));
            } else {
                this.setImage(provider.getImage(result));
            }
        } else {
            this.setImage(provider.getImage(result));
        }
        this.setToolTipText(cmd.getDescription());
        this.setEnabled(true);
    }

    private void configureNoneAllowedState() {
        this.setText(NONE_ALLOWED);
        this.setEnabled(false);
    }

    @Override
    protected void doRun() {
        block28: {
            if (this.descriptor != null) {
                Shell shell = super.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell();
                ModelResource modelResource = null;
                boolean continuing = true;
                try {
                    modelResource = ModelerCore.getModelEditor().findModelResource(this.parentResource);
                }
                catch (Exception ex) {
                    String msg = this.getPluginUtils().getString(PROBLEM, new Object[]{this.descriptor});
                    this.getPluginUtils().log(4, (Throwable)ex, msg);
                    continuing = false;
                }
                StructuredSelection tempSelection = null;
                if (this.parentObject != null) {
                    tempSelection = new StructuredSelection((Object)this.parentObject);
                } else if (this.parentResource != null) {
                    tempSelection = new StructuredSelection((Object)this.parentResource);
                }
                if (continuing) {
                    ModelUtilities.initializeModelContainers(modelResource, "New Child Added", (Object)this);
                    if (NewModelObjectWizardManager.isObjectDescriptorValid(shell, this.descriptor, modelResource, (ISelection)tempSelection)) {
                        Collection newObjs;
                        boolean result = NewModelObjectWizardManager.processObjectDescriptor(shell, this.descriptor, modelResource, (ISelection)tempSelection);
                        if (result && (newObjs = this.descriptor.getResult()) != null) {
                            newObjs.isEmpty();
                        }
                    } else {
                        boolean started = ModelerCore.startTxn((boolean)true, (String)UiConstants.Util.getString("NewChildAction.undoLabel", (Object)this.descriptor.getLabel()), (Object)((Object)this));
                        boolean succeeded = false;
                        EObject newObj = null;
                        try {
                            try {
                                boolean undoable = true;
                                newObj = this.parentObject != null ? ModelerCore.getModelEditor().createNewChildFromCommand(this.parentObject, this.descriptor) : ModelerCore.getModelEditor().createNewRootObjectFromCommand(this.parentResource, this.descriptor);
                                undoable = NewModelObjectHelperManager.helpCreate((Object)newObj, null);
                                if (!undoable) {
                                    ModelerCore.getCurrentUoW().setUndoable(false);
                                }
                                succeeded = true;
                            }
                            catch (ModelerCoreException theException) {
                                String msg = this.getPluginUtils().getString(PROBLEM, new Object[]{this.descriptor});
                                this.getPluginUtils().log(4, (Throwable)theException, msg);
                                this.setEnabled(false);
                                if (started) {
                                    if (succeeded) {
                                        String newObjName = ModelerCore.getModelEditor().getName(newObj);
                                        if (newObjName != null) {
                                            ModelerCore.getCurrentUoW().setDescription(UiConstants.Util.getString("NewChildAction.undoLabel", (Object)newObjName));
                                        }
                                        ModelerCore.commitTxn();
                                    } else {
                                        ModelerCore.rollbackTxn();
                                    }
                                }
                                break block28;
                            }
                        }
                        catch (Throwable throwable) {
                            if (started) {
                                if (succeeded) {
                                    String newObjName = ModelerCore.getModelEditor().getName(newObj);
                                    if (newObjName != null) {
                                        ModelerCore.getCurrentUoW().setDescription(UiConstants.Util.getString("NewChildAction.undoLabel", (Object)newObjName));
                                    }
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            throw throwable;
                        }
                        if (started) {
                            if (succeeded) {
                                String newObjName = ModelerCore.getModelEditor().getName(newObj);
                                if (newObjName != null) {
                                    ModelerCore.getCurrentUoW().setDescription(UiConstants.Util.getString("NewChildAction.undoLabel", (Object)newObjName));
                                }
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
    }

    @Override
    protected boolean preRun() {
        ModelResource mr;
        if (this.requiresEditorForRun() && (mr = ModelerCore.getModelEditor().findModelResource(this.parentResource)) != null) {
            ModelEditorManager.activate(mr, true, true);
        }
        return true;
    }

    public void setCommand(Command theDescriptor) {
        this.descriptor = theDescriptor;
        if (this.descriptor == null || this.descriptor.getResult().isEmpty()) {
            this.configureNoneAllowedState();
        } else {
            this.configureAllowedState();
            if (this.descriptor instanceof DisabledCommand) {
                super.setEnabled(false);
            }
        }
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    public EObject getParentObject() {
        return this.parentObject;
    }
}

