/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.model.RelationalAccessPattern;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;

public class RelationalTable
extends RelationalReference {
    public static final String KEY_CARDINALITY = "CARDINALITY";
    public static final String KEY_MATERIALIZED = "MATERIALIZED";
    public static final String KEY_MATERIALIZED_TABLE = "MATERIALIZEDTABLE";
    public static final String KEY_SUPPORTS_UPDATE = "SUPPORTSUPDATE";
    public static final String KEY_SYSTEM = "SYSTEM";
    public static final int DEFAULT_CARDINALITY = -1;
    public static final boolean DEFAULT_MATERIALIZED = false;
    public static final String DEFAULT_MATERIALIZED_TABLE = null;
    public static final boolean DEFAULT_SUPPORTS_UPDATE = true;
    public static final boolean DEFAULT_SYSTEM = false;
    public static final String DEFAULT_DATATYPE = "string";
    private int cardinality = -1;
    private boolean materialized = false;
    private RelationalReference materializedTable;
    private boolean supportsUpdate = true;
    private boolean system = false;
    private List<RelationalColumn> columns;
    private RelationalPrimaryKey primaryKey;
    private List<RelationalUniqueConstraint> uniqueConstraints;
    private List<RelationalAccessPattern> accessPatterns;
    private List<RelationalForeignKey> foreignKeys;
    private List<RelationalIndex> indexes;
    private String nativeQuery;

    public RelationalTable() {
        this.setType(3);
        this.init();
    }

    public RelationalTable(String name) {
        super(name);
        this.setType(3);
        this.init();
    }

    private void init() {
        this.columns = new ArrayList<RelationalColumn>();
        this.accessPatterns = new ArrayList<RelationalAccessPattern>();
        this.foreignKeys = new ArrayList<RelationalForeignKey>();
        this.indexes = new ArrayList<RelationalIndex>();
        this.uniqueConstraints = new ArrayList<RelationalUniqueConstraint>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(true));
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        if (this.cardinality != cardinality) {
            this.cardinality = cardinality;
            this.handleInfoChanged();
        }
    }

    public boolean isMaterialized() {
        return this.materialized;
    }

    public void setMaterialized(boolean materialized) {
        if (this.materialized != materialized) {
            this.materialized = materialized;
            this.handleInfoChanged();
        }
    }

    public RelationalReference getMaterializedTable() {
        return this.materializedTable;
    }

    public void setMaterializedTable(RelationalReference materializedTable) {
        if (this.materializedTable != materializedTable) {
            this.materializedTable = materializedTable;
            this.handleInfoChanged();
        }
    }

    public boolean getSupportsUpdate() {
        return this.supportsUpdate;
    }

    public void setSupportsUpdate(boolean supportsUpdate) {
        if (this.supportsUpdate != supportsUpdate) {
            this.supportsUpdate = supportsUpdate;
            this.handleInfoChanged();
        }
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean system) {
        if (this.system != system) {
            this.system = system;
            this.handleInfoChanged();
        }
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String newQuery) {
        if (StringUtilities.areDifferent((String)this.nativeQuery, (String)newQuery)) {
            this.nativeQuery = newQuery;
            this.handleInfoChanged();
        }
    }

    public List<RelationalColumn> getColumns() {
        return this.columns;
    }

    public void addColumn(RelationalColumn column) {
        if (this.columns.add(column)) {
            column.setParent(this);
            this.handleInfoChanged();
        }
    }

    public boolean removeColumn(RelationalColumn column) {
        if (this.columns.remove(column)) {
            this.handleInfoChanged();
            return true;
        }
        return false;
    }

    public RelationalPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(RelationalPrimaryKey pk) {
        if (this.primaryKey != pk) {
            if (pk != null) {
                pk.setParent(this);
            }
            this.primaryKey = pk;
            this.handleInfoChanged();
        }
    }

    public RelationalUniqueConstraint getUniqueContraint() {
        if (this.getUniqueConstraints() == null || this.getUniqueConstraints().isEmpty()) {
            return null;
        }
        return this.getUniqueConstraints().iterator().next();
    }

    public void setUniqueConstraint(RelationalUniqueConstraint uc) {
        if (this.uniqueConstraints != null) {
            this.uniqueConstraints.clear();
        }
        this.addUniqueConstraint(uc);
    }

    public Collection<RelationalUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public void addUniqueConstraint(RelationalUniqueConstraint constraint) {
        if (this.uniqueConstraints.add(constraint)) {
            constraint.setParent(this);
            this.handleInfoChanged();
        }
    }

    public boolean removeUniqueConstraint(RelationalUniqueConstraint constraint) {
        if (this.uniqueConstraints.remove(constraint)) {
            this.handleInfoChanged();
            return true;
        }
        return false;
    }

    public List<RelationalAccessPattern> getAccessPatterns() {
        return this.accessPatterns;
    }

    public void addAccessPattern(RelationalAccessPattern ap) {
        if (this.accessPatterns.add(ap)) {
            ap.setParent(this);
            this.handleInfoChanged();
        }
    }

    public boolean removeAccessPattern(RelationalAccessPattern ap) {
        if (this.accessPatterns.remove(ap)) {
            this.handleInfoChanged();
            return true;
        }
        return false;
    }

    public List<RelationalForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public void addForeignKey(RelationalForeignKey fk) {
        if (this.foreignKeys.add(fk)) {
            fk.setParent(this);
            this.handleInfoChanged();
        }
    }

    public boolean removeForeignKey(RelationalForeignKey fk) {
        if (this.foreignKeys.remove(fk)) {
            this.handleInfoChanged();
            return true;
        }
        return false;
    }

    public List<RelationalIndex> getIndexes() {
        return this.indexes;
    }

    public void addIndex(RelationalIndex index) {
        if (this.indexes.add(index)) {
            index.setParent(this.getParent());
            this.handleInfoChanged();
        }
    }

    public boolean removeIndex(RelationalIndex index) {
        if (this.indexes.remove(index)) {
            this.handleInfoChanged();
            return true;
        }
        return false;
    }

    public void setProperties(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            String value = props.getProperty(keyStr);
            if (value != null && value.length() == 0) continue;
            if (keyStr.equalsIgnoreCase("NAME")) {
                this.setName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NAMEINSOURCE")) {
                this.setNameInSource(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_CARDINALITY)) {
                this.setCardinality(Integer.parseInt(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_MATERIALIZED)) {
                this.setMaterialized(Boolean.parseBoolean(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_SUPPORTS_UPDATE)) {
                this.setSupportsUpdate(Boolean.parseBoolean(value));
                continue;
            }
            if (!keyStr.equalsIgnoreCase(KEY_SYSTEM)) continue;
            this.setSystem(Boolean.parseBoolean(value));
        }
    }

    public RelationalColumn createColumn() {
        return this.createColumn(DEFAULT_DATATYPE, 4000);
    }

    public RelationalColumn createColumn(String datatype, int length) {
        return this.createColumn("newColumn_" + (this.getColumns().size() + 1), datatype, length);
    }

    public RelationalColumn createColumn(String name, String datatype, int length) {
        RelationalColumn newColumn = new RelationalColumn(name);
        newColumn.setDatatype(datatype);
        newColumn.setLength(length);
        this.addColumn(newColumn);
        return newColumn;
    }

    public boolean canMoveColumnUp(RelationalColumn column) {
        return this.getColumnIndex(column) > 0;
    }

    public boolean canMoveColumnDown(RelationalColumn column) {
        return this.getColumnIndex(column) < this.getColumns().size() - 1;
    }

    private int getColumnIndex(RelationalColumn column) {
        int i = 0;
        for (RelationalColumn existingColumn : this.getColumns()) {
            if (existingColumn == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void moveColumnUp(RelationalColumn theColumn) {
        int startIndex = this.getColumnIndex(theColumn);
        if (startIndex > 0) {
            RelationalColumn[] existingColumns = this.getColumns().toArray(new RelationalColumn[0]);
            RelationalColumn priorColumn = existingColumns[startIndex - 1];
            existingColumns[startIndex - 1] = theColumn;
            existingColumns[startIndex] = priorColumn;
            ArrayList<RelationalColumn> newColumns = new ArrayList<RelationalColumn>(existingColumns.length);
            RelationalColumn[] relationalColumnArray = existingColumns;
            int n = existingColumns.length;
            int n2 = 0;
            while (n2 < n) {
                RelationalColumn info = relationalColumnArray[n2];
                newColumns.add(info);
                ++n2;
            }
            this.columns = newColumns;
        }
    }

    public void moveColumnDown(RelationalColumn theColumn) {
        int startIndex = this.getColumnIndex(theColumn);
        if (startIndex < this.getColumns().size() - 1) {
            RelationalColumn[] existingColumns = this.getColumns().toArray(new RelationalColumn[0]);
            RelationalColumn afterColumn = existingColumns[startIndex + 1];
            existingColumns[startIndex + 1] = theColumn;
            existingColumns[startIndex] = afterColumn;
            ArrayList<RelationalColumn> newColumns = new ArrayList<RelationalColumn>(existingColumns.length);
            RelationalColumn[] relationalColumnArray = existingColumns;
            int n = existingColumns.length;
            int n2 = 0;
            while (n2 < n) {
                RelationalColumn info = relationalColumnArray[n2];
                newColumns.add(info);
                ++n2;
            }
            this.columns = newColumns;
        }
    }

    @Override
    public void handleInfoChanged() {
        super.handleInfoChanged();
        if (this.nativeQuery != null) {
            this.getExtensionProperties().put("native-query", this.nativeQuery);
        } else {
            this.getExtensionProperties().remove("native-query");
        }
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getStatus().getSeverity() == 4) {
            return;
        }
        if (this.isMaterialized() && this.materializedTable == null) {
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.relational", Messages.validate_error_materializedTableHasNoTableDefined));
            return;
        }
        if (this.getPrimaryKey() != null && !this.getPrimaryKey().getStatus().isOK()) {
            this.setStatus(this.getPrimaryKey().getStatus());
            return;
        }
        if (this.getUniqueConstraints() != null) {
            for (RelationalUniqueConstraint uniqueConstraint : this.getUniqueConstraints()) {
                if (uniqueConstraint == null || uniqueConstraint.getStatus().isOK()) continue;
                this.setStatus(uniqueConstraint.getStatus());
                return;
            }
        }
        for (RelationalForeignKey fk : this.getForeignKeys()) {
            if (fk.getStatus().isOK()) continue;
            this.setStatus(fk.getStatus());
            return;
        }
        for (RelationalColumn col : this.getColumns()) {
            if (col.getStatus().getSeverity() != 4) continue;
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", col.getStatus().getMessage()));
            return;
        }
        for (RelationalColumn outerColumn : this.getColumns()) {
            for (RelationalColumn innerColumn : this.getColumns()) {
                if (outerColumn == innerColumn || !outerColumn.getName().equalsIgnoreCase(innerColumn.getName())) continue;
                this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", NLS.bind((String)Messages.validate_error_duplicateColumnNamesInTable, (Object)this.getName())));
                return;
            }
        }
        if (this.getColumns().isEmpty()) {
            if (this.getParent() != null && this.getParent() instanceof RelationalProcedure) {
                this.setStatus((IStatus)new Status(2, "org.teiid.designer.relational", Messages.validate_warning_noColumnsDefinedForResultSet));
                return;
            }
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.relational", Messages.validate_warning_noColumnsDefined));
            return;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalTable other = (RelationalTable)object;
        if (!CoreStringUtil.valuesAreEqual((String)this.getNativeQuery(), (String)other.getNativeQuery())) {
            return false;
        }
        if (this.getCardinality() != other.getCardinality() || this.getSupportsUpdate() != other.getSupportsUpdate() || this.isMaterialized() != other.isMaterialized() || this.isSystem() != other.isSystem()) {
            return false;
        }
        if (this.materializedTable == null ? other.materializedTable != null : !this.materializedTable.equals(other.materializedTable)) {
            return false;
        }
        if (this.uniqueConstraints == null ? other.uniqueConstraints != null : !this.uniqueConstraints.equals(other.uniqueConstraints)) {
            return false;
        }
        if (this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey)) {
            return false;
        }
        List<RelationalColumn> thisColumns = this.getColumns();
        List<RelationalColumn> thatColumns = other.getColumns();
        if (thisColumns.size() != thatColumns.size()) {
            return false;
        }
        if (!thisColumns.isEmpty() && !thisColumns.equals(thatColumns)) {
            return false;
        }
        List<RelationalForeignKey> thisFKs = this.getForeignKeys();
        List<RelationalForeignKey> thatFKs = other.getForeignKeys();
        if (thisFKs.size() != thatFKs.size()) {
            return false;
        }
        if (thisFKs.size() == 1) {
            if (!thisFKs.get(0).equals(thatFKs.get(0))) {
                return false;
            }
        } else if (thisFKs.size() > 1) {
            RelationalReference.ReferenceComparator comparator = new RelationalReference.ReferenceComparator(this);
            ArrayList<RelationalForeignKey> sortedThisFKs = new ArrayList<RelationalForeignKey>(this.getForeignKeys());
            ArrayList<RelationalForeignKey> sortedThatFKs = new ArrayList<RelationalForeignKey>(other.getForeignKeys());
            Collections.sort(sortedThisFKs, comparator);
            Collections.sort(sortedThatFKs, comparator);
            if (!sortedThisFKs.equals(sortedThatFKs)) {
                return false;
            }
        }
        List<RelationalIndex> thisIndexes = this.getIndexes();
        List<RelationalIndex> thatIndexes = other.getIndexes();
        if (thisIndexes.size() != thatIndexes.size()) {
            return false;
        }
        if (!thisIndexes.isEmpty() && !thisIndexes.equals(thatIndexes)) {
            return false;
        }
        List<RelationalAccessPattern> thisAPs = this.getAccessPatterns();
        List<RelationalAccessPattern> thatAPs = other.getAccessPatterns();
        if (thisAPs.size() != thatAPs.size()) {
            return false;
        }
        return thisAPs.isEmpty() || thisAPs.equals(thatAPs);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (!CoreStringUtil.isEmpty((String)this.getNativeQuery())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getNativeQuery()});
        }
        result = HashCodeUtil.hashCode((int)result, (int)this.getCardinality());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.getSupportsUpdate());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isMaterialized());
        result = HashCodeUtil.hashCode((int)result, (boolean)this.isSystem());
        if (this.materializedTable != null) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.materializedTable});
        }
        if (this.uniqueConstraints != null) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.uniqueConstraints});
        }
        if (this.primaryKey != null) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.primaryKey});
        }
        List<RelationalColumn> cols = this.getColumns();
        for (RelationalColumn col : cols) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{col});
        }
        List<RelationalForeignKey> fks = this.getForeignKeys();
        for (RelationalForeignKey fk : fks) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{fk});
        }
        List<RelationalIndex> indexes = this.getIndexes();
        for (RelationalIndex index : indexes) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{index});
        }
        List<RelationalAccessPattern> aps = this.getAccessPatterns();
        for (RelationalAccessPattern ap : aps) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{ap});
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" : name = ").append(this.getName());
        if (!this.getColumns().isEmpty()) {
            sb.append("\n\t").append(this.getColumns().size()).append(" columns");
            for (RelationalColumn col : this.getColumns()) {
                sb.append("\n\tcol = ").append(col);
            }
        }
        if (this.primaryKey != null) {
            sb.append("\n\t").append("PK = ").append(this.primaryKey);
        }
        if (this.uniqueConstraints != null) {
            sb.append("\n\t").append("UC = ").append(this.uniqueConstraints);
        }
        if (!this.getAccessPatterns().isEmpty()) {
            sb.append("\n\t").append(this.getAccessPatterns().size()).append(" access patterns");
            for (RelationalAccessPattern ap : this.getAccessPatterns()) {
                sb.append("\n\tap = ").append(ap);
            }
        }
        return sb.toString();
    }
}

