/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.ModelExtensionAssistantAggregator;
import org.teiid.designer.metamodels.relational.AccessPattern;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.SearchabilityType;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.RelationalPlugin;
import org.teiid.designer.relational.model.RelationalAccessPattern;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalSchema;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.relational.model.RelationalView;
import org.teiid.designer.relational.model.RelationalViewProcedure;
import org.teiid.designer.relational.model.RelationalViewTable;

public class RelationalReferenceFactory
implements RelationalConstants {
    public static RelationalReferenceFactory INSTANCE = new RelationalReferenceFactory();
    private ModelExtensionAssistantAggregator medAggregator = ExtensionPlugin.getInstance().getModelExtensionAssistantAggregator();
    private ModelEditor modelEditor = ModelerCore.getModelEditor();

    public RelationalModel createRelationalModel(ModelResource modelResource) throws Exception {
        String modelName = this.modelEditor.getModelName(modelResource);
        RelationalModel relationalModel = new RelationalModel(modelName);
        HashMap<EObject, RelationalReference> deferredCreateMap = new HashMap<EObject, RelationalReference>();
        List rootEObjs = modelResource.getAllRootEObjects();
        for (EObject eObj : rootEObjs) {
            Map<EObject, RelationalReference> deferredObjMap = this.createObject(eObj, null, relationalModel);
            if (deferredObjMap.isEmpty()) continue;
            deferredCreateMap.putAll(deferredObjMap);
        }
        this.createDeferredObjects(deferredCreateMap, relationalModel);
        return relationalModel;
    }

    protected Map<EObject, RelationalReference> createObject(EObject eObj, RelationalReference parent, RelationalModel model) throws Exception {
        HashMap<EObject, RelationalReference> deferredMap = new HashMap<EObject, RelationalReference>();
        if (eObj instanceof BaseTable) {
            BaseTable tableEObj = (BaseTable)eObj;
            RelationalTable table = this.createBaseTable(tableEObj);
            EList fks = tableEObj.getForeignKeys();
            for (ForeignKey fk : fks) {
                deferredMap.put((EObject)fk, table);
            }
            EList aps = tableEObj.getAccessPatterns();
            for (AccessPattern ap : aps) {
                deferredMap.put((EObject)ap, table);
            }
            PrimaryKey pk = tableEObj.getPrimaryKey();
            if (pk != null) {
                deferredMap.put((EObject)pk, table);
            }
            if (parent != null) {
                table.setParent(parent);
            } else {
                model.addChild(table);
            }
        } else if (eObj instanceof Procedure) {
            Procedure procEObj = (Procedure)eObj;
            RelationalProcedure proc = this.createProcedure(procEObj);
            if (parent != null) {
                proc.setParent(parent);
            } else {
                model.addChild(proc);
            }
        } else if (eObj instanceof Index) {
            Index indexEObj = (Index)eObj;
            deferredMap.put((EObject)indexEObj, (RelationalReference)null);
        } else if (eObj instanceof View) {
            View viewEObj = (View)eObj;
            RelationalView view = this.createView(viewEObj);
            EList aps = viewEObj.getAccessPatterns();
            for (AccessPattern ap : aps) {
                deferredMap.put((EObject)ap, view);
            }
            if (parent != null) {
                view.setParent(parent);
            } else {
                model.addChild(view);
            }
        } else {
            boolean cfr_ignored_0 = eObj instanceof Catalog;
        }
        return deferredMap;
    }

    protected void createDeferredObjects(Map<EObject, RelationalReference> deferredObjects, RelationalModel model) throws Exception {
        Collection<RelationalReference> allRefs = model.getAllReferences();
        Set<EObject> eObjs = deferredObjects.keySet();
        for (EObject eObj : eObjs) {
            RelationalTable table;
            if (eObj instanceof PrimaryKey) {
                table = (RelationalTable)deferredObjects.get(eObj);
                RelationalPrimaryKey pk = this.createPrimaryKey((PrimaryKey)eObj, table, allRefs);
                table.setPrimaryKey(pk);
                continue;
            }
            if (eObj instanceof ForeignKey) {
                table = (RelationalTable)deferredObjects.get(eObj);
                RelationalForeignKey fk = this.createForeignKey((ForeignKey)eObj, table, allRefs);
                table.addForeignKey(fk);
                continue;
            }
            if (eObj instanceof AccessPattern) {
                table = (RelationalTable)deferredObjects.get(eObj);
                RelationalAccessPattern ap = this.createAccessPattern((AccessPattern)eObj, table, allRefs);
                table.addAccessPattern(ap);
                continue;
            }
            if (!(eObj instanceof Index)) continue;
            RelationalIndex index = this.createIndex((Index)eObj, allRefs);
            model.addChild(index);
        }
    }

    public RelationalTable createBaseTable(BaseTable tableEObj) {
        RelationalTable table = new RelationalTable();
        table.setName(tableEObj.getName());
        table.setNameInSource(tableEObj.getNameInSource());
        this.setDescription(table, (EObject)tableEObj);
        table.setMaterialized(tableEObj.isMaterialized());
        table.setCardinality(tableEObj.getCardinality());
        table.setSupportsUpdate(tableEObj.isSupportsUpdate());
        table.setSystem(tableEObj.isSystem());
        EList columns = tableEObj.getColumns();
        for (Column column : columns) {
            RelationalColumn relColumn = this.createColumn(column);
            if (relColumn == null) continue;
            table.addColumn(relColumn);
        }
        this.setExtensionProperties(table, (EObject)tableEObj);
        return table;
    }

    private void setDescription(RelationalReference relationalRef, EObject eObject) {
        try {
            String desc = this.modelEditor.getDescription(eObject);
            relationalRef.setDescription(desc);
        }
        catch (ModelerCoreException modelerCoreException) {
            RelationalPlugin.Util.log(4, NLS.bind((String)Messages.relationalRefFactory_errorSettingDescription, (Object)relationalRef.getName()));
            relationalRef.setDescription(null);
        }
    }

    private void setExtensionProperties(RelationalReference relationalRef, EObject eObj) {
        Properties extProps = null;
        try {
            extProps = this.medAggregator.getPropertyValues((Object)eObj);
        }
        catch (Exception exception) {
            RelationalPlugin.Util.log(4, NLS.bind((String)Messages.relationalRefFactory_errorGettingEmfExtProps, (Object)relationalRef.getName()));
        }
        relationalRef.setExtensionProperties(extProps);
    }

    public RelationalIndex createIndex(Index indexEObj, Collection<RelationalReference> allRefs) {
        RelationalIndex index = new RelationalIndex();
        index.setName(indexEObj.getName());
        index.setNameInSource(indexEObj.getNameInSource());
        this.setDescription(index, (EObject)indexEObj);
        index.setFilterCondition(indexEObj.getFilterCondition());
        EList columns = indexEObj.getColumns();
        for (Column column : columns) {
            RelationalColumn relColumn = this.find(RelationalColumn.class, (EObject)column, null, allRefs);
            if (relColumn == null) {
                RelationalPlugin.Util.log(2, NLS.bind((String)Messages.relationalRefFactory_columnNotFound_forIndexCreate, (Object)column.getName()));
                continue;
            }
            relColumn.setParent(index);
            index.addColumn(relColumn);
        }
        this.setExtensionProperties(index, (EObject)indexEObj);
        return index;
    }

    public RelationalView createView(View viewEObj) {
        RelationalView view = new RelationalView();
        view.setName(viewEObj.getName());
        view.setNameInSource(viewEObj.getNameInSource());
        this.setDescription(view, (EObject)viewEObj);
        view.setMaterialized(viewEObj.isMaterialized());
        view.setCardinality(viewEObj.getCardinality());
        view.setSupportsUpdate(viewEObj.isSupportsUpdate());
        view.setSystem(viewEObj.isSystem());
        EList columns = viewEObj.getColumns();
        for (Column column : columns) {
            RelationalColumn relColumn = this.createColumn(column);
            view.addColumn(relColumn);
        }
        this.setExtensionProperties(view, (EObject)viewEObj);
        return view;
    }

    public RelationalColumn createColumn(Column columnEObj) {
        RelationalColumn relCol = new RelationalColumn();
        relCol.setName(columnEObj.getName());
        relCol.setNameInSource(columnEObj.getNameInSource());
        this.setDescription(relCol, (EObject)columnEObj);
        relCol.setDefaultValue(columnEObj.getDefaultValue());
        relCol.setCharacterSetName(columnEObj.getCharacterSetName());
        relCol.setDistinctValueCount(columnEObj.getDistinctValueCount());
        relCol.setLength(columnEObj.getLength());
        relCol.setNativeType(columnEObj.getNativeType());
        relCol.setMaximumValue(columnEObj.getMaximumValue());
        relCol.setMinimumValue(columnEObj.getMinimumValue());
        relCol.setPrecision(columnEObj.getPrecision());
        relCol.setRadix(columnEObj.getRadix());
        relCol.setScale(columnEObj.getScale());
        relCol.setAutoIncremented(columnEObj.isAutoIncremented());
        relCol.setCaseSensitive(columnEObj.isCaseSensitive());
        relCol.setCurrency(columnEObj.isCurrency());
        relCol.setLengthFixed(columnEObj.isFixedLength());
        relCol.setSelectable(columnEObj.isSelectable());
        relCol.setSigned(columnEObj.isSigned());
        relCol.setUpdateable(columnEObj.isUpdateable());
        NullableType nullType = columnEObj.getNullable();
        relCol.setNullable(nullType.getLiteral());
        SearchabilityType searchabilityType = columnEObj.getSearchability();
        relCol.setSearchability(searchabilityType.getLiteral());
        String dTypeName = this.modelEditor.getName(columnEObj.getType());
        relCol.setDatatype(dTypeName);
        this.setExtensionProperties(relCol, (EObject)columnEObj);
        return relCol;
    }

    public RelationalForeignKey createForeignKey(ForeignKey fk, RelationalTable table, Collection<RelationalReference> allRefs) {
        RelationalForeignKey relFK = new RelationalForeignKey();
        relFK.setName(fk.getName());
        relFK.setNameInSource(fk.getNameInSource());
        this.setDescription(relFK, (EObject)fk);
        EList columns = fk.getColumns();
        for (Column column : columns) {
            RelationalColumn relColumn = this.find(RelationalColumn.class, (EObject)column, table, allRefs);
            if (relColumn == null) {
                RelationalPlugin.Util.log(2, NLS.bind((String)Messages.relationalRefFactory_columnNotFound_forFKCreate, (Object)column.getName()));
                continue;
            }
            relFK.addColumn(relColumn);
        }
        UniqueKey uniqueKey = fk.getUniqueKey();
        if (uniqueKey != null) {
            String uniqueKeyTableName;
            BaseTable uniqueKeyTable;
            String uniqueKeyName = uniqueKey.getName();
            if (uniqueKeyName != null) {
                relFK.setUniqueKeyName(uniqueKeyName);
            }
            if ((uniqueKeyTable = uniqueKey.getTable()) != null && (uniqueKeyTableName = uniqueKeyTable.getName()) != null) {
                relFK.setUniqueKeyTableName(uniqueKeyTableName);
            }
        }
        this.setExtensionProperties(relFK, (EObject)fk);
        return relFK;
    }

    public RelationalPrimaryKey createPrimaryKey(PrimaryKey pk, RelationalTable table, Collection<RelationalReference> allRefs) {
        RelationalPrimaryKey relPK = new RelationalPrimaryKey();
        relPK.setName(pk.getName());
        relPK.setNameInSource(pk.getNameInSource());
        this.setDescription(relPK, (EObject)pk);
        EList columns = pk.getColumns();
        for (Column column : columns) {
            RelationalColumn relColumn = this.find(RelationalColumn.class, (EObject)column, table, allRefs);
            if (relColumn == null) {
                RelationalPlugin.Util.log(2, NLS.bind((String)Messages.relationalRefFactory_columnNotFound_forPKCreate, (Object)column.getName()));
                continue;
            }
            relPK.addColumn(relColumn);
        }
        this.setExtensionProperties(relPK, (EObject)pk);
        return relPK;
    }

    public RelationalAccessPattern createAccessPattern(AccessPattern ap, RelationalTable table, Collection<RelationalReference> allRefs) {
        RelationalAccessPattern relAP = new RelationalAccessPattern();
        relAP.setName(ap.getName());
        relAP.setNameInSource(ap.getNameInSource());
        this.setDescription(relAP, (EObject)ap);
        EList columns = ap.getColumns();
        for (Column column : columns) {
            RelationalColumn relColumn = this.find(RelationalColumn.class, (EObject)column, table, allRefs);
            if (relColumn == null) {
                RelationalPlugin.Util.log(2, NLS.bind((String)Messages.relationalRefFactory_columnNotFound_forAPCreate, (Object)column.getName()));
                continue;
            }
            relAP.addColumn(relColumn);
        }
        this.setExtensionProperties(relAP, (EObject)ap);
        return relAP;
    }

    public RelationalProcedure createProcedure(Procedure procEObj) {
        RelationalProcedureResultSet relProcResult;
        RelationalProcedure proc = new RelationalProcedure();
        proc.setName(procEObj.getName());
        proc.setNameInSource(procEObj.getNameInSource());
        this.setDescription(proc, (EObject)procEObj);
        ProcedureResult procResult = procEObj.getResult();
        if (procResult != null && (relProcResult = this.createProcedureResultSet(procResult)) != null) {
            proc.setResultSet(relProcResult);
        }
        EList params = procEObj.getParameters();
        for (ProcedureParameter param : params) {
            RelationalParameter relProcParam = this.createProcedureParameter(param);
            proc.addParameter(relProcParam);
        }
        this.setExtensionProperties(proc, (EObject)procEObj);
        return proc;
    }

    public RelationalProcedureResultSet createProcedureResultSet(ProcedureResult procResultSetEObj) {
        RelationalProcedureResultSet relResultSet = new RelationalProcedureResultSet();
        relResultSet.setName(procResultSetEObj.getName());
        relResultSet.setNameInSource(procResultSetEObj.getNameInSource());
        this.setDescription(relResultSet, (EObject)procResultSetEObj);
        EList columns = procResultSetEObj.getColumns();
        for (Column column : columns) {
            RelationalColumn relColumn = this.createColumn(column);
            if (relColumn == null) continue;
            relResultSet.addColumn(relColumn);
        }
        this.setExtensionProperties(relResultSet, (EObject)procResultSetEObj);
        return relResultSet;
    }

    public RelationalParameter createProcedureParameter(ProcedureParameter procParamEObj) {
        RelationalParameter relParam = new RelationalParameter();
        relParam.setName(procParamEObj.getName());
        relParam.setNameInSource(procParamEObj.getNameInSource());
        this.setDescription(relParam, (EObject)procParamEObj);
        relParam.setDirection(this.getDirectionKindStr(procParamEObj.getDirection()));
        relParam.setDefaultValue(procParamEObj.getDefaultValue());
        relParam.setLength(procParamEObj.getLength());
        relParam.setNativeType(procParamEObj.getNativeType());
        relParam.setNullable(this.getNullableTypeStr(procParamEObj.getNullable()));
        relParam.setPrecision(procParamEObj.getPrecision());
        relParam.setRadix(procParamEObj.getRadix());
        relParam.setScale(procParamEObj.getScale());
        String dTypeName = ModelerCore.getModelEditor().getName(procParamEObj.getType());
        relParam.setDatatype(dTypeName);
        this.setExtensionProperties(relParam, (EObject)procParamEObj);
        return relParam;
    }

    private String getDirectionKindStr(DirectionKind dir) {
        if (dir == DirectionKind.IN_LITERAL) {
            return "IN";
        }
        if (dir == DirectionKind.INOUT_LITERAL) {
            return "IN_OUT";
        }
        if (dir == DirectionKind.OUT_LITERAL) {
            return "OUT";
        }
        if (dir == DirectionKind.RETURN_LITERAL) {
            return "RETURN";
        }
        return "UNKNOWN";
    }

    private String getNullableTypeStr(NullableType nType) {
        if (nType == NullableType.NULLABLE_LITERAL) {
            return "NULLABLE";
        }
        if (nType == NullableType.NO_NULLS_LITERAL) {
            return "NO_NULLS";
        }
        return "NULLABLE_UNKNOWN";
    }

    protected <T extends RelationalReference> T find(Class<T> type, String name, EObject node, RelationalReference parent, Collection<RelationalReference> allModelRefs) {
        for (RelationalReference obj : allModelRefs) {
            RelationalReference relEntity;
            if (!type.isInstance(obj) || !(relEntity = obj).getName().equalsIgnoreCase(name)) continue;
            RelationalReference relParent = relEntity.getParent();
            if (parent != null) {
                if (!relParent.getName().equalsIgnoreCase(parent.getName())) continue;
                return (T)relEntity;
            }
            return (T)relEntity;
        }
        return null;
    }

    protected <T extends RelationalReference> T find(Class<T> type, EObject eObj, RelationalReference parent, Collection<RelationalReference> allModelRefs) {
        return this.find(type, this.modelEditor.getName(eObj), eObj, parent, allModelRefs);
    }

    public RelationalModel createModel(String modelName) {
        return new RelationalModel(modelName);
    }

    public RelationalSchema createSchema() {
        return new RelationalSchema();
    }

    public RelationalTable createBaseTable() {
        return new RelationalTable();
    }

    public RelationalTable createBaseTable(String name) {
        return new RelationalTable(name);
    }

    public RelationalView createView() {
        return new RelationalView();
    }

    public RelationalView createView(String name) {
        return new RelationalView(name);
    }

    public RelationalColumn createColumn() {
        return new RelationalColumn();
    }

    public RelationalAccessPattern createAccessPattern() {
        return new RelationalAccessPattern();
    }

    public RelationalForeignKey createForeignKey() {
        return new RelationalForeignKey();
    }

    public RelationalIndex createIndex() {
        return new RelationalIndex();
    }

    public RelationalParameter createParameter() {
        return new RelationalParameter();
    }

    public RelationalPrimaryKey createPrimaryKey() {
        return new RelationalPrimaryKey();
    }

    public RelationalProcedure createProcedure() {
        return new RelationalProcedure();
    }

    public RelationalProcedureResultSet createProcedureResultSet() {
        return new RelationalProcedureResultSet();
    }

    public RelationalUniqueConstraint createUniqueConstraint() {
        return new RelationalUniqueConstraint();
    }

    public RelationalViewTable createViewTable() {
        return new RelationalViewTable();
    }

    public RelationalViewProcedure createViewProcedure() {
        return new RelationalViewProcedure();
    }
}

