/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.io.File;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.jboss.tools.test.util.JobUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XPathModelTest
extends TestCase {
    public static int serverCount = 0;
    private String serverType;

    static {
        JobUtils.waitForIdle((long)5000L);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParamterers());
    }

    @Before
    public void setUp() {
        JobUtils.waitForIdle();
    }

    public XPathModelTest(String serverType) {
        this.serverType = serverType;
    }

    @After
    public void tearDown() throws Exception {
        try {
            ASMatrixTests.cleanup();
        }
        catch (Exception exception) {}
    }

    @Test
    public void serverTestImpl() {
        IServer server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, "server" + ++serverCount);
        File xpathFile = JBossServerCorePlugin.getServerStateLocation((IServer)server).append("xpaths.xml").toFile();
        int i = 0;
        boolean found = false;
        while (!found && i < 10) {
            ++i;
            JobUtils.waitForIdle((long)500L);
            found = xpathFile.exists();
        }
        if (!found) {
            XPathModelTest.fail((String)"The XPath File has not been created. Xpaths will be lost on workspace restart");
        }
    }
}

