/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.launch;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.ide.eclipse.as.core.server.internal.AbstractDeploymentScannerAdditions;
import org.jboss.ide.eclipse.as.core.server.internal.JMXServerDeploymentScannerAdditions;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7DeploymentScannerAdditions;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeploymentScannerAdditionsTest
extends TestCase {
    private String serverType;
    private static int projNum = 0;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParameters());
    }

    public DeploymentScannerAdditionsTest(String serverType) {
        this.serverType = serverType;
    }

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Test
    public void testMetadata() {
        try {
            IServer s = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, this.serverType);
            IServerWorkingCopy wc = s.createWorkingCopy();
            wc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "metadata");
            s = wc.save(true, null);
            String[] folders = this.getAdditions().getDeployLocationFolders(s);
            DeploymentScannerAdditionsTest.assertEquals((int)1, (int)folders.length);
            DeploymentScannerAdditionsTest.assertTrue((boolean)folders[0].contains("metadata"));
        }
        catch (CoreException coreException) {
            DeploymentScannerAdditionsTest.fail((String)"Unable to save changes to server");
        }
    }

    @Test
    public void testCustom() {
        try {
            IServer s = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, this.serverType);
            IServerWorkingCopy wc = s.createWorkingCopy();
            wc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "custom");
            wc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", "/home/user/test");
            s = wc.save(true, null);
            String[] folders = this.getAdditions().getDeployLocationFolders(s);
            DeploymentScannerAdditionsTest.assertEquals((int)1, (int)folders.length);
            DeploymentScannerAdditionsTest.assertTrue((boolean)folders[0].equals("/home/user/test"));
        }
        catch (CoreException coreException) {
            DeploymentScannerAdditionsTest.fail((String)"Unable to save changes to server");
        }
    }

    @Test
    public void testMetadataWithCustomModule() {
        try {
            IServer s = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, this.serverType);
            IServerWorkingCopy wc = s.createWorkingCopy();
            wc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "metadata");
            s = wc.save(true, null);
            String projName = "Project" + ++projNum;
            IDataModel dm = CreateProjectOperationsUtility.getWebDataModel(projName, null, null, null, null, JavaEEFacetConstants.WEB_24, false);
            try {
                OperationTestCase.runAndVerify(dm);
            }
            catch (Exception e) {
                DeploymentScannerAdditionsTest.fail((String)("Unable to create test web project: " + e.getMessage()));
            }
            IProject p = ResourceUtils.findProject(projName);
            DeploymentScannerAdditionsTest.assertTrue((boolean)p.exists());
            IModule projMod = ServerUtil.getModule((IProject)p);
            wc = s.createWorkingCopy();
            AbstractPublishingTest.setCustomDeployOverride(wc, projMod, "newName.war", null, null);
            s = wc.save(true, null);
            String[] folders = this.getAdditions().getDeployLocationFolders(s);
            DeploymentScannerAdditionsTest.assertEquals((int)1, (int)folders.length);
            DeploymentScannerAdditionsTest.assertTrue((boolean)folders[0].contains("metadata"));
            wc = s.createWorkingCopy();
            AbstractPublishingTest.setCustomDeployOverride(wc, projMod, "newName.war", "/home/user/deploy", null);
            s = wc.save(true, null);
            folders = this.getAdditions().getDeployLocationFolders(s);
            DeploymentScannerAdditionsTest.assertEquals((int)2, (int)folders.length);
            DeploymentScannerAdditionsTest.assertTrue((boolean)folders[0].contains("metadata"));
            DeploymentScannerAdditionsTest.assertTrue((boolean)folders[1].equals("/home/user/deploy"));
        }
        catch (CoreException coreException) {
            DeploymentScannerAdditionsTest.fail((String)"Unable to save changes to server");
        }
    }

    @Test
    public void testRemoteGetsNoAdditionsInvalidMode() {
        IServer s = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, this.serverType);
        try {
            IServerWorkingCopy wc = s.createWorkingCopy();
            ServerProfileModel.setProfile((IServerWorkingCopy)wc, (String)"mock5unknown");
            s = wc.save(true, null);
        }
        catch (CoreException coreException) {
            DeploymentScannerAdditionsTest.fail((String)"Could not set server mode to non-local");
        }
        boolean accepts = new LocalJBoss7DeploymentScannerAdditions().accepts(s);
        DeploymentScannerAdditionsTest.assertFalse((boolean)accepts);
        accepts = new JMXServerDeploymentScannerAdditions().accepts(s);
        DeploymentScannerAdditionsTest.assertFalse((boolean)accepts);
        Job j1 = new LocalJBoss7DeploymentScannerAdditions().getUpdateDeploymentScannerJob(s);
        DeploymentScannerAdditionsTest.assertNull((Object)j1);
        Job j2 = new JMXServerDeploymentScannerAdditions().getUpdateDeploymentScannerJob(s);
        DeploymentScannerAdditionsTest.assertNull((Object)j2);
    }

    @Test
    public void testNoAdditionsRemovalsFromSettings() {
        IServer s = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, this.serverType);
        try {
            IServerWorkingCopy wc = s.createWorkingCopy();
            wc.setAttribute("org.jboss.ide.eclipse.as.core.server.addDeploymentScanner", false);
            wc.setAttribute("org.jboss.ide.eclipse.as.core.server.removeDeploymentScanner", false);
            s = wc.save(true, null);
        }
        catch (CoreException coreException) {
            DeploymentScannerAdditionsTest.fail((String)"Could not set server mode to non-local");
        }
        ((Server)s).setServerState(2);
        ServerExtendedProperties props = (ServerExtendedProperties)s.loadAdapter(ServerExtendedProperties.class, null);
        boolean usesManagement = props != null && props.getMultipleDeployFolderSupport() == 3;
        boolean usesJMX = props != null && props.getMultipleDeployFolderSupport() == 2;
        boolean accepts = new LocalJBoss7DeploymentScannerAdditions().accepts(s);
        DeploymentScannerAdditionsTest.assertEquals((boolean)accepts, (boolean)usesManagement);
        accepts = new JMXServerDeploymentScannerAdditions().accepts(s);
        DeploymentScannerAdditionsTest.assertEquals((boolean)accepts, (boolean)usesJMX);
        Job j1 = new LocalJBoss7DeploymentScannerAdditions().getUpdateDeploymentScannerJob(s);
        DeploymentScannerAdditionsTest.assertNull((Object)j1);
        Job j2 = new JMXServerDeploymentScannerAdditions().getUpdateDeploymentScannerJob(s);
        DeploymentScannerAdditionsTest.assertNull((Object)j2);
        Job j3 = new LocalJBoss7DeploymentScannerAdditions().getRemoveDeploymentScannerJob(s);
        DeploymentScannerAdditionsTest.assertNull((Object)j3);
        Job j4 = new JMXServerDeploymentScannerAdditions().getRemoveDeploymentScannerJob(s);
        DeploymentScannerAdditionsTest.assertNull((Object)j4);
    }

    private AbstractDeploymentScannerAdditions getAdditions() {
        return new AbstractDeploymentScannerAdditions(){

            protected void ensureScannersAdded(IServer server, String[] folders) {
            }

            public boolean accepts(IServer server) {
                return true;
            }

            public void suspendScanners(IServer server) {
            }

            public void resumeScanners(IServer server) {
            }
        };
    }
}

