/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.convertor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.teiid.core.designer.util.ModelType;
import org.teiid.designer.extension.convertor.TeiidPropertyDefinitionConvertor;
import org.teiid.designer.extension.convertor.TranslatorAnnotationVisitor;
import org.teiid.designer.extension.convertor.mxd.MetaclassType;
import org.teiid.designer.extension.convertor.mxd.ModelExtension;
import org.teiid.designer.extension.convertor.mxd.ObjectFactory;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.spi.TeiidPropertyDefinition;

public class MxdConvertor {
    private static final String METAMODEL_URI = "http://www.metamatrix.com/metamodels/Relational";
    private static final String SCHEMA_LOCATION = "http://www.jboss.org/teiiddesigner/ext/2012 http://www.jboss.org/teiiddesigner/ext/2012/modelExtension.xsd";
    private static final String NAMESPACE_URI = "http://www.teiid.org/translator/{NAME}/2014";
    private static MxdConvertor INSTANCE;
    private final ObjectFactory factory = new ObjectFactory();

    public static MxdConvertor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MxdConvertor();
        }
        return INSTANCE;
    }

    private char[] readFromFile(File sourceFile) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sourceFile));
            StringBuilder builder = new StringBuilder();
            String ls = System.getProperty("line.separator");
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(ls);
            }
            char[] cArray = builder.toString().toCharArray();
            return cArray;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public Collection<MetaclassType> read(File sourceFile) throws IOException {
        char[] source = this.readFromFile(sourceFile);
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setKind(8);
        parser.setSource(source);
        parser.setResolveBindings(true);
        CompilationUnit cu = (CompilationUnit)parser.createAST(null);
        TranslatorAnnotationVisitor visitor = new TranslatorAnnotationVisitor();
        cu.accept((ASTVisitor)visitor);
        return visitor.getMetaclasses();
    }

    public Collection<MetaclassType> read(Collection<TeiidPropertyDefinition> extensions) {
        TeiidPropertyDefinitionConvertor defnConvertor = new TeiidPropertyDefinitionConvertor();
        return defnConvertor.getMetaclasses(extensions);
    }

    public void write(String namespacePrefix, ModelType.Type modelType, Collection<MetaclassType> metaClasses, OutputStream output) throws Exception {
        ModelExtension element = this.factory.createModelExtension();
        element.setMetamodelUri(METAMODEL_URI);
        element.setVersion(new BigInteger("1"));
        element.setNamespacePrefix(namespacePrefix);
        String namespaceUri = NAMESPACE_URI.replace("{NAME}", namespacePrefix);
        element.setNamespaceUri(namespaceUri);
        element.getModelType().add(modelType.name());
        element.getExtendedMetaclass().addAll(metaClasses);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ModelExtension.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.schemaLocation", (Object)SCHEMA_LOCATION);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)element, output);
    }

    public boolean convert(ITeiidTranslator translator, OutputStream output) throws Exception {
        Collection extensions = translator.getExtensionPropertyDefinitions();
        if (extensions == null || extensions.isEmpty()) {
            return false;
        }
        String name = translator.getName();
        if (name != null && name.equals("excel")) {
            for (TeiidPropertyDefinition extDefn : extensions) {
                String extName = extDefn.getName();
                if (extName == null || !extName.endsWith("FIRST_DATA_ROW_NUMBER")) continue;
                extDefn.setOwner("org.teiid.metadata.Table");
            }
        }
        try {
            ModelType.Type modelType = ModelType.Type.PHYSICAL;
            Collection<MetaclassType> metaClasses = this.read(extensions);
            this.write(name, modelType, metaClasses, output);
            return true;
        }
        catch (IllegalArgumentException e) {
            throw new Exception(e);
        }
    }
}

