/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.ViewPart;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.IServerRegistryListener;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.ServerRegistryEvent;
import org.jboss.tools.modeshape.rest.actions.AddPublishAreaAction;
import org.jboss.tools.modeshape.rest.actions.DeletePublishAreaAction;
import org.jboss.tools.modeshape.rest.actions.DeleteServerAction;
import org.jboss.tools.modeshape.rest.actions.EditServerAction;
import org.jboss.tools.modeshape.rest.actions.NewServerAction;
import org.jboss.tools.modeshape.rest.actions.ReconnectToServerAction;
import org.jboss.tools.modeshape.rest.domain.ModeShapeDomainObject;
import org.jboss.tools.modeshape.rest.views.ModeShapeContentProvider;

public final class ServerView
extends ViewPart
implements IServerRegistryListener {
    private IAction collapseAllAction;
    private BaseSelectionListenerAction addPublisAreaAction;
    private BaseSelectionListenerAction deleteAction;
    private BaseSelectionListenerAction deletePublisAreaAction;
    private BaseSelectionListenerAction editAction;
    private Action newAction;
    private ModeShapeContentProvider provider;
    private ReconnectToServerAction reconnectAction;
    private TreeViewer viewer;

    private void constructActions() {
        this.collapseAllAction = new Action(){

            public void run() {
                ServerView.this.getViewer().collapseAll();
            }
        };
        this.collapseAllAction.setToolTipText(RestClientI18n.collapseActionToolTip);
        this.collapseAllAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/views/collapse_all.gif"));
        this.reconnectAction = new ReconnectToServerAction(this.viewer);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.reconnectAction);
        Shell shell = this.getSite().getShell();
        this.deleteAction = new DeleteServerAction(shell, this.getServerManager());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        this.editAction = new EditServerAction(shell, this.getServerManager());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.editAction);
        this.newAction = new NewServerAction(shell, this.getServerManager());
        this.addPublisAreaAction = new AddPublishAreaAction(shell, this.getServerManager(), this.viewer);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.addPublisAreaAction);
        this.deletePublisAreaAction = new DeletePublishAreaAction(shell, this.getServerManager(), this.viewer);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.deletePublisAreaAction);
    }

    private void constructContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IAction)this.newAction);
        menuMgr.add((IAction)this.editAction);
        menuMgr.add((IAction)this.deleteAction);
        menuMgr.add((IAction)this.reconnectAction);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)this.addPublisAreaAction);
        menuMgr.add((IAction)this.deletePublisAreaAction);
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void constructToolBar() {
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        toolBar.add((IAction)this.newAction);
        toolBar.add((IAction)this.editAction);
        toolBar.add((IAction)this.deleteAction);
        toolBar.add((IAction)this.reconnectAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.addPublisAreaAction);
        toolBar.add((IAction)this.deletePublisAreaAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add(this.collapseAllAction);
    }

    private void constructTreeViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 268436226);
        this.viewer.setUseHashlookup(true);
        this.provider = new ModeShapeContentProvider();
        this.provider.setViewer(this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        ILabelDecorator decorator = Activator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.provider, decorator));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServerView.this.handleSelectionChanged(event);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                ServerView.this.handleDoubleClick();
            }
        });
        this.viewer.setInput((Object)this.getServerManager());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void createPartControl(Composite parent) {
        this.constructTreeViewer(parent);
        this.constructActions();
        this.constructToolBar();
        this.constructContextMenu();
        this.hookGlobalActions();
        this.setTitleToolTip(RestClientI18n.serverViewToolTip);
        this.getServerManager().addRegistryListener(this);
        this.getServerManager().addRegistryListener(this.provider);
        IWorkbenchHelpSystem helpSystem = Activator.getDefault().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "org.jboss.tools.modeshape.rest.serverViewHelpContext");
    }

    public void dispose() {
        this.getServerManager().removeRegistryListener(this);
        if (this.provider != null) {
            this.getServerManager().removeRegistryListener(this.provider);
        }
        super.dispose();
    }

    IAction getDeleteAction() {
        return this.deleteAction;
    }

    private ServerManager getServerManager() {
        return Activator.getDefault().getServerManager();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    void handleDoubleClick() {
        if (this.editAction.isEnabled()) {
            this.editAction.run();
        }
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        assert (((IStructuredSelection)event.getSelection()).getFirstElement() instanceof ModeShapeDomainObject);
        this.updateStatusLine((IStructuredSelection)event.getSelection());
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && ServerView.this.getDeleteAction().isEnabled()) {
                    ServerView.this.getDeleteAction().run();
                }
            }
        });
        class NoOpAction
        extends Action {
            NoOpAction() {
                this.setEnabled(false);
            }
        }
        NoOpAction noop = new NoOpAction();
        bars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)noop);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)noop);
        bars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)noop);
    }

    @Override
    public Exception[] serverRegistryChanged(ServerRegistryEvent event) {
        if (event.isNew() || event.isUpdate()) {
            this.viewer.refresh();
        } else {
            this.viewer.remove((Object)event.getServer());
        }
        return null;
    }

    public void setFocus() {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    private void updateStatusLine(IStructuredSelection selection) {
        String msg = selection.size() != 1 ? "" : ((ModeShapeDomainObject)selection.getFirstElement()).getShortDescription();
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(msg);
    }
}

