/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.rest.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.rest.Activator;
import org.jboss.tools.modeshape.rest.RestClientI18n;
import org.jboss.tools.modeshape.rest.ServerManager;
import org.jboss.tools.modeshape.rest.domain.ModeShapeServer;

public final class ReconnectJob
extends Job {
    private final ModeShapeServer server;

    public ReconnectJob(ModeShapeServer server) {
        super(NLS.bind((String)RestClientI18n.reconnectJobTaskName, (Object)server.getShortDescription()));
        this.server = server;
    }

    public boolean belongsTo(Object family) {
        return "modeshape.publishing.job.family".equals(family);
    }

    protected IStatus run(IProgressMonitor monitor) {
        ServerManager serverManager = Activator.getDefault().getServerManager();
        try {
            try {
                String taskName = NLS.bind((String)RestClientI18n.reconnectJobTaskName, (Object)this.server.getShortDescription());
                monitor.beginTask(taskName, 1);
                monitor.setTaskName(taskName);
                org.modeshape.web.jcr.rest.client.Status status = serverManager.ping(this.server);
                if (status.isError()) {
                    Activator.getDefault().log(status);
                }
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.modeshape.rest", RestClientI18n.publishJobUnexpectedErrorMsg, (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

