/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.switchyard.tools.models.switchyard1_0.transform.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.switchyard.tools.models.switchyard1_0.switchyard.TransformType;
import org.switchyard.tools.models.switchyard1_0.transform.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.switchyard.tools.models.switchyard1_0.transform.TransformPackage
 * @generated
 */
public class TransformSwitch<T> extends Switch<T> {
	/**
     * The cached model package
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected static TransformPackage modelPackage;

	/**
     * Creates an instance of the switch.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TransformSwitch() {
        if (modelPackage == null) {
            modelPackage = TransformPackage.eINSTANCE;
        }
    }

	/**
     * Checks whether this is a switch for the given package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @parameter ePackage the package in question.
     * @return whether this is a switch for the given package.
     * @generated
     */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
        return ePackage == modelPackage;
    }

	/**
     * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the first non-null result returned by a <code>caseXXX</code> call.
     * @generated
     */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case TransformPackage.DOCUMENT_ROOT: {
                DocumentRoot documentRoot = (DocumentRoot)theEObject;
                T result = caseDocumentRoot(documentRoot);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TransformPackage.DOZER_FILE_ENTRY_TYPE: {
                DozerFileEntryType dozerFileEntryType = (DozerFileEntryType)theEObject;
                T result = caseDozerFileEntryType(dozerFileEntryType);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TransformPackage.DOZER_MAPPING_FILES_TYPE: {
                DozerMappingFilesType dozerMappingFilesType = (DozerMappingFilesType)theEObject;
                T result = caseDozerMappingFilesType(dozerMappingFilesType);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TransformPackage.DOZER_TRANSFORM_TYPE: {
                DozerTransformType dozerTransformType = (DozerTransformType)theEObject;
                T result = caseDozerTransformType(dozerTransformType);
                if (result == null) result = caseTransformType(dozerTransformType);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TransformPackage.JAVA_TRANSFORM_TYPE1: {
                JavaTransformType1 javaTransformType1 = (JavaTransformType1)theEObject;
                T result = caseJavaTransformType1(javaTransformType1);
                if (result == null) result = caseTransformType(javaTransformType1);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TransformPackage.JAXB_TRANSFORM_TYPE: {
                JAXBTransformType jaxbTransformType = (JAXBTransformType)theEObject;
                T result = caseJAXBTransformType(jaxbTransformType);
                if (result == null) result = caseTransformType(jaxbTransformType);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TransformPackage.JSON_TRANSFORM_TYPE: {
                JsonTransformType jsonTransformType = (JsonTransformType)theEObject;
                T result = caseJsonTransformType(jsonTransformType);
                if (result == null) result = caseTransformType(jsonTransformType);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TransformPackage.SMOOKS_TRANSFORM_TYPE1: {
                SmooksTransformType1 smooksTransformType1 = (SmooksTransformType1)theEObject;
                T result = caseSmooksTransformType1(smooksTransformType1);
                if (result == null) result = caseTransformType(smooksTransformType1);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            case TransformPackage.XSLT_TRANSFORM_TYPE: {
                XsltTransformType xsltTransformType = (XsltTransformType)theEObject;
                T result = caseXsltTransformType(xsltTransformType);
                if (result == null) result = caseTransformType(xsltTransformType);
                if (result == null) result = defaultCase(theEObject);
                return result;
            }
            default: return defaultCase(theEObject);
        }
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Document Root</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Document Root</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseDocumentRoot(DocumentRoot object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Dozer File Entry Type</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Dozer File Entry Type</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseDozerFileEntryType(DozerFileEntryType object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Dozer Mapping Files Type</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Dozer Mapping Files Type</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseDozerMappingFilesType(DozerMappingFilesType object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Dozer Transform Type</em>'.
     * <!-- begin-user-doc -->
     * This implementation returns null;
     * returning a non-null result will terminate the switch.
     * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Dozer Transform Type</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
    public T caseDozerTransformType(DozerTransformType object) {
        return null;
    }

    /**
     * Returns the result of interpreting the object as an instance of '<em>Java Transform Type1</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Java Transform Type1</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseJavaTransformType1(JavaTransformType1 object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>JAXB Transform Type</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>JAXB Transform Type</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseJAXBTransformType(JAXBTransformType object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Json Transform Type</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Json Transform Type</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseJsonTransformType(JsonTransformType object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Smooks Transform Type1</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Smooks Transform Type1</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseSmooksTransformType1(SmooksTransformType1 object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Xslt Transform Type</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Xslt Transform Type</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseXsltTransformType(XsltTransformType object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>Transform Type</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>Transform Type</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
     * @generated
     */
	public T caseTransformType(TransformType object) {
        return null;
    }

	/**
     * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
     * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
     * @param object the target of the switch.
     * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
     * @see #doSwitch(org.eclipse.emf.ecore.EObject)
     * @generated
     */
	@Override
	public T defaultCase(EObject object) {
        return null;
    }

} //TransformSwitch
