/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package org.teiid.designer.diagram.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.ui.editors.ModelEditor;


/**
 * AutoLayoutWrapper
 *
 * @since 8.0
 */
public class AutoLayoutWrapper extends DiagramAction
                          implements DiagramUiConstants,
                                     IDiagramActionConstants,
                                     IPartListener,
                                     ActionWrapper {

    /**
     * Construct an instance of AutoLayoutWrapper.
     * 
     */
    public AutoLayoutWrapper() {
        super();
        initialize();
    }

    /**
     * Construct an instance of AutoLayoutWrapper.
     * @param theStyle
     */
    public AutoLayoutWrapper(int theStyle) {
        super(theStyle);
        initialize();
        
    }

    @Override
	public void initialize() {

        setEnableState();
        addAsPartListener();        
    }

	@Override
    protected void doRun() {
        IEditorPart editor = getActiveEditor();
        
        if ( editor != null ) {
             
            AutoLayout autoLayoutMgr = getAutoLayoutManager();
            IAction action = new AutoLayoutAction(autoLayoutMgr);
                         
            ((AutoLayoutAction)action).run();
            
            // after AutoLayoutWrapper operation, reset enable state from the current autoLayoutMgr
            setEnabled( autoLayoutMgr.canAutoLayout() );             
        }   
    }
    
    private void addAsPartListener() {
        getPlugin().getCurrentWorkbenchWindow().getPartService().addPartListener( this );
    }
    
    /**
     *  
     * @see org.teiid.designer.ui.common.actions.AbstractAction#dispose()
     * @since 5.0
     */
    @Override
    public void dispose() {
        getPlugin().getCurrentWorkbenchWindow().getPartService().removePartListener( this );
        super.dispose();
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.ui.ISelectionListener#selectionChanged(IWorkbenchPart, ISelection)
     */
    @Override
    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        // no action here...autolayout does not care about selection        
    }    

    private AutoLayout getAutoLayoutManager() {
        ModelEditor editor = getActiveEditor();

        if ( editor != null && editor.getCurrentPage() instanceof DiagramEditor ) {       
            DiagramEditor deEditorPage = (DiagramEditor)editor.getCurrentPage();
            if ( deEditorPage != null ) {             
                AutoLayout autoLayoutMgr = (AutoLayout)deEditorPage.getAdapter(AutoLayout.class);
                return autoLayoutMgr;
            }
            return null;
        }
        return null;
    }

    
    /* (non-Javadoc)
     * @see org.eclipse.ui.ISelectionListener#selectionChanged(IWorkbenchPart, ISelection)
     */
    public void setEnableState() {

        ModelEditor editor = getActiveEditor();
        
        if ( editor != null && editor.getCurrentPage() instanceof DiagramEditor ) {             
            AutoLayout autoLayoutMgr = getAutoLayoutManager();
            
            if ( autoLayoutMgr != null ) {
//                System.out.println("[AutoLayoutWrapper.setEnableState] about to set using canAutoLayout"); //$NON-NLS-1$
                setEnabled( autoLayoutMgr.canAutoLayout() );                             
            } else {
//                System.out.println("[AutoLayoutWrapper.setEnableState] no autolayoutmgr found; about to set to false"); //$NON-NLS-1$
                setEnabled( false );
            }
        }        
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IPartListener#partActivated(org.eclipse.ui.IWorkbenchPart)
     */
    @Override
	public void partActivated(IWorkbenchPart part) {
        setEnableState();
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IPartListener#partBroughtToTop(org.eclipse.ui.IWorkbenchPart)
     */
    @Override
	public void partBroughtToTop(IWorkbenchPart part) {
        setEnableState();
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IPartListener#partClosed(org.eclipse.ui.IWorkbenchPart)
     */
    @Override
	public void partClosed(IWorkbenchPart part) {
        setEnabled( false );
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IPartListener#partDeactivated(org.eclipse.ui.IWorkbenchPart)
     */
    @Override
	public void partDeactivated(IWorkbenchPart part) {
        setEnabled( false );
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IPartListener#partOpened(org.eclipse.ui.IWorkbenchPart)
     */
    @Override
	public void partOpened(IWorkbenchPart part) {
        setEnableState();
    }
}
