/* Generated By:JJTree: Do not edit this line. OrderBy.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=true,VISITOR=true,TRACK_TOKENS=false,NODE_PREFIX=,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.List;
import org.teiid.designer.query.sql.lang.IOrderBy;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory.ASTNodes;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.runtime.client.Messages;

/**
 *
 */
public class OrderBy extends SimpleNode
    implements IOrderBy<Expression, OrderByItem, LanguageVisitor> {

    private List<OrderByItem> orderByItems = new ArrayList<OrderByItem>();

    /**
     * @param p
     * @param id
     */
    public OrderBy(TeiidParser p, int id) {
        super(p, id);
    }

    @Override
    public List<OrderByItem> getOrderByItems() {
        return this.orderByItems;
    }

    /**
     * Returns the ORDER BY element at the specified index.
     * @param index Index to get
     * @return The element at the index
     */
    public Expression getVariable( int index ) {
        return orderByItems.get(index).getSymbol();
    }

    /**
     * Adds a new variable to the list of order by elements.
     * @param element Element to add
     */
    @Override
    public void addVariable( Expression element ) {
        addVariable(element, true);
    }

    /**
     * Adds a new variable to the list of order by elements with the
     * specified sort order
     * @param element Element to add
     * @param type True for ascending, false for descending
     */
    @Override
    public void addVariable( Expression element, boolean type ) {
        if(element == null)
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0021));

        OrderByItem orderByItem = parser.createASTNode(ASTNodes.ORDER_BY_ITEM);
        orderByItem.setSymbol(element);
        orderByItem.setAscending(type);
        orderByItems.add(orderByItem);
    }

    @Override
    public int getVariableCount() {
        return orderByItems.size();
    }

    /**
     * @param orderIndex
     * @return expression position set during resolving
     */
    public int getExpressionPosition(int orderIndex) {
        return this.orderByItems.get(orderIndex).getExpressionPosition();
    }

    /**
     * @param orderIndex
     * @param selectIndex
     */
    public void setExpressionPosition(int orderIndex, int selectIndex) {
        this.orderByItems.get(orderIndex).setExpressionPosition(selectIndex);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = super.hashCode();
        result = prime * result + ((this.orderByItems == null) ? 0 : this.orderByItems.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!super.equals(obj)) return false;
        if (getClass() != obj.getClass()) return false;
        OrderBy other = (OrderBy)obj;
        if (this.orderByItems == null) {
            if (other.orderByItems != null) return false;
        } else if (!this.orderByItems.equals(other.orderByItems)) return false;
        return true;
    }

    /** Accept the visitor. **/
    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public OrderBy clone() {
        OrderBy clone = new OrderBy(this.parser, this.id);
        clone.getOrderByItems().addAll(cloneList(orderByItems));
        return clone;
    }

}
/* JavaCC - OriginalChecksum=6b23125e8c3c5abfe22f4f4ae93fb66d (do not edit this line) */
