/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import io.fabric8.activemq.facade.BrokerFacade;
import io.fabric8.activemq.facade.ProducerViewFacade;
import java.util.Collection;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.activemq.navigator.ProducerNode;
import org.fusesource.ide.jmx.activemq.navigator.TopicNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class TopicProducersNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;
    private final TopicNode topicNode;

    public TopicProducersNode(TopicNode topicNode) {
        super((Node)topicNode);
        this.topicNode = topicNode;
        this.brokerNode = topicNode.getBrokerNode();
        this.facade = topicNode.getFacade();
    }

    public String toString() {
        return "Producers";
    }

    protected void loadChildren() {
        try {
            Collection list = this.getFacade().getTopicProducers(this.topicNode.getName());
            if (list != null) {
                for (ProducerViewFacade mbean : list) {
                    this.addChild((Node)new ProducerNode((Node)this, (Node)this.topicNode, (ProducerViewMBean)mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("topic_folder.png");
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

