/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.Collections;
import java.util.List;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.fusesource.ide.commons.tree.ConnectedNode;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.NodeSupport;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.jboss.tools.jmx.core.tree.Node;

public class ProducerNode
extends NodeSupport
implements ConnectedNode {
    private final ProducerViewMBean mbean;
    private final Node destinationNode;

    public ProducerNode(Node parent, Node destinationNode, ProducerViewMBean mbean) {
        super(parent);
        this.destinationNode = destinationNode;
        this.mbean = mbean;
        this.setPropertyBean(mbean);
    }

    public Node getDestinationNode() {
        return this.destinationNode;
    }

    public String toString() {
        try {
            return String.valueOf(this.mbean.getClientId()) + "/" + this.mbean.getSessionId();
        }
        catch (Exception exception) {
            this.getRefreshableUI().fireRefresh();
            return "";
        }
    }

    public RefreshableUI getRefreshableUI() {
        if (this instanceof RefreshableUI) {
            return this;
        }
        if (this.parent != null && this.parent instanceof HasRefreshableUI) {
            return ((HasRefreshableUI)this.parent).getRefreshableUI();
        }
        return null;
    }

    public List<Node> getConnectedTo() {
        return Collections.singletonList(this.getDestinationNode());
    }
}

